/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.sql.Time;
import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;


/**
 * 
 * @ejb.bean name="JobStartMaster"
 *           jndi-name="JobStartMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobStartMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobStartMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobStartMasterBean implements javax.ejb.EntityBean {
    protected String job_id;
    protected Integer condition_type;
    protected Integer suspend;
    protected Integer skip;
    protected Integer skip_end_status;
    protected Integer skip_end_value;
    protected  Integer unmatch_end_flg;
    protected Integer unmatch_end_status;
    protected Integer unmatch_end_value;
    protected Integer calendar;
    protected  String  calendar_id;
    protected Integer calendar_end_value;
    protected Integer start_delay;
    protected Integer start_delay_session;
    protected Integer start_delay_session_value;
    protected Integer start_delay_time;
    protected Time start_delay_time_value;
    protected Integer start_delay_condition_type;
    protected Integer start_delay_notify;
    protected Integer start_delay_notify_priority;
    protected Integer start_delay_operation;
    protected Integer start_delay_operation_type;
    protected Integer start_delay_operation_end_value;
    protected Integer end_delay;
    protected Integer end_delay_session;
    protected Integer end_delay_session_value;
    protected Integer end_delay_job;
    protected Integer end_delay_job_value;
    protected Integer end_delay_time;
    protected Time end_delay_time_value;
    protected Integer end_delay_condition_type;
    protected Integer end_delay_notify;
    protected Integer end_delay_notify_priority;
    protected Integer end_delay_operation;
    protected Integer end_delay_operation_type;
    protected Integer end_delay_operation_end_value;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobStartMasterPK ejbCreate(
            String job_id, 
            Integer condition_type, 
            Integer suspend, 
            Integer skip, 
            Integer skip_end_status, 
            Integer skip_end_value, 
            Integer unmatch_end_flg, 
            Integer unmatch_end_status, 
            Integer unmatch_end_value, 
            Integer calendar, 
            String  calendar_id, 
            Integer calendar_end_value, 
            Integer start_delay, 
            Integer start_delay_session, 
            Integer start_delay_session_value, 
            Integer start_delay_time, 
            Time start_delay_time_value, 
            Integer start_delay_condition_type, 
            Integer start_delay_notify, 
            Integer start_delay_notify_priority, 
            Integer start_delay_operation, 
            Integer start_delay_operation_type, 
            Integer start_delay_operation_end_value, 
            Integer end_delay, 
            Integer end_delay_session, 
            Integer end_delay_session_value, 
            Integer end_delay_job, 
            Integer end_delay_job_value, 
            Integer end_delay_time, 
            Time end_delay_time_value, 
            Integer end_delay_condition_type, 
            Integer end_delay_notify, 
            Integer end_delay_notify_priority, 
            Integer end_delay_operation, 
            Integer end_delay_operation_type, 
            Integer end_delay_operation_end_value
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.condition_type = condition_type;
        this.suspend = suspend;
        this.skip = skip;
        this.skip_end_status = skip_end_status;
        this.skip_end_value = skip_end_value;
        this.unmatch_end_flg = unmatch_end_flg;
        this.unmatch_end_status = unmatch_end_status;
        this.unmatch_end_value = unmatch_end_value;
        this.calendar = calendar;
        this.calendar_id = calendar_id;
        this.calendar_end_value = calendar_end_value;
        this.start_delay = start_delay;
        this.start_delay_session = start_delay_session;
        this.start_delay_session_value = start_delay_session_value;
        this.start_delay_time = start_delay_time;
        this.start_delay_time_value = start_delay_time_value;
        this.start_delay_condition_type = start_delay_condition_type;
        this.start_delay_notify = start_delay_notify;
        this.start_delay_notify_priority = start_delay_notify_priority;
        this.start_delay_operation = start_delay_operation;
        this.start_delay_operation_type = start_delay_operation_type;
        this.start_delay_operation_end_value = start_delay_operation_end_value;
        this.end_delay = end_delay;
        this.end_delay_session = end_delay_session;
        this.end_delay_session_value = end_delay_session_value;
        this.end_delay_job = end_delay_job;
        this.end_delay_job_value = end_delay_job_value;
        this.end_delay_time = end_delay_time;
        this.end_delay_time_value = end_delay_time_value;
        this.end_delay_condition_type = end_delay_condition_type;
        this.end_delay_notify = end_delay_notify;
        this.end_delay_notify_priority = end_delay_notify_priority;
        this.end_delay_operation = end_delay_operation;
        this.end_delay_operation_type = end_delay_operation_type;
        this.end_delay_operation_end_value = end_delay_operation_end_value;
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobStartMasterPK ejbFindByPrimaryKey(JobStartMasterPK pk) throws FinderException {
		return null;
	}
    
    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }
    
    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
    /**
     * @return the condition_type
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getCondition_type() {
    	return condition_type;
    }
    
    /**
     * @param java.lang.Integer the new condition_type value
     * @ejb.interface-method
     */
    public void setCondition_type(java.lang.Integer condition_type) {
    	this.condition_type = condition_type;
    }
    
    /**
     * @return the suspend
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getSuspend() {
    	return suspend;
    }
    
    /**
     * @param java.lang.Integer the new suspend value
     * @ejb.interface-method
     */
    public void setSuspend(java.lang.Integer suspend) {
    	this.suspend = suspend;
    }
    
    /**
     * @return the skip
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getSkip() {
    	return skip;
    }
    
    /**
     * @param java.lang.Integer the new skip value
     * @ejb.interface-method
     */
    public void setSkip(java.lang.Integer skip) {
    	this.skip = skip;
    }
    
    /**
     * @return the skip_end_status
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getSkip_end_status() {
    	return skip_end_status;
    }
    
    /**
     * @param java.lang.Integer the new skip_end_status value
     * @ejb.interface-method
     */
    public void setSkip_end_status(
            java.lang.Integer skip_end_status) {
    	this.skip_end_status = skip_end_status;
    }
    
    /**
     * @return the skip_end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getSkip_end_value() {
    	return skip_end_value;
    }
    
    /**
     * @param java.lang.Integer the new skip_end_value value
     * @ejb.interface-method
     */
    public void setSkip_end_value(
            java.lang.Integer skip_end_value) {
    	this.skip_end_value = skip_end_value;
    }
    
    /**
     * @return the unmatch_end_flg
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getUnmatch_end_flg() {
    	return unmatch_end_flg;
    }
    
    /**
     * @param java.lang.Integer the new unmatch_end_flg value
     * @ejb.interface-method
     */
    public void setUnmatch_end_flg(java.lang.Integer unmatch_end_flg) {
    	this.unmatch_end_flg = unmatch_end_flg;
    }
    
    /**
     * @return the unmatch_end_status
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getUnmatch_end_status() {
    	return unmatch_end_status;
    }
    
    /**
     * @param java.lang.Integer the new unmatch_end_status value
     * @ejb.interface-method
     */
    public void setUnmatch_end_status(
            java.lang.Integer unmatch_end_status) {
    	this.unmatch_end_status = unmatch_end_status;
    }
    
    /**
     * @return the unmatch_end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getUnmatch_end_value() {
    	return unmatch_end_value;
    }
    
    /**
     * @param java.lang.Integer the new unmatch_end_value value
     * @ejb.interface-method
     */
    public void setUnmatch_end_value(java.lang.Integer unmatch_end_value) {
    	this.unmatch_end_value = unmatch_end_value;
    }
    
    /**
     * @return the calendar
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getCalendar() {
    	return calendar;
    }
    
    /**
     * @param java.lang.Integer the new calendar value
     * @ejb.interface-method
     */
    public void setCalendar(java.lang.Integer calendar) {
    	this.calendar = calendar;
    }
    
    /**
     * @return the calendar_id
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.String getCalendar_id() {
    	return calendar_id;
    }
    
    /**
     * @param java.lang.String the new calendar_id value
     * @ejb.interface-method
     */
    public void setCalendar_id(java.lang.String calendar_id) {
    	this.calendar_id = calendar_id;
    }
    
    /**
     * @return the calendar_end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getCalendar_end_value() {
    	return calendar_end_value;
    }
    
    /**
     * @param java.lang.Integer the new calendar_end_value value
     * @ejb.interface-method
     */
    public void setCalendar_end_value(java.lang.Integer calendar_end_value) {
    	this.calendar_end_value = calendar_end_value;
    }

    /**
     * @return the start_delay
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay() {
    	return start_delay;
    }
    
    /**
     * @param java.lang.Integer the new start_delay value
     * @ejb.interface-method
     */
    public void setStart_delay(java.lang.Integer start_delay) {
    	this.start_delay = start_delay;
    }
    
    /**
     * @return the start_delay_session
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_session() {
    	return start_delay_session;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_session value
     * @ejb.interface-method
     */
    public void setStart_delay_session(java.lang.Integer start_delay_session) {
    	this.start_delay_session = start_delay_session;
    }
    
    /**
     * @return the start_delay_session_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_session_value() {
    	return start_delay_session_value;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_session_value value
     * @ejb.interface-method
     */
    public void setStart_delay_session_value(java.lang.Integer start_delay_session_value) {
    	this.start_delay_session_value = start_delay_session_value;
    }
    
    /**
     * @return the start_delay_time
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_time() {
    	return start_delay_time;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_time value
     * @ejb.interface-method
     */
    public void setStart_delay_time(java.lang.Integer start_delay_time) {
    	this.start_delay_time = start_delay_time;
    }
    
    /**
     * @return the start_delay_time_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.sql.Time getStart_delay_time_value() {
    	return start_delay_time_value;
    }

    /**
     * @param java.util.Date the new start_delay_time_value value
     * @ejb.interface-method
     */
    public void setStart_delay_time_value(java.sql.Time start_delay_time_value) {
    	this.start_delay_time_value = start_delay_time_value;
    }
    
    /**
     * @return the start_delay_condition_type
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_condition_type() {
    	return start_delay_condition_type;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_condition_type value
     * @ejb.interface-method
     */
    public void setStart_delay_condition_type(java.lang.Integer start_delay_condition_type) {
    	this.start_delay_condition_type = start_delay_condition_type;
    }
    
    /**
     * @return the start_delay_notify
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_notify() {
    	return start_delay_notify;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_notify value
     * @ejb.interface-method
     */
    public void setStart_delay_notify(java.lang.Integer start_delay_notify) {
    	this.start_delay_notify = start_delay_notify;
    }
    
    /**
     * @return the start_delay_notify_priority
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_notify_priority() {
    	return start_delay_notify_priority;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_notify_priority value
     * @ejb.interface-method
     */
    public void setStart_delay_notify_priority(java.lang.Integer start_delay_notify_priority) {
    	this.start_delay_notify_priority = start_delay_notify_priority;
    }
    
    /**
     * @return the start_delay_operation
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_operation() {
    	return start_delay_operation;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_operation value
     * @ejb.interface-method
     */
    public void setStart_delay_operation(java.lang.Integer start_delay_operation) {
    	this.start_delay_operation = start_delay_operation;
    }
    
    /**
     * @return the start_delay_operation_type
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_operation_type() {
    	return start_delay_operation_type;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_operation_type value
     * @ejb.interface-method
     */
    public void setStart_delay_operation_type(java.lang.Integer start_delay_operation_type) {
    	this.start_delay_operation_type = start_delay_operation_type;
    }
    
    /**
     * @return the start_delay_operation_end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStart_delay_operation_end_value() {
    	return start_delay_operation_end_value;
    }
    
    /**
     * @param java.lang.Integer the new start_delay_operation_end_value value
     * @ejb.interface-method
     */
    public void setStart_delay_operation_end_value(java.lang.Integer start_delay_operation_end_value) {
    	this.start_delay_operation_end_value = start_delay_operation_end_value;
    }
    
    /**
     * @return the end_delay
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay() {
    	return end_delay;
    }
    
    /**
     * @param java.lang.Integer the new end_delay value
     * @ejb.interface-method
     */
    public void setEnd_delay(java.lang.Integer end_delay) {
    	this.end_delay = end_delay;
    }
    
    /**
     * @return the end_delay_session
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_session() {
    	return end_delay_session;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_session value
     * @ejb.interface-method
     */
    public void setEnd_delay_session(java.lang.Integer end_delay_session) {
    	this.end_delay_session = end_delay_session;
    }
    
    /**
     * @return the end_delay_session_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_session_value() {
    	return end_delay_session_value;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_session_value value
     * @ejb.interface-method
     */
    public void setEnd_delay_session_value(java.lang.Integer end_delay_session_value) {
    	this.end_delay_session_value = end_delay_session_value;
    }
    
    /**
     * @return the end_delay_job
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_job() {
    	return end_delay_job;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_job value
     * @ejb.interface-method
     */
    public void setEnd_delay_job(java.lang.Integer end_delay_job) {
    	this.end_delay_job = end_delay_job;
    }
    
    /**
     * @return the end_delay_job_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_job_value() {
    	return end_delay_job_value;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_job_value value
     * @ejb.interface-method
     */
    public void setEnd_delay_job_value(java.lang.Integer end_delay_job_value) {
    	this.end_delay_job_value = end_delay_job_value;
    }

    /**
     * @return the end_delay_time
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_time() {
    	return end_delay_time;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_time value
     * @ejb.interface-method
     */
    public void setEnd_delay_time(java.lang.Integer end_delay_time) {
    	this.end_delay_time = end_delay_time;
    }
    
    /**
     * @return the end_delay_time_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.sql.Time getEnd_delay_time_value() {
    	return end_delay_time_value;
    }

    /**
     * @param java.util.Date the new end_delay_time_value value
     * @ejb.interface-method
     */
    public void setEnd_delay_time_value(java.sql.Time end_delay_time_value) {
    	this.end_delay_time_value = end_delay_time_value;
    }
    
    /**
     * @return the end_delay_condition_type
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_condition_type() {
    	return end_delay_condition_type;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_condition_type value
     * @ejb.interface-method
     */
    public void setEnd_delay_condition_type(java.lang.Integer end_delay_condition_type) {
    	this.end_delay_condition_type = end_delay_condition_type;
    }
    
    /**
     * @return the end_delay_notify
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_notify() {
    	return end_delay_notify;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_notify value
     * @ejb.interface-method
     */
    public void setEnd_delay_notify(java.lang.Integer end_delay_notify) {
    	this.end_delay_notify = end_delay_notify;
    }
    
    /**
     * @return the end_delay_notify_priority
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_notify_priority() {
    	return end_delay_notify_priority;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_notify_priority value
     * @ejb.interface-method
     */
    public void setEnd_delay_notify_priority(java.lang.Integer end_delay_notify_priority) {
    	this.end_delay_notify_priority = end_delay_notify_priority;
    }
    
    /**
     * @return the end_delay_operation
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_operation() {
    	return end_delay_operation;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_operation value
     * @ejb.interface-method
     */
    public void setEnd_delay_operation(java.lang.Integer end_delay_operation) {
    	this.end_delay_operation = end_delay_operation;
    }
    
    /**
     * @return the end_delay_operation_type
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_operation_type() {
    	return end_delay_operation_type;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_operation_type value
     * @ejb.interface-method
     */
    public void setEnd_delay_operation_type(java.lang.Integer end_delay_operation_type) {
    	this.end_delay_operation_type = end_delay_operation_type;
    }
    
    /**
     * @return the end_delay_operation_end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_delay_operation_end_value() {
    	return end_delay_operation_end_value;
    }
    
    /**
     * @param java.lang.Integer the new end_delay_operation_end_value value
     * @ejb.interface-method
     */
    public void setEnd_delay_operation_end_value(java.lang.Integer end_delay_operation_end_value) {
    	this.end_delay_operation_end_value = end_delay_operation_end_value;
    }
    
    //	==========================================
    //	 CMR fields
    //	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobMasterLocal getJobMaster() {
    	JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     * 
     */
    public Collection getJobStartJobMaster() {
    	Collection collection = null;
		try {
			collection = JobStartJobMasterUtil.getLocalHome().findByJobId(getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     * 
     */
    public JobStartTimeMasterLocal getJobStartTimeMaster() {
    	JobStartTimeMasterLocal jobStartTimeMaster = null;
		try {
			jobStartTimeMaster = JobStartTimeMasterUtil.getLocalHome().findByPrimaryKey(new JobStartTimeMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobStartTimeMaster;
	}
}
