/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl;


/**
 * 
 * @ejb.bean name="JobSessionNode"
 *           jndi-name="JobSessionNode"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobSessionNodeDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobSessionNodeDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobSessionNodeBean implements javax.ejb.EntityBean {
    protected String session_id;
    protected String job_id;
    protected String facility_id;
    protected String node_name;
    protected Integer status;
    protected Date start_date;
    protected Date end_date;
    protected Integer end_value;
    protected String message;
    protected Integer agent_check;
    protected Date check_date;
    protected Integer retry_count;
    protected String result;
    protected Integer status_buffer;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobSessionNodePK ejbCreate(
            String session_id, 
            String job_id, 
            String facility_id, 
            String node_name, 
            Integer status, 
            Date start_date, 
            Date end_date, 
            Integer end_value, 
            String message, 
            Integer agent_check, 
            Date check_date, 
            Integer retry_count, 
            String result, 
            Integer status_buffer
    ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.facility_id = facility_id;
        this.node_name = node_name;
        this.status = status;
        this.start_date = start_date;
        this.end_date = end_date;
        this.end_value = end_value;
        this.message = message;
        this.agent_check = agent_check;
        this.check_date = check_date;
        this.retry_count = retry_count;
        this.result = result;
        this.status_buffer = status_buffer;
        return null;
    }
    
    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobSessionNodePK ejbFindByPrimaryKey(JobSessionNodePK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindBySessionIdAndJobId(java.lang.String sessionId, java.lang.String jobId) throws FinderException {
		return null;
	}
    
    /**
     * @return the session_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getSession_id() {
    	return session_id;
    }
    
    /**
     * @param java.lang.String the new session_id value
     * @ejb.interface-method
     */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }
    
    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }
    
    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }
    
    /**
     * @return the facility_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getFacility_id() {
    	return facility_id;
    }
    
    /**
     * @param java.lang.String the new facility_id value
     * @ejb.interface-method
     */
    public void setFacility_id(java.lang.String facility_id) {
    	this.facility_id = facility_id;
    }
    
    /**
     * @return the node_name
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.String getNode_name() {
    	return node_name;
    }
    
    /**
     * @param java.lang.String the new node_name value
     * @ejb.interface-method
     */
    public void setNode_name(java.lang.String node_name) {
    	this.node_name = node_name;
    }
    
    /**
     * @return the status
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStatus() {
    	return status;
    }
    
    /**
     * @param java.lang.Integer the new status value
     * @ejb.interface-method
     */
    public void setStatus(java.lang.Integer status) {
    	this.status = status;
    }
    
    /**
     * @return the start_date
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.util.Date getStart_date() {
    	return start_date;
    }
    
    /**
     * @param java.util.Date the new start_date value
     * @ejb.interface-method
     */
    public void setStart_date(java.util.Date start_date) {
    	this.start_date = start_date;
    }
    
    /**
     * @return the end_date
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.util.Date getEnd_date() {
    	return end_date;
    }
    
    /**
     * @param java.util.Date the new end_date value
     * @ejb.interface-method
     */
    public void setEnd_date(java.util.Date end_date) {
    	this.end_date = end_date;
    }
    
    /**
     * @return the end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_value() {
    	return end_value;
    }
    
    /**
     * @param java.lang.Integer the new end_value value
     * @ejb.interface-method
     */
    public void setEnd_value(java.lang.Integer end_value) {
    	this.end_value = end_value;
    }
    
    /**
     * @return the message
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.String getMessage() {
    	return message;
    }
    
    /**
     * @param java.lang.String the new message value
     * @ejb.interface-method
     */
    public void setMessage(java.lang.String message) {
    	this.message = message;
    }
    
    /**
     * @return the agent_check
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getAgent_check() {
    	return agent_check;
    }
    
    /**
     * @param java.lang.Integer the new agent_check value
     * @ejb.interface-method
     */
    public void setAgent_check(java.lang.Integer agent_check) {
    	this.agent_check = agent_check;
    }
    
    /**
     * @return the check_date
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.util.Date getCheck_date() {
    	return check_date;
    }
    
    /**
     * @param java.util.Date the new check_date value
     * @ejb.interface-method
     */
    public void setCheck_date(java.util.Date check_date) {
    	this.check_date = check_date;
    }
    
    /**
     * @return the retry_count
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getRetry_count() {
    	return retry_count;
    }
    
    /**
     * @param java.lang.Integer the new retry_count value
     * @ejb.interface-method
     */
    public void setRetry_count(java.lang.Integer retry_count) {
    	this.retry_count = retry_count;
    }
    
	/**
	 * @return the result
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getResult() {
		return result;
	}
	
	/**
	 * @param java.lang.String the new result value
	 * @ejb.interface-method
	 */
	public void setResult(java.lang.String result) {
		this.result = result;
	}
	
    /**
     * @return the status_buffer
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStatus_buffer() {
    	return status_buffer;
    }
    
    /**
     * @param java.lang.Integer the new status_buffer value
     * @ejb.interface-method
     */
    public void setStatus_buffer(java.lang.Integer status_buffer) {
    	this.status_buffer = status_buffer;
    }
	
    //	==========================================
    //	 CMR fields
    //	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobSessionJobLocal getJobSessionJob() {
    	JobSessionJobLocal jobSessionJob = null;
		try {
			jobSessionJob = JobSessionJobUtil.getLocalHome().findByPrimaryKey(new JobSessionJobPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSessionJob;
	}
    
    
    
    /**
     * @ejb.home-method view-type="both"
     * @param sessionId
     * @param jobs
     * @throws javax.ejb.CreateException
     */
    public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException{
    	JobSessionNodeDAOImpl jsnDAO = new JobSessionNodeDAOImpl(); 
    	
    	jsnDAO.makeSession(sessionId, jobs);
    }
    
}
