/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl;

/**
 * 
 * @ejb.bean name="JobSessionJob"
 *           jndi-name="JobSessionJob"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobSessionJobDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobSessionJobDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobSessionJobBean implements javax.ejb.EntityBean {
    protected String session_id;
    protected String job_id;
    protected String scope_text;
    protected Integer status;
    protected Date start_date;
    protected Date end_date;
    protected Integer end_value;
    protected Integer end_status;
    protected String result;
    protected Integer end_staus_check_flg;
    protected Integer delay_notify_flg;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobSessionJobPK ejbCreate(
            String session_id, 
            String job_id, 
            String scope_text, 
            Integer status, 
            Date start_date, 
            Date end_date, 
            Integer end_value, 
            Integer end_status, 
            String result, 
            Integer end_staus_check_flg, 
            Integer delay_notify_flg
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.status = status;
        this.start_date = start_date;
        this.end_date = end_date;
        this.end_value = end_value;
        this.end_status = end_status;
        this.result = result;
        this.end_staus_check_flg = end_staus_check_flg;
        this.delay_notify_flg = delay_notify_flg;
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobSessionJobPK ejbFindByPrimaryKey(JobSessionJobPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindBySessionId(java.lang.String sessionId) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByStatus(java.lang.Integer status) throws FinderException {
		return null;
	}

    /**
     * @return the session_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getSession_id() {
    	return session_id;
    }

    /**
     * @param java.lang.String the new session_id value
     * @ejb.interface-method
     */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the scope_text
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.String getScope_text() {
    	return scope_text;
    }

    /**
     * @param java.lang.String the new scope_text value
     * @ejb.interface-method
     */
    public void setScope_text(java.lang.String scope_text) {
    	this.scope_text = scope_text;
    }

    /**
     * @return the status
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getStatus() {
    	return status;
    }

    /**
     * @param java.lang.Integer the new status value
     * @ejb.interface-method
     */
    public void setStatus(java.lang.Integer status) {
    	this.status = status;
    }

    /**
     * @return the start_date
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.util.Date getStart_date() {
    	return start_date;
    }

    /**
     * @param java.util.Date the new start_date value
     * @ejb.interface-method
     */
    public void setStart_date(java.util.Date start_date) {
    	this.start_date = start_date;
    }

    /**
     * @return the end_date
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.util.Date getEnd_date() {
    	return end_date;
    }

    /**
     * @param java.util.Date the new end_date value
     * @ejb.interface-method
     */
    public void setEnd_date(java.util.Date end_date) {
    	this.end_date = end_date;
    }
    
    /**
     * @return the end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_value() {
    	return end_value;
    }

    /**
     * @param java.lang.Integer the new end_value value
     * @ejb.interface-method
     */
    public void setEnd_value(java.lang.Integer end_value) {
    	this.end_value = end_value;
    }

    /**
     * @return the end_status
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_status() {
    	return end_status;
    }

    /**
     * @param java.lang.Integer the new end_status value
     * @ejb.interface-method
     */
    public void setEnd_status(java.lang.Integer end_status) {
    	this.end_status = end_status;
    }
    
	/**
	 * @return the result
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getResult() {
		return result;
	}
	
	/**
	 * @param java.lang.String the new result value
	 * @ejb.interface-method
	 */
	public void setResult(java.lang.String result) {
		this.result = result;
	}
	
	/**
	 * @return the end_staus_check_flg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getEnd_staus_check_flg() {
		return end_staus_check_flg;
	}
	
	/**
	 * @param java.lang.Integer the new end_staus_check_flg value
	 * @ejb.interface-method
	 */
	public void setEnd_staus_check_flg(java.lang.Integer end_staus_check_flg) {
		this.end_staus_check_flg = end_staus_check_flg;
	}
	
	/**
	 * @return the delay_notify_flg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getDelay_notify_flg() {
		return delay_notify_flg;
	}
	
	/**
	 * @param java.lang.Integer the new delay_notify_flg value
	 * @ejb.interface-method
	 */
	public void setDelay_notify_flg(java.lang.Integer delay_notify_flg) {
		this.delay_notify_flg = delay_notify_flg;
	}

	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobSessionLocal getJobSession() {
    	JobSessionLocal jobSession = null;
		try {
			jobSession = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(getSession_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobSession;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     */
    public Collection getJobSessionNode() {
    	Collection collection = null;
		try {
			collection = JobSessionNodeUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobInfoLocal getJobInfo() {
    	JobInfoLocal jobInfo = null;
		try {
			jobInfo = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobInfo;
	}
    
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobRelationInfoLocal getJobRelationInfo() {
    	JobRelationInfoLocal jobRelationInfo = null;
		try {
			jobRelationInfo = JobRelationInfoUtil.getLocalHome().findBySessionIdAndJobId(getSession_id(), getJob_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobRelationInfo;
	}
    
    /**
     * @ejb.home-method view-type="both"
     * @param sessionId
     * @param jobs
     * @throws javax.ejb.CreateException
     */
    public void ejbHomeMakeSession(String sessionId,Collection jobs) throws javax.ejb.CreateException{
    	
    	JobSessionJobDAOImpl jsjDAO = new JobSessionJobDAOImpl(); 
    	
    	jsjDAO.makeSession(sessionId,jobs);
    }
    
}
