/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.factory.CreateFileJob;
import com.clustercontrol.jobmanagement.factory.CreateSessionId;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * 
 * @ejb.bean name="JobSession"
 *           jndi-name="JobSession"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobSessionDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobSessionDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobSessionBean implements javax.ejb.EntityBean {
    protected static Log m_log = LogFactory.getLog( JobSessionBean.class );
    
    protected String session_id;
    protected String job_id;
    protected Date schedule_date;
    protected Integer operation_flg;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobSessionPK ejbCreate(
            String session_id, 
            String job_id, 
            Date schedule_date, 
            Integer operation_flg
            ) throws javax.ejb.CreateException {
        this.session_id = session_id;
        this.job_id = job_id;
        this.schedule_date = schedule_date;
        this.operation_flg = operation_flg;
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobSessionPK ejbFindByPrimaryKey(JobSessionPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindHistoryFilter(
	        Date startFromDate, 
	        Date startToDate, 
	        Date endFromDate, 
	        Date endToDate, 
	        String jobId, 
	        Integer status) throws FinderException {
		return null;
	}

    /**
     * @return the session_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getSession_id() {
    	return session_id;
    }

    /**
     * @param java.lang.String the new session_id value
     * @ejb.interface-method
     */
    public void setSession_id(java.lang.String session_id) {
    	this.session_id = session_id;
    }

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the schedule_date
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.util.Date getSchedule_date() {
    	return schedule_date;
    }

    /**
     * @param java.util.Date the new schedule_date value
     * @ejb.interface-method
     */
    public void setSchedule_date(java.util.Date schedule_date) {
    	this.schedule_date = schedule_date;
    }

    /**
     * @return the operation_flg
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getOperation_flg() {
    	return operation_flg;
    }

    /**
     * @param java.lang.Integer the new operation_flg value
     * @ejb.interface-method
     */
    public void setOperation_flg(java.lang.Integer operation_flg) {
    	this.operation_flg = operation_flg;
    }
    
	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public Collection getJobSessionJob() {
    	Collection collection = null;
		try {
			collection = JobSessionJobUtil.getLocalHome().findBySessionId(getSession_id());
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return collection;
	}
	
    /**
     * @ejb.home-method view-type="both"
     * 
     * @param jobId
     * @param info
     * @return
     * @throws CreateException
     * @throws FinderException
     * @throws NamingException
     */
    public String ejbHomeMakeSession(String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException{
    	
		String sessionId=null;

		JobMasterLocal job;
		try {
			job = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));

			if(job != null){
				
				sessionId = CreateSessionId.create();
				
				//JobSession
				JobSessionUtil.getLocalHome().create(
						sessionId, 
						job.getJob_id(), 
						new Date(), 
						new Integer(0));
			}
		} catch (CreateException e) {
			throw e;
		}catch (FinderException e) {
			throw e;
		}catch (NamingException e) {
			throw e;
		}

		Collection jobs;
		Collection fileJobs;
		try {
			jobs = JobRelationMasterUtil.getLocalHome().getJobsList(jobId);	
			
			//JobSessionJob
			JobSessionJobUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobRelationInfo
			JobRelationInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobInfo
			JobInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobStartInfo
			JobStartInfoUtil.getLocalHome().makeSession(sessionId,jobs);		
			
			//JobStartJobInfo
			JobStartJobInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobStartTimeInfo
			JobStartTimeInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobStartTimeInfo
			JobParamInfoUtil.getLocalHome().makeSession(sessionId,jobId,info);
			
			//JobCommandInfo
			JobCommandInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobSessionNode
			JobSessionNodeUtil.getLocalHome().makeSession(sessionId,jobs);		
			
			//JobFileInfo
			fileJobs=JobFileInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			
			//JobNoticeInfo
			JobNoticeInfoUtil.getLocalHome().makeSession(sessionId,jobs);
			
			//JobEndInfo
			JobEndInfoUtil.getLocalHome().makeSession(sessionId,jobs);
		
			
			
			Iterator it = fileJobs.iterator();
			Hashtable ht = null;
			
			while(it.hasNext()){
				ht = (Hashtable)it.next();
				jobId=(String)ht.get("jobId");
				job = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(jobId));
				
				new CreateFileJob().createGetFileListJob(job, sessionId);
			}
			
		} catch (FinderException e) {
			throw e;
		} catch (NamingException e) {
			throw e;
		}
		
		return sessionId;
	}
}
