/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

import com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * 
 * @ejb.bean name="JobParamInfo"
 *           jndi-name="JobParamInfo"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobParamInfoDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobParamInfoDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobParamInfoBean implements javax.ejb.EntityBean {
	
	protected String session_id;
	protected String job_id;
	protected String param_id;
	protected Integer param_type;
	protected String description;
	protected String value;
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public JobParamInfoPK ejbCreate(
			String session_id, 
			String job_id, 
			String param_id, 
			Integer param_type, 
			String description, 
			String value
	) throws javax.ejb.CreateException {
		this.session_id = session_id;
		this.job_id = job_id;
		this.param_id = param_id;
		this.param_type = param_type;
		this.description = description;
		this.value = value;
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobParamInfoPK ejbFindByPrimaryKey(JobParamInfoPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		return null;
	}
	
	public Collection ejbFindBySessionIdAndParamId(String session_id, String param_id) throws FinderException {
		return null;
	}
	
	/**
	 * @return the session_id
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getSession_id() {
		return session_id;
	}
	
	/**
	 * @param java.lang.String the new session_id value
	 * @ejb.interface-method
	 */
	public void setSession_id(java.lang.String session_id) {
		this.session_id = session_id;
	}
	
	/**
	 * @return the job_id
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getJob_id() {
		return job_id;
	}
	
	/**
	 * @param java.lang.String the new job_id value
	 * @ejb.interface-method
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * @return the param_id
	 * @ejb.persistent-field 
	 * @ejb.pk-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getParam_id() {
		return param_id;
	}
	
	/**
	 * @param java.lang.String the new param_id value
	 * @ejb.interface-method
	 */
	public void setParam_id(java.lang.String param_id) {
		this.param_id = param_id;
	}
	
	/**
	 * @return the param_type
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getParam_type() {
		return param_type;
	}
	
	/**
	 * @param java.lang.Integer the new param_type value
	 * @ejb.interface-method
	 */
	public void setParam_type(java.lang.Integer param_type) {
		this.param_type = param_type;
	}
	
	/**
	 * @return the description
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getDescription() {
		return description;
	}
	
	/**
	 * @param java.lang.String the new description value
	 * @ejb.interface-method
	 */
	public void setDescription(java.lang.String description) {
		this.description = description;
	}
	
	/**
	 * @return the value
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getValue() {
		return value;
	}
	
	/**
	 * @param java.lang.String the new value value
	 * @ejb.interface-method
	 */
	public void setValue(java.lang.String value) {
		this.value = value;
	}
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
	public JobInfoLocal getJobInfo() {
		JobInfoLocal jobInfo = null;
		try {
			jobInfo = JobInfoUtil.getLocalHome().findByPrimaryKey(new JobInfoPK(getSession_id(), getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobInfo;
	}
	
    /**
     * @ejb.home-method view-type="both"
     * @param sessionId
     * @param jobs
     * @throws javax.ejb.CreateException
     * @throws NamingException 
     * @throws FinderException 
     */
    public void ejbHomeMakeSession(String sessionId, String jobId, LogOutputInfo info) throws javax.ejb.CreateException, FinderException, NamingException{
    	JobParamInfoDAOImpl jciDAO = new JobParamInfoDAOImpl(); 
    	
    	jciDAO.makeSession(sessionId, jobId, info);
    }
	
}
