/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * 
 * @ejb.bean name="JobFileMaster"
 *           jndi-name="JobFileMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobFileMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobFileMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobFileMasterBean implements javax.ejb.EntityBean {
	protected String job_id;
	protected Integer process_mode;
	protected String src_facility_id;
	protected String dest_facility_id;
	protected String src_file;
	protected String src_work_dir;
	protected String dest_directory;
	protected String dest_work_dir;
	protected Integer compression_flg; 
	protected Integer check_flg;
	protected String effective_user;
	
	/**
	 *
	 * <!-- begin-user-doc -->
	 * The  ejbCreate method.
	 * <!-- end-user-doc -->
	 *
	 * <!-- begin-xdoclet-definition --> 
	 * @ejb.create-method 
	 * <!-- end-xdoclet-definition --> 
	 * @generated
	 */
	public JobFileMasterPK ejbCreate(
			String job_id, 
			Integer process_mode, 
			String src_facility_id, 
			String dest_facility_id, 
			String src_file, 
			String src_work_dir, 
			String dest_directory, 
			String dest_work_dir, 
			Integer compression_flg, 
			Integer check_flg, 
			String effective_user
	) throws javax.ejb.CreateException {
		this.job_id = job_id;
		this.process_mode = process_mode;
		this.src_facility_id = src_facility_id;
		this.dest_facility_id = dest_facility_id;
		this.src_file = src_file;
		this.src_work_dir = src_work_dir;
		this.dest_directory = dest_directory;
		this.dest_work_dir = dest_work_dir;
		this.compression_flg = compression_flg;
		this.check_flg = check_flg;
		this.effective_user = effective_user;
		return null;
	}
	
	/**
	 * <!-- begin-user-doc -->
	 * The container invokes this method immediately after it calls ejbCreate.
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void ejbPostCreate() throws javax.ejb.CreateException {
		// begin-user-code
		// end-user-code
	}
	
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobFileMasterPK ejbFindByPrimaryKey(JobFileMasterPK pk) throws FinderException {
		return null;
	}
	
    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field
     * @ejb.interface-method
     */
	public java.lang.String getJob_id() {
		return job_id;
	}

	/**
	 * @param java.lang.String the new job_id value
	 * @ejb.interface-method
	 */
	public void setJob_id(java.lang.String job_id) {
		this.job_id = job_id;
	}
	
	/**
	 * @return the src_facility_id
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getSrc_facility_id() {
		return src_facility_id;
	}
	
	/**
	 * @param java.lang.String the new src_facility_id value
	 * @ejb.interface-method
	 */
	public void setSrc_facility_id(java.lang.String src_facility_id) {
		this.src_facility_id = src_facility_id;
	}
	
	/**
	 * @return the dest_facility_id
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getDest_facility_id() {
		return dest_facility_id;
	}
	
	/**
	 * @param java.lang.String the new dest_facility_id value
	 * @ejb.interface-method
	 */
	public void setDest_facility_id(java.lang.String dest_facility_id) {
		this.dest_facility_id = dest_facility_id;
	}
	
	/**
	 * @return the process_mode
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getProcess_mode() {
		return process_mode;
	}
	
	/**
	 * @param java.lang.Integer the new process_mode value
	 * @ejb.interface-method
	 */
	public void setProcess_mode(java.lang.Integer process_mode) {
		this.process_mode = process_mode;
	}
	
	/**
	 * @return the src_file
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getSrc_file() {
		return src_file;
	}
	
	/**
	 * @param java.lang.String the new src_file value
	 * @ejb.interface-method
	 */
	public void setSrc_file(java.lang.String src_file) {
		this.src_file = src_file;
	}
	
	/**
	 * @return the src_work_dir
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getSrc_work_dir() {
		return src_work_dir;
	}
	
	/**
	 * @param java.lang.String the new src_work_dir value
	 * @ejb.interface-method
	 */
	public void setSrc_work_dir(java.lang.String src_work_dir) {
		this.src_work_dir = src_work_dir;
	}
	
	/**
	 * @return the dest_directory
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public  java.lang.String getDest_directory() {
		return dest_directory;
	}
	
	/**
	 * @param java.lang.String the new dest_directory value
	 * @ejb.interface-method
	 */
	public void setDest_directory(java.lang.String dest_directory) {
		this.dest_directory = dest_directory;
	}
	
	/**
	 * @return the dest_work_dir
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getDest_work_dir() {
		return dest_work_dir;
	}
	
	/**
	 * @param java.lang.String the new dest_work_dir value
	 * @ejb.interface-method
	 */
	public void setDest_work_dir(java.lang.String dest_work_dir) {
		this.dest_work_dir = dest_work_dir;
	}
	
	/**
	 * @return the compression_flg
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.Integer getCompression_flg() {
		return compression_flg;
	}
	
	/**
	 * @param java.lang.Integer the new compression_flg value
	 * @ejb.interface-method
	 */
	public void setCompression_flg(java.lang.Integer compression_flg) {
		this.compression_flg = compression_flg;
	}
	
	/**
	 * @return the check_flg
	 * @ejb.persistent-field
	 * @ejb.interface-method
	 */
	public java.lang.Integer getCheck_flg() {
		return check_flg;
	}
	
	/**
	 * @param java.lang.Integer the new check_flg value
	 * @ejb.interface-method
	 */
	public void setCheck_flg(java.lang.Integer check_flg) {
		this.check_flg = check_flg;
	}
	
	/**
	 * @return the effective_user
	 * @ejb.persistent-field 
	 * @ejb.interface-method
	 */
	public java.lang.String getEffective_user() {
		return effective_user;
	}
	
	/**
	 * @param java.lang.String the new effective_user value
	 * @ejb.interface-method
	 */
	public void setEffective_user(java.lang.String effective_user) {
		this.effective_user = effective_user;
	}
	
	//	==========================================
	//	 CMR fields
	//	==========================================
	/**
	 * @ejb.interface-method view-type="local"
	 */
    public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
}
