/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.ejb.entity;

import java.util.Collection;

import javax.ejb.FinderException;
import javax.naming.NamingException;

/**
 * 
 * @ejb.bean name="JobEndMaster"
 *           jndi-name="JobEndMaster"
 *           type="BMP"
 *           
 * @jboss.depends name="jboss.jca:service=DataSourceBinding,name=HinemosDS"
 * 
 * @ejb.dao class="com.clustercontrol.jobmanagement.dao.JobEndMasterDAO"
 * impl-class="com.clustercontrol.jobmanagement.dao.JobEndMasterDAOImpl"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     
 **/
public abstract class JobEndMasterBean implements javax.ejb.EntityBean {
	protected String job_id;
	protected Integer end_status;
    protected Integer end_value;
    protected Integer end_value_from;
    protected Integer end_value_to;
    
    /**
     *
     * <!-- begin-user-doc -->
     * The  ejbCreate method.
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition --> 
     * @ejb.create-method 
     * <!-- end-xdoclet-definition --> 
     * @generated
     */
    public JobEndMasterPK ejbCreate(
            String job_id, 
            Integer end_status, 
            Integer end_value, 
            Integer end_value_from, 
            Integer end_value_to
            ) throws javax.ejb.CreateException {
        this.job_id = job_id;
        this.end_status = end_status;
        this.end_value = end_value;
        this.end_value_from = end_value_from;
        this.end_value_to = end_value_to;
        return null;
    }

    /**
     * <!-- begin-user-doc -->
     * The container invokes this method immediately after it calls ejbCreate.
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    public void ejbPostCreate() throws javax.ejb.CreateException {
        // begin-user-code
        // end-user-code
    }
    
	public Collection ejbFindAll() throws FinderException {
		return null;
	}
	
	public JobEndMasterPK ejbFindByPrimaryKey(JobEndMasterPK pk) throws FinderException {
		return null;
	}
	
	public Collection ejbFindByJobId(String job_id) throws FinderException {
		return null;
	}

    /**
     * @return the job_id
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.String getJob_id() {
    	return job_id;
    }

    /**
     * @param java.lang.String the new job_id value
     * @ejb.interface-method
     */
    public void setJob_id(java.lang.String job_id) {
    	this.job_id = job_id;
    }

    /**
     * @return the end_status
     * @ejb.persistent-field 
     * @ejb.pk-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_status() {
    	return end_status;
    }

    /**
     * @param java.lang.Integer the new end_status value
     * @ejb.interface-method
     */
    public void setEnd_status(java.lang.Integer end_status) {
    	this.end_status = end_status;
    }

    /**
     * @return the end_value
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_value() {
    	return end_value;
    }

    /**
     * @param java.lang.Integer the new end_value value
     * @ejb.interface-method
     */
    public void setEnd_value(java.lang.Integer end_value) {
    	this.end_value = end_value;
    }

    /**
     * @return the end_value_from
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_value_from() {
    	return end_value_from;
    }

    /**
     * @param java.lang.Integer the new end_value_from value
     * @ejb.interface-method
     */
    public void setEnd_value_from(java.lang.Integer end_value_from) {
    	this.end_value_from = end_value_from;
    }

    /**
     * @return the end_value_to
     * @ejb.persistent-field 
     * @ejb.interface-method
     */
    public java.lang.Integer getEnd_value_to() {
    	return end_value_to;
    }

    /**
     * @param java.lang.Integer the new end_value_to value
     * @ejb.interface-method
     */
    public void setEnd_value_to(java.lang.Integer end_value_to) {
    	this.end_value_to = end_value_to;
    }

	//	==========================================
	//	 CMR fields
	//	==========================================
    /**
     * @ejb.interface-method view-type="local"
     */
    public JobMasterLocal getJobMaster() {
		JobMasterLocal jobMaster = null;
		try {
			jobMaster = JobMasterUtil.getLocalHome().findByPrimaryKey(new JobMasterPK(getJob_id()));
		} catch (FinderException e) {
		} catch (NamingException e) {
		}
		return jobMaster;
	}
}
