/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.ejb.entity.JobSessionBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;

/**
 * Entity Bean JobSession DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobSessionDAOImpl implements JobSessionDAO {
	protected static Log m_log = LogFactory.getLog(JobSessionDAOImpl.class);
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#init()
	 */
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public void load(JobSessionPK pk, JobSessionBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_session WHERE session_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setJob_id(res.getString("job_id"));
				ejb.setOperation_flg(res.getInt("operation_flg"));
				if(res.getTimestamp("schedule_date") != null)
					ejb.setSchedule_date(new Date(res.getTimestamp("schedule_date").getTime()));
				else
					ejb.setSchedule_date(null);
				ejb.setSession_id(res.getString("session_id"));
			} else {
				String msg = "JobSession data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobSessionBean)
	 */
	public void store(JobSessionBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSession_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_job_session SET ");
			sql.append("job_id = ?, ");
			sql.append("schedule_date = ?, ");
			sql.append("operation_flg = ? ");
			sql.append("WHERE session_id = ?");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getJob_id());
			if(ejb.getSchedule_date() instanceof java.util.Date)
				stmt.setTimestamp(2, new Timestamp(ejb.getSchedule_date().getTime()));
			else
				stmt.setTimestamp(2, null);
			stmt.setInt(3, ejb.getOperation_flg());
			stmt.setString(4, ejb.getSession_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getSession_id() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getSession_id() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getSession_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getSession_id());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK)
	 */
	public void remove(JobSessionPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_job_session WHERE session_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobSessionBean)
	 */
	public JobSessionPK create(JobSessionBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getSession_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		JobSessionPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_session (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("schedule_date, ");
			sql.append("operation_flg) ");
			sql.append("VALUES (?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getSession_id());
			stmt.setString(2, ejb.getJob_id());
			if(ejb.getSchedule_date() instanceof java.util.Date)
				stmt.setTimestamp(3, new Timestamp(ejb.getSchedule_date().getTime()));
			else
				stmt.setTimestamp(3, null);
			stmt.setInt(4, ejb.getOperation_flg());
			
			int row =	stmt.executeUpdate();
			pk = new JobSessionPK(
					ejb.getSession_id());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getSession_id() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getSession_id() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getSession_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getSession_id());
		return pk;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<JobSessionPK> ret = new ArrayList<JobSessionPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_session";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobSessionPK pk= new JobSessionPK(
						res.getString("session_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK)
	 */
	public JobSessionPK findByPrimaryKey(JobSessionPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_session WHERE session_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobSessionDAO#findHistoryFilter(java.util.Date, java.util.Date, java.util.Date, java.util.Date, java.lang.String, java.lang.Integer)
	 */
	public Collection findHistoryFilter(Date startFromDate, Date startToDate, Date endFromDate, Date endToDate, String jobId, Integer status) throws FinderException {
		m_log.debug("findHistoryFilter() start : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status);
		
		ArrayList<JobSessionPK> ret = new ArrayList<JobSessionPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("SELECT a.session_id FROM cc_job_session as a, cc_job_session_job as b ");
			sql.append("WHERE a.session_id = b.session_id AND a.job_id = b.job_id");
			if(startFromDate instanceof Date) {
				sql.append(" AND b.start_date >= ?");
			}
			if(startToDate instanceof Date) {
				sql.append(" AND b.start_date <= ?");
			}
			if(endFromDate instanceof Date) {
				sql.append(" AND b.end_date >= ?");
			}
			if(endToDate instanceof Date) {
				sql.append(" AND b.end_date <= ?");
			}
			if(jobId != null && jobId.length() > 0) {
				sql.append(" AND b.job_id = ?");
			}
			if(status instanceof Integer && status.intValue() != -1) {
				sql.append(" AND b.status = ?");
			}
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			int count = 1;
			if(startFromDate instanceof Date) {
				stmt.setTimestamp(count, new Timestamp(startFromDate.getTime()));
				count++;
			}
			if(startToDate instanceof Date) {
				stmt.setTimestamp(count, new Timestamp(startToDate.getTime()));
				count++;
			}
			if(endFromDate instanceof Date) {
				stmt.setTimestamp(count, new Timestamp(endFromDate.getTime()));
				count++;
			}
			if(endToDate instanceof Date) {
				stmt.setTimestamp(count, new Timestamp(endToDate.getTime()));
				count++;
			}
			if(jobId != null && jobId.length() > 0) {
				stmt.setString(count, jobId);
				count++;
			}
			if(status instanceof Integer && status.intValue() != -1) {
				stmt.setInt(count, status);
				count++;
			}
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobSessionPK pk= new JobSessionPK(
						res.getString("session_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findHistoryFilter() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findHistoryFilter() error : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findHistoryFilter() end : " + startFromDate + ", " + startToDate + ", " + endFromDate + ", " + endToDate + ", " + jobId + ", " + status);
		return ret;
	}
}
