/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;

/**
 * Entity Bean JobRelationInfo DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobRelationInfoDAOImpl implements JobRelationInfoDAO {
	protected static Log m_log = LogFactory.getLog(JobRelationInfoDAOImpl.class);
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#init()
	 */
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public void load(JobRelationInfoPK pk, JobRelationInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND job_id = ? AND parent_job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getParent_job_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setJob_id(res.getString("job_id"));
				ejb.setParent_job_id(res.getString("parent_job_id"));
				ejb.setSession_id(res.getString("session_id"));
			} else {
				String msg = "JobRelationInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoBean)
	 */
	public void store(JobRelationInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id());
		
		
		m_log.debug("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoPK)
	 */
	public void remove(JobRelationInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_job_relation_info WHERE session_id = ? AND job_id = ? AND parent_job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getParent_job_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoBean)
	 */
	public JobRelationInfoPK create(JobRelationInfoBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		JobRelationInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_relation_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("parent_job_id) ");
			sql.append("VALUES (?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getSession_id());
			stmt.setString(2, ejb.getJob_id());
			stmt.setString(3, ejb.getParent_job_id());
			
			int row =	stmt.executeUpdate();
			pk = new JobRelationInfoPK(
					ejb.getSession_id(),
					ejb.getJob_id(),
					ejb.getParent_job_id());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getParent_job_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParent_job_id());
		return pk;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_relation_info";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobRelationInfoPK pk= new JobRelationInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getString("parent_job_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobRelationInfoPK)
	 */
	public JobRelationInfoPK findByPrimaryKey(JobRelationInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND job_id = ? AND parent_job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getParent_job_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findByParentJobId(java.lang.String, java.lang.String)
	 */
	public Collection findByParentJobId(String session_id, String parent_job_id) throws FinderException {
		m_log.debug("findByParentJobId() start : " + session_id + ", " + parent_job_id);
		
		ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND parent_job_id = ? ORDER BY job_id ASC";
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, session_id);
			stmt.setString(2, parent_job_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobRelationInfoPK pk= new JobRelationInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getString("parent_job_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByParentJobId() error : " + session_id + ", " + parent_job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByParentJobId() error : " + session_id + ", " + parent_job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByParentJobId() end : " + session_id + ", " + parent_job_id);
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findByStartStatus(java.lang.String, java.lang.String)
	 */
	public Collection findByStartStatus(String session_id, String parent_job_id) throws FinderException {
		m_log.debug("findByStartStatus() start : " + session_id + ", " + parent_job_id);
		
		ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("SELECT * FROM cc_job_relation_info as a, cc_job_session_job as b ");
			sql.append("WHERE a.session_id = b.session_id AND ");
			sql.append("a.job_id = b.job_id AND ");
			sql.append("a.session_id = ? AND ");
			sql.append("a.parent_job_id = ? AND ");
			sql.append("(b.status = 0 OR b.status = 2 OR b.status = 100)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, session_id);
			stmt.setString(2, parent_job_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobRelationInfoPK pk= new JobRelationInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getString("parent_job_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByStartStatus() error : " + session_id + ", " + parent_job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByStartStatus() error : " + session_id + ", " + parent_job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByStartStatus() end : " + session_id + ", " + parent_job_id);
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findByStatus(java.lang.String, java.lang.String, java.lang.Integer)
	 */
	public Collection findByStatus(String session_id, String parent_job_id, Integer status) throws FinderException {
		m_log.debug("findByStatus() start : " + session_id + ", " + parent_job_id + ", " + status);
		
		ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("SELECT * FROM cc_job_relation_info as a, cc_job_session_job as b ");
			sql.append("WHERE a.session_id = b.session_id AND ");
			sql.append("a.job_id = b.job_id AND ");
			sql.append("a.session_id = ? AND ");
			sql.append("a.parent_job_id = ? AND ");
			sql.append("b.status = ?");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, session_id);
			stmt.setString(2, parent_job_id);
			stmt.setInt(3, status);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobRelationInfoPK pk= new JobRelationInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getString("parent_job_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByStatus() error : " + session_id + ", " + parent_job_id + ", " + status + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByStatus() error : " + session_id + ", " + parent_job_id + ", " + status + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByStatus() end : " + session_id + ", " + parent_job_id + ", " + status);
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findByStartDate(java.lang.String, java.lang.String)
	 */
	public Collection findByStartDate(String session_id, String parent_job_id) throws FinderException {
		m_log.debug("findByStartDate() start : " + session_id + ", " + parent_job_id);
		
		ArrayList<JobRelationInfoPK> ret = new ArrayList<JobRelationInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("SELECT * FROM cc_job_relation_info as a, cc_job_session_job as b ");
			sql.append("WHERE a.session_id = b.session_id AND ");
			sql.append("a.job_id = b.job_id AND ");
			sql.append("a.session_id = ? AND ");
			sql.append("a.parent_job_id = ? ");
			sql.append("ORDER BY b.start_date");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, session_id);
			stmt.setString(2, parent_job_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobRelationInfoPK pk= new JobRelationInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getString("parent_job_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findByStartDate() error : " + session_id + ", " + parent_job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findByStartDate() error : " + session_id + ", " + parent_job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findByStartDate() end : " + session_id + ", " + parent_job_id);
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobRelationInfoDAO#findBySessionIdAndJobId(java.lang.String, java.lang.String)
	 */
	public JobRelationInfoPK findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		m_log.debug("findBySessionIdAndJobId() start : " + session_id + ", " + job_id);
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_relation_info WHERE session_id = ? AND job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, session_id);
			stmt.setString(2, job_id);
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				JobRelationInfoPK pk= new JobRelationInfoPK(
						res.getString("session_id"),
						res.getString("job_id"),
						res.getString("parent_job_id")
				);
				return pk;
			} else {
				String msg = "id " + session_id + ", " + job_id + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findBySessionIdAndJobId() end : " + session_id + ", " + job_id);
		}
	}
	
	/**
	 * 
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sessionId
	 * @param jobs
	 * @throws CreateException
	 */
	public void makeSession(String sessionId, Collection jobs) throws CreateException{
		m_log.debug("makeSession() start : " + sessionId );
		
		Connection conn = null;
		PreparedStatement stmt = null;
		Hashtable ht = null;
		
		try{
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ(INSERT)
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_relation_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("parent_job_id) ");
			sql.append("VALUES (?,?,?)");
			
			//SQLʸΥå(INSERT)
			stmt = conn.prepareStatement(sql.toString());
			stmt.setString(1, sessionId);
			
			Iterator it = jobs.iterator();
			while(it.hasNext()){
				//ID
				ht = (Hashtable)it.next();
				String jobId = (String)ht.get("jobId");
				
				//SQLʸΥå(INSERT)
				stmt.setString(2, jobId);
				stmt.setString(3, (String)ht.get("parentJobId"));
				
				//INSERT¹
				int row =	stmt.executeUpdate();
				if (row != 1) {
					String msg = "result row is not 1";
					m_log.error("makeSession() error : " + sessionId + ", "
							+ (String)ht.get("jobId") + ", " + (String)ht.get("parentJobId") + " SQLException");
					throw new EJBException(msg);
				}
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("makeSession() error : " +sessionId + ", "
						+ (String)ht.get("jobId") + ", " + (String)ht.get("parentJobId") + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("makeSession() error : " + sessionId + ", "
						+ (String)ht.get("jobId")  + ", " + (String)ht.get("parentJobId") + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("makeSession() end : ");
	}
}
