/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobParamTypeConstant;
import com.clustercontrol.jobmanagement.bean.SystemParameterConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobRelationMasterUtil;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionLocal;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionPK;
import com.clustercontrol.jobmanagement.ejb.entity.JobSessionUtil;
import com.clustercontrol.jobmanagement.util.ConnectionManager;
import com.clustercontrol.jobmanagement.util.ParameterUtil;
import com.clustercontrol.monitor.message.LogOutputInfo;

/**
 * Entity Bean JobParamInfo DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobParamInfoDAOImpl implements JobParamInfoDAO {
	protected static Log m_log = LogFactory.getLog(JobParamInfoDAOImpl.class);
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#init()
	 */
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoBean)
	 */
	public void load(JobParamInfoPK pk, JobParamInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND job_id = ? AND param_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getParam_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setDescription(res.getString("description"));
				ejb.setJob_id(res.getString("job_id"));
				ejb.setParam_id(res.getString("param_id"));
				ejb.setParam_type(res.getInt("param_type"));
				ejb.setSession_id(res.getString("session_id"));
				ejb.setValue(res.getString("value"));
			} else {
				String msg = "JobParamInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoBean)
	 */
	public void store(JobParamInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_job_param_info SET ");
			sql.append("param_type = ?, ");
			sql.append("description = ?, ");
			sql.append("value = ? ");
			sql.append("WHERE session_id = ? ");
			sql.append("AND job_id = ? ");
			sql.append("AND param_id = ?");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setInt(1, ejb.getParam_type());
			stmt.setString(2, ejb.getDescription());
			stmt.setString(3, ejb.getValue());
			stmt.setString(4, ejb.getSession_id());
			stmt.setString(5, ejb.getJob_id());
			stmt.setString(6, ejb.getParam_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getSession_id() + ", "
					+ ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoPK)
	 */
	public void remove(JobParamInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_job_param_info WHERE session_id = ? AND job_id = ? AND param_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getParam_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoBean)
	 */
	public JobParamInfoPK create(JobParamInfoBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		JobParamInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_param_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("param_id, ");
			sql.append("param_type, ");
			sql.append("description, ");
			sql.append("value) ");
			sql.append("VALUES (?,?,?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getSession_id());
			stmt.setString(2, ejb.getJob_id());
			stmt.setString(3, ejb.getParam_id());
			stmt.setInt(4, ejb.getParam_type());
			stmt.setString(5, ejb.getDescription());
			stmt.setString(6, ejb.getValue());
			int row =	stmt.executeUpdate();
			pk = new JobParamInfoPK(
					ejb.getSession_id(),
					ejb.getJob_id(), 
					ejb.getParam_id());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id() + ", " + ejb.getParam_id());
		return pk;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<JobParamInfoPK> ret = new ArrayList<JobParamInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_param_info";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobParamInfoPK pk= new JobParamInfoPK(
						res.getString("session_id"),
						res.getString("job_id"), 
						res.getString("param_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobParamInfoPK)
	 */
	public JobParamInfoPK findByPrimaryKey(JobParamInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND job_id = ? AND param_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			stmt.setString(3, pk.getParam_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#findBySessionIdAndJobId(java.lang.String, java.lang.String)
	 */
	public Collection findBySessionIdAndJobId(String session_id, String job_id) throws FinderException {
		m_log.debug("findBySessionIdAndJobId() start : " + session_id + ", " + job_id);
		
		ArrayList<JobParamInfoPK> ret = new ArrayList<JobParamInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			stmt.setString(1, session_id);
			stmt.setString(2, job_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobParamInfoPK pk= new JobParamInfoPK(
						res.getString("session_id"),
						res.getString("job_id"), 
						res.getString("param_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findBySessionIdAndJobId() error : " + session_id + ", " + job_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findBySessionIdAndJobId() end : " + session_id + ", " + job_id);
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobParamInfoDAO#findByParamId(java.lang.String, java.lang.String)
	 */
	public Collection findBySessionIdAndParamId(String session_id, String param_id) throws FinderException {
		m_log.debug("findBySessionIdAndParamId() start : " + session_id + ", " + param_id);
		
		ArrayList<JobParamInfoPK> ret = new ArrayList<JobParamInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_param_info WHERE session_id = ? AND param_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			stmt.setString(1, session_id);
			stmt.setString(2, param_id);
			
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobParamInfoPK pk= new JobParamInfoPK(
						res.getString("session_id"),
						res.getString("job_id"), 
						res.getString("param_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findBySessionIdAndParamId() error : " + session_id + ", " + param_id + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findBySessionIdAndParamId() error : " + session_id + ", " + param_id + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findBySessionIdAndParamId() end : " + session_id + ", " + param_id);
		return ret;
	}
	
	/**
	 * 
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sessionId
	 * @param jobs
	 * @param info
	 * @throws CreateException
	 * @throws NamingException 
	 * @throws FinderException 
	 */
	public void makeSession(String sessionId, String jobId, LogOutputInfo info) throws CreateException, FinderException, NamingException{
		m_log.debug("makeSession() start : " + sessionId );
		
		Connection conn = null;
		Connection connMaster = null;
		PreparedStatement stmt = null;
		PreparedStatement stmtMaster = null;
		String parentJobId = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			connMaster = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ(INSERT)
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_param_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("param_id, ");
			sql.append("param_type, ");
			sql.append("description, ");
			sql.append("value) ");
			sql.append("VALUES (?,?,?,?,?,?)");
			
			//SQLʸΥå(INSERT)
			stmt = conn.prepareStatement(sql.toString());
			stmt.setString(1, sessionId);
			
			//Ǿ̤ΥID
			String topJobId = JobRelationMasterUtil.getLocalHome().getTopJobId(jobId);	
			
			//SQLʸ(ޥ)
			String sqlMaster = "SELECT * FROM cc_job_param_mst WHERE job_id = ?";
			//SQLSQLʸΥå(ޥ)
			stmtMaster = connMaster.prepareStatement(sqlMaster);
			//SQLʸ(ޥ)
			stmtMaster.setString(1, topJobId);
			
			//SQL¹(ޥ)
			ResultSet resMaster = stmtMaster.executeQuery();
			
			while(resMaster.next()) {
				//ѥ᡼̼
				int paramType = resMaster.getInt("param_type");
				//ѥ᡼ID
				String paramId = resMaster.getString("param_id");
				
				//ѥ᡼ͤ
				String value = null;
				if(paramType == JobParamTypeConstant.TYPE_SYSTEM){
					//ƥѿ
					if(paramId.equals(SystemParameterConstant.START_DATE)){
						//å󳫻
						try {
							JobSessionLocal session = JobSessionUtil.getLocalHome().findByPrimaryKey(new JobSessionPK(sessionId));
							value = DateFormat.getDateTimeInstance().format(session.getSchedule_date());
						} catch (FinderException e) {
						} catch (NamingException e) {
						}
					}
					else{
						//¾
						value = ParameterUtil.getParameterValue(paramId, info);
					}
				}
				else{
					//桼ѿ
					value = resMaster.getString("value");;
				}
				
				//SQLʸΥå(INSERT)
				stmt.setString(2, jobId);
				stmt.setString(3, resMaster.getString("param_id"));
				stmt.setInt(4, resMaster.getInt("param_type"));
				stmt.setString(5, resMaster.getString("description"));
				stmt.setString(6, value);
				
				//INSERT¹
				int row =	stmt.executeUpdate();
				if (row != 1) {
					String msg = "result row is not 1";
					m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException");
					throw new EJBException(msg);
				}
			}
			resMaster.close();
			
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(stmtMaster != null){
					stmtMaster.close();
				}
				if(conn != null){
					conn.close();
				}
				if(connMaster != null){
					connMaster.close();
				}
			} catch (SQLException e1) {
				m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("makeSession() end : " + sessionId );
	}
}
