/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;

import javax.ejb.CreateException;
import javax.ejb.DuplicateKeyException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.bean.JobConstant;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean;
import com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK;
import com.clustercontrol.jobmanagement.util.ConnectionManager;

/**
 * Entity Bean JobCommandInfo DAO饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobCommandInfoDAOImpl implements JobCommandInfoDAO {
	protected static Log m_log = LogFactory.getLog(JobCommandInfoDAOImpl.class);
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#init()
	 */
	public void init() {
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#load(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK, com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public void load(JobCommandInfoPK pk, JobCommandInfoBean ejb) throws EJBException {
		m_log.debug("load() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_command_info WHERE session_id = ? AND job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				//ͤBean˥å
				ejb.setArgument(res.getString("argument"));
				ejb.setArgument_job_id(res.getString("argument_job_id"));
				ejb.setEffective_user(res.getString("effective_user"));
				ejb.setError_end_flg(res.getInt("error_end_flg"));
				ejb.setError_end_value(res.getInt("error_end_value"));
				ejb.setFacility_id(res.getString("facility_id"));
				ejb.setJob_id(res.getString("job_id"));
				ejb.setProcess_mode(res.getInt("process_mode"));
				ejb.setSession_id(res.getString("session_id"));
				ejb.setStart_command(res.getString("start_command"));
				ejb.setStop_command(res.getString("stop_command"));
			} else {
				String msg = "JobCommandInfo data is not found.";
				m_log.error("load() error : " + pk.toString() + " SQLException " + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("load() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			//ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (res != null) {
					res.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("load() error : " + pk.toString() + " SQLException " + e1.getMessage());
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("load() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#store(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public void store(JobCommandInfoBean ejb) throws EJBException {
		m_log.debug("store() start : " + ejb.getSession_id() + ", " + ejb.getJob_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("UPDATE cc_job_command_info SET ");
			sql.append("facility_id = ?, ");
			sql.append("process_mode = ?, ");
			sql.append("start_command = ?, ");
			sql.append("stop_command = ?, ");
			sql.append("effective_user = ?, ");
			sql.append("error_end_flg = ?, ");
			sql.append("error_end_value = ?, ");
			sql.append("argument_job_id = ?, ");
			sql.append("argument = ? ");
			sql.append("WHERE session_id = ? AND ");
			sql.append("job_id = ?");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getFacility_id());
			stmt.setInt(2, ejb.getProcess_mode());
			stmt.setString(3, ejb.getStart_command());
			stmt.setString(4, ejb.getStop_command());
			stmt.setString(5, ejb.getEffective_user());
			stmt.setInt(6, ejb.getError_end_flg());
			stmt.setInt(7, ejb.getError_end_value());
			stmt.setString(8, ejb.getArgument_job_id());
			stmt.setString(9, ejb.getArgument());
			stmt.setString(10, ejb.getSession_id());
			stmt.setString(11, ejb.getJob_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("store() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + " SQLException" + msg);
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			m_log.error("store() error : " + ejb.getSession_id() + ", "
					+ ejb.getJob_id() + " SQLException");
			throw new EJBException(e.getMessage());
		} finally {
			// ͥ󡢷̥åȡץڥɥơȥȤΥ
			try {
				if (stmt != null) {
					stmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("store() error : " + ejb.getSession_id() + ", "
						+ ejb.getJob_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("store() end : " + ejb.getSession_id() + ", " + ejb.getJob_id());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#remove(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK)
	 */
	public void remove(JobCommandInfoPK pk) throws RemoveException, EJBException {
		m_log.debug("remove() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "DELETE FROM cc_job_command_info WHERE session_id = ? AND job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			
			int row = stmt.executeUpdate();
			
			if (row != 1 ) {
				String msg = "result row is not 1";
				m_log.error("remove() error : " + pk.toString() + " SQLException" + msg);
				throw new EJBException(msg);	
			}
		} catch (SQLException e) {
			m_log.error("remove() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
			
		} finally {
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("remove() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("remove() end : " + pk.toString());
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#create(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoBean)
	 */
	public JobCommandInfoPK create(JobCommandInfoBean ejb) throws CreateException, EJBException {
		m_log.debug("create() start : " + ejb.getSession_id() + ", " + ejb.getJob_id());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		JobCommandInfoPK pk;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			//SQLʸ
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_command_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("facility_id, ");
			sql.append("process_mode, ");
			sql.append("start_command, ");
			sql.append("stop_command, ");
			sql.append("effective_user, ");
			sql.append("error_end_flg, ");
			sql.append("error_end_value, ");
			sql.append("argument_job_id, ");
			sql.append("argument) ");
			sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");
			
			//SQLʸΥå
			stmt = conn.prepareStatement(sql.toString());
			
			stmt.setString(1, ejb.getSession_id());
			stmt.setString(2, ejb.getJob_id());
			stmt.setString(3, ejb.getFacility_id());
			stmt.setInt(4, ejb.getProcess_mode());
			stmt.setString(5, ejb.getStart_command());
			stmt.setString(6, ejb.getStop_command());
			stmt.setString(7, ejb.getEffective_user());
			stmt.setInt(8, ejb.getError_end_flg());
			stmt.setInt(9, ejb.getError_end_value());
			stmt.setString(10, ejb.getArgument_job_id());
			stmt.setString(11, ejb.getArgument());
			
			int row =	stmt.executeUpdate();
			pk = new JobCommandInfoPK(
					ejb.getSession_id(),
					ejb.getJob_id());
			
			if (row != 1) {
				String msg = "result row is not 1";
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException");
				throw new EJBException(msg);
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("create() error : " + ejb.getSession_id() + ", " + ejb.getJob_id() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("create() end : " + ejb.getSession_id() + ", " + ejb.getJob_id());
		return pk;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#findAll()
	 */
	public Collection findAll() throws FinderException {
		m_log.debug("findAll() start : ");
		
		ArrayList<JobCommandInfoPK> ret = new ArrayList<JobCommandInfoPK>();
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();	
			//SQLʸ
			String sql = "SELECT * FROM cc_job_command_info";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			res = stmt.executeQuery();
			
			while(res.next()) {
				JobCommandInfoPK pk= new JobCommandInfoPK(
						res.getString("session_id"),
						res.getString("job_id")
				);
				ret.add(pk);
			}
			
		} catch (SQLException e) {
			m_log.error("findAll() error :  SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("findAll() error :  SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("findAll() end : ");
		return ret;
	}
	
	/* (non Javadoc)
	 * @see com.clustercontrol.jobmanagement.dao.JobCommandInfoDAO#findByPrimaryKey(com.clustercontrol.jobmanagement.ejb.entity.JobCommandInfoPK)
	 */
	public JobCommandInfoPK findByPrimaryKey(JobCommandInfoPK pk) throws FinderException {
		m_log.debug("findByPrimaryKey() start : " + pk.toString());
		
		Connection conn = null;
		PreparedStatement stmt = null;
		ResultSet res = null;
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ
			String sql = "SELECT * FROM cc_job_command_info WHERE session_id = ? AND job_id = ?";
			//SQLʸΥå
			stmt = conn.prepareStatement(sql);
			
			stmt.setString(1, pk.getSession_id());
			stmt.setString(2, pk.getJob_id());
			
			res = stmt.executeQuery();
			
			if (res.next()) {
				return pk;
			} else {
				String msg = "id " + pk.toString() + " not found.";
				throw new FinderException(msg);
			}
		} catch (SQLException e) {
			m_log.error("find() error : " + pk.toString() + " SQLException");
			throw new EJBException(e.getMessage());
		}  finally{
			try {
				if(stmt != null){
					stmt.close();}
				if(res != null){
					res.close();}
				if(conn != null){
					conn.close();
				}
			} catch (SQLException e1) {
				m_log.error("find() error : " + pk.toString() + " SQLException");
				throw new EJBException(e1.getMessage());
			}
			m_log.debug("findByPrimaryKey() end : " + pk.toString());
		}
	}
	
	/**
	 * 
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param sessionId
	 * @param jobs
	 * @throws CreateException
	 */
	public void makeSession(String sessionId, Collection jobs) throws CreateException{
		m_log.debug("makeSession() start : " + sessionId );
		
		Connection conn = null; 
		Connection connMaster = null;
		PreparedStatement stmt = null;
		PreparedStatement stmtMaster = null;
		String jobId = null;
		
		try {
			conn = ConnectionManager.getConnectionManager().getConnection();
			connMaster = ConnectionManager.getConnectionManager().getConnection();
			
			//SQLʸ(INSERT)
			StringBuilder sql = new StringBuilder();
			sql.append("INSERT INTO cc_job_command_info (");
			sql.append("session_id, ");
			sql.append("job_id, ");
			sql.append("facility_id, ");
			sql.append("process_mode, ");
			sql.append("start_command, ");
			sql.append("stop_command, ");
			sql.append("effective_user, ");
			sql.append("error_end_flg, ");
			sql.append("error_end_value, ");
			sql.append("argument_job_id, ");
			sql.append("argument) ");
			sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?)");

			//SQLʸΥå(INSERT)
			stmt = conn.prepareStatement(sql.toString());
			stmt.setString(1,sessionId);
			
			//SQLʸ(ޥ)
			StringBuilder sqlMaster = new StringBuilder();
			sqlMaster.append("SELECT ");
			sqlMaster.append("cc_job_mst.job_type, ");
			sqlMaster.append("cc_job_command_mst.job_id, ");
			sqlMaster.append("cc_job_command_mst.facility_id, ");
			sqlMaster.append("cc_job_command_mst.process_mode, ");
			sqlMaster.append("cc_job_command_mst.start_command, ");
			sqlMaster.append("cc_job_command_mst.stop_command, ");
			sqlMaster.append("cc_job_command_mst.effective_user, ");
			sqlMaster.append("cc_job_command_mst.error_end_flg, ");
			sqlMaster.append("cc_job_command_mst.error_end_value, ");
			sqlMaster.append("cc_job_command_mst.argument_job_id, ");
			sqlMaster.append("cc_job_command_mst.argument ");
			sqlMaster.append("FROM cc_job_mst, cc_job_command_mst ");
			sqlMaster.append("WHERE ");
			sqlMaster.append("(cc_job_mst.job_id=cc_job_command_mst.job_id ");
			sqlMaster.append("AND cc_job_mst.job_id=");
			sqlMaster.append(" ? )");
			
			//SQLʸΥå(ޥ)
			stmtMaster = connMaster.prepareStatement(sqlMaster.toString());
			
			Iterator it = jobs.iterator();
			while(it.hasNext()){
				//ID
				Hashtable ht = (Hashtable)it.next();
				jobId = (String)ht.get("jobId");
				
				//SQL¹(ޥ)
				stmtMaster.setString(1, jobId);
				ResultSet resMaster = stmtMaster.executeQuery();
				
				if (resMaster.next()) {
					if(resMaster.getInt("job_type") == JobConstant.TYPE_JOB){
						//֤ξ硢INSERT¹
						stmt.setString(2, resMaster.getString("job_id"));
						stmt.setString(3, resMaster.getString("facility_id"));
						stmt.setInt(4, resMaster.getInt("process_mode"));
						stmt.setString(5, resMaster.getString("start_command"));
						stmt.setString(6, resMaster.getString("stop_command"));
						stmt.setString(7, resMaster.getString("effective_user"));
						stmt.setInt(8, resMaster.getInt("error_end_flg"));
						stmt.setInt(9, resMaster.getInt("error_end_value"));
						stmt.setString(10, resMaster.getString("argument_job_id"));
						stmt.setString(11, resMaster.getString("argument"));
						
						int row =	stmt.executeUpdate();
						if (row != 1) {
							String msg = "result row is not 1";
							m_log.error("makeSession() error : " + sessionId + ", " + resMaster.getString("job_id") + " SQLException");
							throw new EJBException(msg);
						}
					}
				}
				resMaster.close();
			}
		} catch (SQLException e) {
			if(e.getSQLState().equals("23505")){
				m_log.error("makeSession() error : " + sessionId + ", " + jobId+ " SQLException" + "DuplicateKeyException ");
				throw new DuplicateKeyException(e.getMessage());
			}
			throw new CreateException(e.getMessage());
		}finally{
			try {
				if(stmt != null){
					stmt.close();
				}
				if(conn != null){
					conn.close();
				}
				if(stmtMaster != null){
					stmtMaster.close();
				}
				if(connMaster != null){
					connMaster.close();
				}
			} catch (SQLException e1) {
				m_log.error("makeSession() error : " + sessionId + ", " + jobId + " SQLException");
				throw new EJBException(e1.getMessage());
			}
		}
		m_log.debug("makeSession() end : " + sessionId);
	}
}
