/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import com.clustercontrol.util.Messages;


/**
 * 饹
 *
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobOperationConstant {
    /** [¨] */
    public static final int TYPE_START_AT_ONCE = 1;
    /** [ǲ] */
    public static final int TYPE_START_SUSPEND = 3;
    /** [åײ] */
    public static final int TYPE_START_SKIP = 5;
    /** [α] */
    public static final int TYPE_START_WAIT = 7;
    
    /** [¨] */
    public static final int TYPE_STOP_AT_ONCE = 0;
    /** [] */
    public static final int TYPE_STOP_SUSPEND = 2;
    /** [å] */
    public static final int TYPE_STOP_SKIP = 4;
    /** [α] */
    public static final int TYPE_STOP_WAIT = 6;
    /** [] */
    public static final int TYPE_STOP_MAINTENANCE = 8;
    
    /** [¨] */
    public static final String STRING_START_AT_ONCE = Messages.getString("job.start.at.once");
    /** [ǲ] */
    public static final String STRING_START_SUSPEND = Messages.getString("job.start.release.suspend");
    /** [åײ] */
    public static final String STRING_START_SKIP = Messages.getString("job.start.release.skip");
    /** [α] */
    public static final String STRING_START_WAIT = Messages.getString("job.start.release.reserve");
    
    /** [¨] */
    public static final String STRING_STOP_AT_ONCE = Messages.getString("job.stop.at.once");
    /** [] */
    public static final String STRING_STOP_SUSPEND = Messages.getString("job.stop.suspend");
    /** [å] */
    public static final String STRING_STOP_SKIP = Messages.getString("job.stop.skip");
    /** [α] */
    public static final String STRING_STOP_WAIT = Messages.getString("job.stop.reserve");
    /** [] */
    public static final String STRING_STOP_MAINTENANCE = Messages.getString("job.stop.maintenance");
    
	/**
	 * ̤ʸѴ
	 * 
	 * @param type
	 * @return
	 * @since 1.0.0
	 */
	public static String typeToString(int type){
		if(type == TYPE_START_AT_ONCE){
			return STRING_START_AT_ONCE;
		}
		else if(type == TYPE_START_SUSPEND){
			return STRING_START_SUSPEND;
		}
		else if(type == TYPE_START_SKIP){
			return STRING_START_SKIP;
		}
		else if(type == TYPE_START_WAIT){
			return STRING_START_WAIT;
		}
		else if(type == TYPE_STOP_AT_ONCE){
			return STRING_STOP_AT_ONCE;
		}
		else if(type == TYPE_STOP_SUSPEND){
			return STRING_STOP_SUSPEND;
		}
		else if(type == TYPE_STOP_SKIP){
			return STRING_STOP_SKIP;
		}
		else if(type == TYPE_STOP_WAIT){
			return STRING_STOP_WAIT;
		}
		else if(type == TYPE_STOP_MAINTENANCE){
			return STRING_STOP_MAINTENANCE;
		}
		return "";
	}
	
	/**
	 * ʸ󤫤̤Ѵ
	 * 
	 * @param type
	 * @return
	 * @since 1.0.0
	 */
	public static int stringToType(String string){
		if(string.equals(STRING_START_AT_ONCE)){
			return TYPE_START_AT_ONCE;
		}
		else if(string.equals(STRING_START_SUSPEND)){
			return TYPE_START_SUSPEND;
		}
		else if(string.equals(STRING_START_SKIP)){
			return TYPE_START_SKIP;
		}
		else if(string.equals(STRING_START_WAIT)){
			return TYPE_START_WAIT;
		}
		else if(string.equals(STRING_STOP_AT_ONCE)){
			return TYPE_STOP_AT_ONCE;
		}
		else if(string.equals(STRING_STOP_SUSPEND)){
			return TYPE_STOP_SUSPEND;
		}
		else if(string.equals(STRING_STOP_SKIP)){
			return TYPE_STOP_SKIP;
		}
		else if(string.equals(STRING_STOP_WAIT)){
			return TYPE_STOP_WAIT;
		}
		else if(string.equals(STRING_STOP_MAINTENANCE)){
			return TYPE_STOP_MAINTENANCE;
		}
		return -1;
	}
}
