/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;

import com.clustercontrol.bean.EndStatusConstant;
import com.clustercontrol.bean.YesNoConstant;

/**
 * Ԥ說饹
 * 
 * @version 2.1.0
 * @since 1.0.0
 */
public class JobWaitRuleInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = -6362706494732152461L;

	/** ϻα */
	protected int suspend = YesNoConstant.TYPE_NO;
	
	/** ϻå */
	protected int skip = YesNoConstant.TYPE_NO;
	
	/** å׽λ */
	protected int skipEndStatus;
	
	/** å׽λ */
	protected int skipEndValue = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** (AND or OR) */
	protected int condition = ConditionTypeConstant.TYPE_AND;
	
	/** Ƚо */
	protected ArrayList object;
	
	/** ϾʤȤλ */
	protected int endCondition = YesNoConstant.TYPE_NO;
	
	/** λ */
	protected int endStatus;
	
	/** λ */
	protected int endValue = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/**  */
	protected int calendar = YesNoConstant.TYPE_NO;
	
	/** ID */
	protected String calendarId;
	
	/** ̤¹Իλ */
	protected int calendarEndValue = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** ٱ */
	protected int start_delay = YesNoConstant.TYPE_NO;
	
	/** ٱ䥻å󳫻ϸ */
	protected int start_delay_session = YesNoConstant.TYPE_NO;
	
	/** ٱ䥻å󳫻ϸ֤ */
	protected int start_delay_session_value = 1;
	
	/** ٱ */
	protected int start_delay_time = YesNoConstant.TYPE_NO;
	
	/** ٱ */
	protected Date start_delay_time_value;
	
	/** ٱȽ */
	protected int start_delay_condition_type = ConditionTypeConstant.TYPE_AND;
	
	/** ٱ */
	protected int start_delay_notify = YesNoConstant.TYPE_NO;
	
	/** ٱν */
	protected int start_delay_notify_priority;
	
	/** ٱ */
	protected int start_delay_operation = YesNoConstant.TYPE_NO;
	
	/** ٱ */
	protected int start_delay_operation_type;
	
	/** ٱλ */
	protected int start_delay_operation_end_value = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/** λٱ */
	protected int end_delay = YesNoConstant.TYPE_NO;
	
	/** λٱ䥻åλ */
	protected int end_delay_session = YesNoConstant.TYPE_NO;
	
	/** λٱ䥻åλ֤ */
	protected int end_delay_session_value = 1;
	
	/** λٱ䥸ֽλ */
	protected int end_delay_job = YesNoConstant.TYPE_NO;
	
	/** λٱ䥸ֽλ֤ */
	protected int end_delay_job_value = 1;
	
	/** λٱ */
	protected int end_delay_time = YesNoConstant.TYPE_NO;
	
	/** λٱ */
	protected Date end_delay_time_value;
	
	/** λٱȽ */
	protected int end_delay_condition_type = ConditionTypeConstant.TYPE_AND;
	
	/** λٱ */
	protected int end_delay_notify = YesNoConstant.TYPE_NO;
	
	/** λٱν */
	protected int end_delay_notify_priority;
	
	/** λٱ */
	protected int end_delay_operation = YesNoConstant.TYPE_NO;
	
	/** λٱ */
	protected int end_delay_operation_type;
	
	/** λٱλ */
	protected int end_delay_operation_end_value = EndStatusConstant.INITIAL_VALUE_NORMAL;
	
	/**
	 * @return Returns the skip.
	 * @since 1.0.0
	 */
	public int getSkip() {
		return skip;
	}
	
	/**
	 * @param skip
	 *            The skip to set.
	 * @since 1.0.0
	 */
	public void setSkip(int skip) {
		this.skip = skip;
	}
	
	/**
	 * @return Returns the skipEndStatus.
	 * @since 1.0.0
	 */
	public int getSkipEndStatus() {
		return skipEndStatus;
	}
	
	/**
	 * @param endStatus
	 *            The skipEndStatus to set.
	 * @since 1.0.0
	 */
	public void setSkipEndStatus(int endStatus) {
		this.skipEndStatus = endStatus;
	}
	
	/**
	 * @return Returns the skipEndValue.
	 * @since 1.0.0
	 */
	public int getSkipEndValue() {
		return skipEndValue;
	}
	
	/**
	 * @param endValue
	 *            The skipEndValue to set.
	 * @since 1.0.0
	 */
	public void setSkipEndValue(int endValue) {
		this.skipEndValue = endValue;
	}
	
	/**
	 * @return Returns the condition.
	 * @since 1.0.0
	 */
	public int getCondition() {
		return condition;
	}
	
	/**
	 * @param condition
	 *            The condition to set.
	 * @since 1.0.0
	 */
	public void setCondition(int condition) {
		this.condition = condition;
	}
	
	/**
	 * @return Returns the endStatus.
	 * @since 1.0.0
	 */
	public int getEndStatus() {
		return endStatus;
	}
	
	/**
	 * @param endStatus
	 *            The endStatus to set.
	 * @since 1.0.0
	 */
	public void setEndStatus(int endStatus) {
		this.endStatus = endStatus;
	}
	
	/**
	 * @return Returns the endValue.
	 * @since 1.0.0
	 */
	public int getEndValue() {
		return endValue;
	}
	
	/**
	 * @param endValue
	 *            The endValue to set.
	 * @since 1.0.0
	 */
	public void setEndValue(int endValue) {
		this.endValue = endValue;
	}
	
	/**
	 * @return Returns the object.
	 * @since 1.0.0
	 */
	public ArrayList getObject() {
		return object;
	}
	
	/**
	 * @param object
	 *            The object to set.
	 * @since 1.0.0
	 */
	public void setObject(ArrayList object) {
		this.object = object;
	}
	
	/**
	 * @return Returns the endCondition.
	 * @since 1.0.0
	 */
	public int getEndCondition() {
		return endCondition;
	}
	
	/**
	 * @param endCondition
	 *            The endCondition to set.
	 * @since 1.0.0
	 */
	public void setEndCondition(int endCondition) {
		this.endCondition = endCondition;
	}
	
	/**
	 * @return Returns the suspend.
	 * @since 1.0.0
	 */
	public int getSuspend() {
		return suspend;
	}
	
	/**
	 * @param suspend
	 *            The suspend to set.
	 * @since 1.0.0
	 */
	public void setSuspend(int suspend) {
		this.suspend = suspend;
	}
	
	/**
	 * @return Returns the calendar.
	 * @since 2.0.0
	 */
	public int getCalendar() {
		return calendar;
	}
	
	/**
	 * @param calendar
	 *            The calendar to set.
	 * @since 2.0.0
	 */
	public void setCalendar(int calendar) {
		this.calendar = calendar;
	}
	
	/**
	 * @return Returns the calendarId.
	 * @since 2.0.0
	 */
	public String getCalendarId() {
		return calendarId;
	}
	
	/**
	 * @param calendarId
	 *            The calendarId to set.
	 * @since 2.0.0
	 */
	public void setCalendarId(String calendarId) {
		this.calendarId = calendarId;
	}
	
	/**
	 * @return Returns the calendarEndValue.
	 * @since 2.0.0
	 */
	public int getCalendarEndValue() {
		return calendarEndValue;
	}
	
	/**
	 * @param calendarEndValue
	 *            The calendarEndValue to set.
	 * @since 2.0.0
	 */
	public void setCalendarEndValue(int calendarEndValue) {
		this.calendarEndValue = calendarEndValue;
	}
	
	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay() {
		return end_delay;
	}

	/**
	 * @param end_delay
	 * @since 2.1.0
	 */
	public void setEnd_delay(int end_delay) {
		this.end_delay = end_delay;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_condition_type() {
		return end_delay_condition_type;
	}

	/**
	 * @param end_delay_condition_type
	 * @since 2.1.0
	 */
	public void setEnd_delay_condition_type(int end_delay_condition_type) {
		this.end_delay_condition_type = end_delay_condition_type;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_job() {
		return end_delay_job;
	}

	/**
	 * @param end_delay_job
	 * @since 2.1.0
	 */
	public void setEnd_delay_job(int end_delay_job) {
		this.end_delay_job = end_delay_job;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_job_value() {
		return end_delay_job_value;
	}

	/**
	 * @param end_delay_job_value
	 * @since 2.1.0
	 */
	public void setEnd_delay_job_value(int end_delay_job_value) {
		this.end_delay_job_value = end_delay_job_value;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_notify() {
		return end_delay_notify;
	}

	/**
	 * @param end_delay_notify
	 * @since 2.1.0
	 */
	public void setEnd_delay_notify(int end_delay_notify) {
		this.end_delay_notify = end_delay_notify;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_notify_priority() {
		return end_delay_notify_priority;
	}

	/**
	 * @param end_delay_notify_priority
	 * @since 2.1.0
	 */
	public void setEnd_delay_notify_priority(int end_delay_notify_priority) {
		this.end_delay_notify_priority = end_delay_notify_priority;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_operation() {
		return end_delay_operation;
	}

	/**
	 * @param end_delay_operation
	 * @since 2.1.0
	 */
	public void setEnd_delay_operation(int end_delay_operation) {
		this.end_delay_operation = end_delay_operation;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_operation_end_value() {
		return end_delay_operation_end_value;
	}

	/**
	 * @param end_delay_operation_end_value
	 * @since 2.1.0
	 */
	public void setEnd_delay_operation_end_value(int end_delay_operation_end_value) {
		this.end_delay_operation_end_value = end_delay_operation_end_value;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_operation_type() {
		return end_delay_operation_type;
	}

	/**
	 * @param end_delay_operation_type
	 * @since 2.1.0
	 */
	public void setEnd_delay_operation_type(int end_delay_operation_type) {
		this.end_delay_operation_type = end_delay_operation_type;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_session() {
		return end_delay_session;
	}

	/**
	 * @param end_delay_session
	 * @since 2.1.0
	 */
	public void setEnd_delay_session(int end_delay_session) {
		this.end_delay_session = end_delay_session;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_session_value() {
		return end_delay_session_value;
	}

	/**
	 * @param end_delay_session_value
	 * @since 2.1.0
	 */
	public void setEnd_delay_session_value(int end_delay_session_value) {
		this.end_delay_session_value = end_delay_session_value;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getEnd_delay_time() {
		return end_delay_time;
	}

	/**
	 * @param end_delay_time
	 * @since 2.1.0
	 */
	public void setEnd_delay_time(int end_delay_time) {
		this.end_delay_time = end_delay_time;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public Date getEnd_delay_time_value() {
		return end_delay_time_value;
	}

	/**
	 * @param end_delay_time_value
	 * @since 2.1.0
	 */
	public void setEnd_delay_time_value(Date end_delay_time_value) {
		this.end_delay_time_value = end_delay_time_value;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay() {
		return start_delay;
	}

	/**
	 * @param start_delay
	 * @since 2.1.0
	 */
	public void setStart_delay(int start_delay) {
		this.start_delay = start_delay;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_condition_type() {
		return start_delay_condition_type;
	}

	/**
	 * @param start_delay_condition_type
	 * @since 2.1.0
	 */
	public void setStart_delay_condition_type(int start_delay_condition_type) {
		this.start_delay_condition_type = start_delay_condition_type;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_notify() {
		return start_delay_notify;
	}

	/**
	 * @param start_delay_notify
	 * @since 2.1.0
	 */
	public void setStart_delay_notify(int start_delay_notify) {
		this.start_delay_notify = start_delay_notify;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_notify_priority() {
		return start_delay_notify_priority;
	}

	/**
	 * @param start_delay_notify_priority
	 * @since 2.1.0
	 */
	public void setStart_delay_notify_priority(int start_delay_notify_priority) {
		this.start_delay_notify_priority = start_delay_notify_priority;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_operation() {
		return start_delay_operation;
	}

	/**
	 * @param start_delay_operation
	 * @since 2.1.0
	 */
	public void setStart_delay_operation(int start_delay_operation) {
		this.start_delay_operation = start_delay_operation;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_operation_end_value() {
		return start_delay_operation_end_value;
	}

	/**
	 * @param start_delay_operation_end_value
	 * @since 2.1.0
	 */
	public void setStart_delay_operation_end_value(
			int start_delay_operation_end_value) {
		this.start_delay_operation_end_value = start_delay_operation_end_value;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_operation_type() {
		return start_delay_operation_type;
	}

	/**
	 * @param start_delay_operation_type
	 * @since 2.1.0
	 */
	public void setStart_delay_operation_type(int start_delay_operation_type) {
		this.start_delay_operation_type = start_delay_operation_type;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_session() {
		return start_delay_session;
	}

	/**
	 * @param start_delay_session
	 * @since 2.1.0
	 */
	public void setStart_delay_session(int start_delay_session) {
		this.start_delay_session = start_delay_session;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_session_value() {
		return start_delay_session_value;
	}

	/**
	 * @param start_delay_session_value
	 * @since 2.1.0
	 */
	public void setStart_delay_session_value(int start_delay_session_value) {
		this.start_delay_session_value = start_delay_session_value;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getStart_delay_time() {
		return start_delay_time;
	}

	/**
	 * @param start_delay_time
	 * @since 2.1.0
	 */
	public void setStart_delay_time(int start_delay_time) {
		this.start_delay_time = start_delay_time;
	}

	/**
	 * @return
	 * @since 2.1.0
	 */
	public Date getStart_delay_time_value() {
		return start_delay_time_value;
	}

	/**
	 * @param start_delay_time_value
	 * @since 2.1.0
	 */
	public void setStart_delay_time_value(Date start_delay_time_value) {
		this.start_delay_time_value = start_delay_time_value;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @version 2.1.0
	 * @since 2.0.0
	 */
	@SuppressWarnings("unchecked")
	protected Object clone() {
		try {
			JobWaitRuleInfo clone = (JobWaitRuleInfo)super.clone();
			
			clone.setCondition(this.getCondition());
			clone.setEndCondition(this.getEndCondition());
			clone.setEndStatus(this.getEndStatus());
			clone.setEndValue(this.getEndValue());
			clone.setSkip(this.getSkip());
			clone.setSkipEndStatus(this.getSkipEndStatus());
			clone.setSkipEndValue(this.getSkipEndValue());
			clone.setSuspend(this.getSuspend());
			clone.setCalendar(this.getCalendar());
			clone.setCalendarId(this.getCalendarId());
			clone.setCalendarEndValue(this.getCalendar());
			clone.setStart_delay(this.getStart_delay());
			clone.setStart_delay_session(this.getStart_delay_session());
			clone.setStart_delay_session_value(this.getStart_delay_session_value());
			clone.setStart_delay_time(this.getStart_delay_time());
			clone.setStart_delay_time_value(this.getStart_delay_time_value());
            if(this.getStart_delay_time_value() instanceof Date){
                clone.setStart_delay_time_value((Date)this.getStart_delay_time_value().clone());
            }
			clone.setStart_delay_condition_type(this.getStart_delay_condition_type());
			clone.setStart_delay_notify(this.getStart_delay_notify());
			clone.setStart_delay_notify_priority(this.getStart_delay_notify_priority());
			clone.setStart_delay_operation(this.getStart_delay_operation());
			clone.setStart_delay_operation_type(this.getStart_delay_operation_type());
			clone.setStart_delay_operation_end_value(this.getStart_delay_operation_end_value());
			clone.setEnd_delay(this.getEnd_delay());
			clone.setEnd_delay_session(this.getEnd_delay_session());
			clone.setEnd_delay_session_value(this.getEnd_delay_session_value());
			clone.setEnd_delay_job(this.getEnd_delay_job());
			clone.setEnd_delay_job_value(this.getEnd_delay_job_value());
			clone.setEnd_delay_time(this.getEnd_delay_time());
            if(this.getEnd_delay_time_value() instanceof Date){
                clone.setEnd_delay_time_value((Date)this.getEnd_delay_time_value().clone());
            }
			clone.setEnd_delay_condition_type(this.getEnd_delay_condition_type());
			clone.setEnd_delay_notify(this.getEnd_delay_notify());
			clone.setEnd_delay_notify_priority(this.getEnd_delay_notify_priority());
			clone.setEnd_delay_operation(this.getEnd_delay_operation());
			clone.setEnd_delay_operation_type(this.getEnd_delay_operation_type());
			clone.setEnd_delay_operation_end_value(this.getEnd_delay_operation_end_value());
			
			ArrayList cloneList = new ArrayList();
			if(this.getObject() != null && this.getObject() instanceof ArrayList){
				for(int i = 0; i < this.getObject().size(); i++){
					Object source = this.getObject().get(i);
					if(source != null && source instanceof JobObjectInfo){
						cloneList.add(((JobObjectInfo)source).clone());
					}
				}
			}
			clone.setObject(cloneList);
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}