/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ѥ᡼󥯥饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class JobParameterInfo implements Serializable, Cloneable{
	private static final long serialVersionUID = 981926727088488957L;

	/** ѥ᡼ID */
	protected String paramId;
	
	/**  */
	protected int type;
	
	/**  */
	protected String description;
	
	/**  */
	protected String value;
	
	/**
	 * @return
	 * @since 2.1.0
	 */
	public String getDescription() {
		return description;
	}
	
	/**
	 * @param description
	 * @since 2.1.0
	 */
	public void setDescription(String description) {
		this.description = description;
	}
	
	/**
	 * @return
	 * @since 2.1.0
	 */
	public String getParamId() {
		return paramId;
	}
	
	/**
	 * @param paramId
	 * @since 2.1.0
	 */
	public void setParamId(String paramId) {
		this.paramId = paramId;
	}
	
	/**
	 * @return
	 * @since 2.1.0
	 */
	public int getType() {
		return type;
	}
	
	/**
	 * @param type
	 * @since 2.1.0
	 */
	public void setType(int type) {
		this.type = type;
	}
	
	/**
	 * @return
	 * @since 2.1.0
	 */
	public String getValue() {
		return value;
	}
	
	/**
	 * @param value
	 * @since 2.1.0
	 */
	public void setValue(String value) {
		this.value = value;
	}
	
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 * @since 2.1.0
	 */
	protected Object clone() {
		try {
			JobParameterInfo clone = (JobParameterInfo)super.clone();
			
			clone.setParamId(this.getParamId());
			clone.setType(this.getType());
			clone.setDescription(this.getDescription());
			clone.setValue(this.getValue());
			
			return clone;
		} catch (CloneNotSupportedException e) {
			return null;
		}
	}
}