/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;
import java.util.Date;

/**
 * Ƚоݥ饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobObjectInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = -4050301670424654620L;

	/** Ƚоݼ */
    protected int m_type;

    /** ID */
    protected String m_jobId;

    /** ̾ */
    protected String m_jobName;

    /** λ */
    protected int m_value;

    /** ϻ */
    protected Date m_time;

    /**
     * @return Returns the jobId.
     * @since 1.0.0
     */
    public String getJobId() {
        return m_jobId;
    }

    /**
     * @param jobId
     *            The jobId to set.
     * @since 1.0.0
     */
    public void setJobId(String jobId) {
        this.m_jobId = jobId;
    }

    /**
     * @return Returns the m_time.
     * @since 1.0.0
     */
    public Date getTime() {
        return m_time;
    }

    /**
     * @param m_time
     *            The m_time to set.
     * @since 1.0.0
     */
    public void setTime(Date time) {
        this.m_time = time;
    }

    /**
     * @return Returns the value.
     * @since 1.0.0
     */
    public int getValue() {
        return m_value;
    }

    /**
     * @param value
     *            The value to set.
     * @since 1.0.0
     */
    public void setValue(int value) {
        this.m_value = value;
    }

    /**
     * @return Returns the type.
     * @since 1.0.0
     */
    public int getType() {
        return m_type;
    }

    /**
     * @param type
     *            The type to set.
     * @since 1.0.0
     */
    public void setType(int type) {
        this.m_type = type;
    }

    /**
     * @return Returns the jobName.
     * @since 1.0.0
     */
    public String getJobName() {
        return m_jobName;
    }

    /**
     * @param jobName
     *            The jobName to set.
     * @since 1.0.0
     */
    public void setJobName(String jobName) {
        this.m_jobName = jobName;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.0.0
     */
    protected Object clone() {
        try {
            JobObjectInfo clone = (JobObjectInfo)super.clone();
            
            clone.setJobId(this.getJobId());
            clone.setJobName(this.getJobName());
            clone.setType(this.getType());
            clone.setValue(this.getValue());
            if(this.getTime() instanceof Date){
                clone.setTime((Date)this.getTime().clone());
            }
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}