/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ֥եž饹
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class JobFileInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = 6448926354392693297L;

	/** ˡ */
    protected int m_processingMethod;
    
	/** žեƥID */
    protected String m_srcFacilityID;

	/** žեƥID */
    protected String m_destFacilityID;

    /** ž */
    protected String m_srcScope;
    
    /** ž襹 */
    protected String m_destScope;

    /** žե */
    protected String m_srcFile;

    /** žȥǥ쥯ȥ */
    protected String m_srcWorkDir;

    /** žǥ쥯ȥ */
    protected String m_destDirectory;

    /** žȥǥ쥯ȥ */
    protected String m_destWorkDir;
    
    /** ե밵 */
    protected int m_compressionFlg;
    
    /** å */
    protected int m_checkFlg;
    
    /** ¹ԥ桼 */
    protected String m_user;

    /**
     * @return Returns the compressionFlg.
     * @since 2.0.0
     */
    public int getCompressionFlg() {
        return m_compressionFlg;
    }

    /**
     * @param compressionFlg
     *            The compressionFlg to set.
     * @since 2.0.0
     */
    public void setCompressionFlg(int compressionFlg) {
        this.m_compressionFlg = compressionFlg;
    }
    
    /**
     * @return Returns the checkFlg.
     * @since 2.0.0
     */
    public int getCheckFlg() {
        return m_checkFlg;
    }

    /**
     * @param checkFlg
     *            The checkFlg to set.
     * @since 2.0.0
     */
    public void setCheckFlg(int checkFlg) {
        this.m_checkFlg = checkFlg;
    }
    
    /**
     * @return Returns the srcScope.
     * @since 2.0.0
     */
    public String getSrcScope() {
        return m_srcScope;
    }

    /**
     * @param srcScope
     *            The srcScope to set.
     * @since 2.0.0
     */
    public void setSrcScope(String srcScope) {
        this.m_srcScope = srcScope;
    }

    /**
     * @return Returns the destScope.
     * @since 2.0.0
     */
    public String getDestScope() {
        return m_destScope;
    }

    /**
     * @param destScope
     *            The destScope to set.
     * @since 2.0.0
     */
    public void setDestScope(String destScope) {
        this.m_destScope = destScope;
    }
    
    /**
     * @return Returns the srcFacilityID.
     * @since 2.0.0
     */
    public String getSrcFacilityID() {
        return m_srcFacilityID;
    }

    /**
     * @param srcFacilityID
     *            The srcFacilityID to set.
     * @since 2.0.0
     */
    public void setSrcFacilityID(String srcFacilityID) {
        this.m_srcFacilityID = srcFacilityID;
    }

    /**
     * @return Returns the destFacilityID.
     * @since 2.0.0
     */
    public String getDestFacilityID() {
        return m_destFacilityID;
    }

    /**
     * @param destFacilityID
     *            The destFacilityID to set.
     * @since 2.0.0
     */
    public void setDestFacilityID(String destFacilityID) {
        this.m_destFacilityID = destFacilityID;
    }
    
    /**
     * @return Returns the srcFile.
     * @since 2.0.0
     */
    public String getSrcFile() {
        return m_srcFile;
    }

    /**
     * @param srcFile
     *            The srcFile to set.
     * @since 2.0.0
     */
    public void setSrcFile(String srcFile) {
        this.m_srcFile = srcFile;
    }
    
    /**
     * @return Returns the srcWorkDir.
     * @since 2.0.0
     */
    public String getSrcWorkDir() {
        return m_srcWorkDir;
    }

    /**
     * @param srcWorkDir
     *            The srcWorkDir to set.
     * @since 2.0.0
     */
    public void setSrcWorkDir(String srcWorkDir) {
        this.m_srcWorkDir = srcWorkDir;
    }
    
    /**
     * @return Returns the destDirectory.
     * @since 2.0.0
     */
    public String getDestDirectory() {
        return m_destDirectory;
    }

    /**
     * @param destDirectory
     *            The destDirectory to set.
     * @since 2.0.0
     */
    public void setDestDirectory(String destDirectory) {
        this.m_destDirectory = destDirectory;
    }
    
    /**
     * @return Returns the destWorkDir.
     * @since 2.0.0
     */
    public String getDestWorkDir() {
        return m_destWorkDir;
    }

    /**
     * @param destWorkDir
     *            The destWorkDir to set.
     * @since 2.0.0
     */
    public void setDestWorkDir(String destWorkDir) {
        this.m_destWorkDir = destWorkDir;
    }

    /**
     * @return Returns the processingMethod.
     * @since 2.0.0
     */
    public int getProcessingMethod() {
        return m_processingMethod;
    }

    /**
     * @param processingMethod
     *            The processingMethod to set.
     * @since 2.0.0
     */
    public void setProcessingMethod(int processingMethod) {
        this.m_processingMethod = processingMethod;
    }

    /**
     * @return Returns the user.
     * @since 2.0.0
     */
    public String getUser() {
        return m_user;
    }

    /**
     * @param user
     *            The user to set.
     * @since 2.0.0
     */
    public void setUser(String user) {
        this.m_user = user;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.0.0
     */
    protected Object clone() {
        try {
            JobFileInfo clone = (JobFileInfo)super.clone();
            
            clone.setProcessingMethod(this.getProcessingMethod());
            clone.setSrcFacilityID(this.getSrcFacilityID());
            clone.setDestFacilityID(this.getDestFacilityID());
            clone.setSrcScope(this.getSrcScope());
            clone.setDestScope(this.getDestScope());
            clone.setSrcFile(this.getSrcFile());
            clone.setSrcWorkDir(this.getSrcWorkDir());
            clone.setDestDirectory(this.getDestDirectory());
            clone.setDestWorkDir(this.getDestWorkDir());
            clone.setCompressionFlg(this.getCompressionFlg());
            clone.setCheckFlg(this.getCheckFlg());
            clone.setUser(this.getUser());
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}