/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.jobmanagement.bean;

import java.io.Serializable;

/**
 * ֥ޥɥ饹
 * 
 * @version 2.0.0
 * @since 1.0.0
 */
public class JobCommandInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = 333607610499761260L;

	/** եƥID */
    protected String m_facilityID;

    /**  */
    protected String m_scope;

    /** ˡ */
    protected int m_processingMethod;

    /** ưޥ */
    protected String m_startCommand;

    /** ߥޥ */
    protected String m_stopCommand;

    /** ¹ԥ桼 */
    protected String m_user;

    /** 顼λ */
    protected int m_errorEndFlg;

    /** 顼λ */
    protected int m_errorEndValue;

    /**
     * @return Returns the errorEndFlg.
     * @since 1.0.0
     */
    public int getErrorEndFlg() {
        return m_errorEndFlg;
    }

    /**
     * @param errorEndFlg
     *            The errorEndFlg to set.
     * @since 1.0.0
     */
    public void setErrorEndFlg(int errorEndFlg) {
        this.m_errorEndFlg = errorEndFlg;
    }

    /**
     * @return Returns the errorEndValue.
     * @since 1.0.0
     */
    public int getErrorEndValue() {
        return m_errorEndValue;
    }

    /**
     * @param errorEndValue
     *            The errorEndValue to set.
     * @since 1.0.0
     */
    public void setErrorEndValue(int errorEndValue) {
        this.m_errorEndValue = errorEndValue;
    }

    /**
     * @return Returns the scope.
     * @since 1.0.0
     */
    public String getScope() {
        return m_scope;
    }

    /**
     * @param scope
     *            The scope to set.
     * @since 1.0.0
     */
    public void setScope(String scope) {
        this.m_scope = scope;
    }

    /**
     * @return Returns the m_command.
     * @since 1.0.0
     */
    public String getStartCommand() {
        return m_startCommand;
    }

    /**
     * @param m_command
     *            The m_command to set.
     * @since 1.0.0
     */
    public void setStartCommand(String startCommand) {
        this.m_startCommand = startCommand;
    }

    /**
     * @return Returns the facilityID.
     * @since 1.0.0
     */
    public String getFacilityID() {
        return m_facilityID;
    }

    /**
     * @param facilityID
     *            The facilityID to set.
     * @since 1.0.0
     */
    public void setFacilityID(String facilityID) {
        this.m_facilityID = facilityID;
    }

    /**
     * @return Returns the forcedEndingCommand.
     * @since 1.0.0
     */
    public String getStopCommand() {
        return m_stopCommand;
    }

    /**
     * @param forcedEndingCommand
     *            The forcedEndingCommand to set.
     * @since 1.0.0
     */
    public void setStopCommand(String stopCommand) {
        this.m_stopCommand = stopCommand;
    }

    /**
     * @return Returns the processingMethod.
     * @since 1.0.0
     */
    public int getProcessingMethod() {
        return m_processingMethod;
    }

    /**
     * @param processingMethod
     *            The processingMethod to set.
     * @since 1.0.0
     */
    public void setProcessingMethod(int processingMethod) {
        this.m_processingMethod = processingMethod;
    }

    /**
     * @return Returns the user.
     * @since 1.0.0
     */
    public String getUser() {
        return m_user;
    }

    /**
     * @param user
     *            The user to set.
     * @since 1.0.0
     */
    public void setUser(String user) {
        this.m_user = user;
    }
    
    /* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.0.0
     */
    protected Object clone() {
        try {
            JobCommandInfo clone = (JobCommandInfo)super.clone();
            
            clone.setErrorEndFlg(this.getErrorEndFlg());
            clone.setErrorEndValue(this.getErrorEndValue());
            clone.setFacilityID(this.getFacilityID());
            clone.setProcessingMethod(this.getProcessingMethod());
            clone.setScope(this.getScope());
            clone.setStartCommand(this.getStartCommand());
            clone.setStopCommand(this.getStopCommand());
            clone.setUser(this.getUser());
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}