/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.util;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoLocal;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoPK;
import com.clustercontrol.http.ejb.entity.MonitorHttpInfoUtil;

/**
 * HTTPƻ Ƚ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ControlHttpInfo {
	protected static Log m_log = LogFactory.getLog( ControlHttpInfo.class );
	
	/** ƻоID */
	protected String m_monitorTypeId;
	
	/** ƻID */
	protected String m_monitorId;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 * @param monitorId ƻID
	 * @param monitorTypeId ƻоID
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public ControlHttpInfo(String monitorId, String monitorTypeId) {
		m_monitorId = monitorId;
		m_monitorTypeId = monitorTypeId;
	}
	
	/**
	 * HTTPƻ
	 * 
	 * @return HTTPƻ
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public MonitorHttpInfo get() throws FinderException, NamingException{
		
		// HTTPƻ
		MonitorHttpInfoPK pk = new MonitorHttpInfoPK(m_monitorId, m_monitorTypeId);
		MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		MonitorHttpInfo http = new MonitorHttpInfo();
		http.setMonitorTypeId(m_monitorTypeId);
		http.setMonitorId(m_monitorId);
		http.setRequestUrl(httpLocal.getRequestUrl());
		http.setTimeout(httpLocal.getTimeout().intValue());
		http.setUrlReplace(httpLocal.getUrlReplace().intValue());
		http.setProxySet(httpLocal.getProxySet().intValue());
		http.setProxyHost(httpLocal.getProxyHost());
		http.setProxyPort(httpLocal.getProxyPort().intValue());
		
		return http;
	}
	
	/**
	 * HTTPƻɲ
	 * 
	 * @param http HTTPƻ
	 * @return 硢true
	 * @throws CreateException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean add(MonitorHttpInfo http) throws CreateException, NamingException {
		
		// HTTPƻɲ
		MonitorHttpInfoUtil.getLocalHome().create(
				m_monitorTypeId,
				m_monitorId,
				http.getRequestUrl(),
				Integer.valueOf(http.getTimeout()),
				Integer.valueOf(http.getUrlReplace()),
				Integer.valueOf(http.getProxySet()),
				http.getProxyHost(),
				Integer.valueOf(http.getProxyPort())
		);
		
		return true;
	}
	
	/**
	 * HTTPƻѹ
	 * 
	 * @param http HTTPƻ
	 * @return 硢true
	 * @throws CreateException
	 * @throws FinderException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean modify(MonitorHttpInfo http) throws CreateException, FinderException, NamingException {
		
		// HTTPƻ
		MonitorHttpInfoPK pk = new MonitorHttpInfoPK(m_monitorId, m_monitorTypeId);
		MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// HTTPƻ
		httpLocal.setRequestUrl(http.getRequestUrl());
		httpLocal.setUrlReplace(Integer.valueOf(http.getUrlReplace()));
		httpLocal.setTimeout(Integer.valueOf(http.getTimeout()));
		httpLocal.setProxySet(Integer.valueOf(http.getProxySet()));
		httpLocal.setProxyHost(http.getProxyHost());
		httpLocal.setProxyPort(Integer.valueOf(http.getProxyPort()));
		
		return true;
	}
	
	/**
	 * HTTPƻ
	 * 
	 * @return 硢true
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws NamingException
	 * @version 2.1.0
	 * @since 2.1.0
	 */
	public boolean delete() throws FinderException, RemoveException, NamingException {
		
		// HTTPƻ
		MonitorHttpInfoPK pk = new MonitorHttpInfoPK(m_monitorId, m_monitorTypeId);
		MonitorHttpInfoLocal httpLocal = MonitorHttpInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// HTTPƻ
		httpLocal.remove();
		
		return true;
	}
}
