/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.factory;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.http.bean.MonitorHttpInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpRunManagementHome;
import com.clustercontrol.http.util.ControlHttpInfo;
import com.clustercontrol.monitor.run.factory.AddMonitorNumericValueType;

/**
 * HTTPƻ ʹƻϿ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class AddMonitorHttp extends AddMonitorNumericValueType{
	
	protected static Log m_log = LogFactory.getLog( AddMonitorHttp.class );
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#addCheckInfo()
	 */
	@Override
	public boolean addCheckInfo() throws CreateException, NamingException{
		
		// HTTPƻɲ
		ControlHttpInfo http = new ControlHttpInfo(m_monitorInfo.getMonitorId(), m_monitorInfo.getMonitorTypeId());
		return http.add((MonitorHttpInfo)m_monitorInfo.getCheckInfo());
	}
	
	/* (non-Javadoc)
	 * @see com.clustercontrol.monitor.run.factory.AddMonitor#getJndiName()
	 */
	@Override
	public String getJndiName() {
		return MonitorHttpRunManagementHome.JNDI_NAME;
	}
}
