/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.http.ejb.session;

import java.rmi.RemoteException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Locale;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.SchedulerException;

import com.clustercontrol.bean.MonitorConstant;
import com.clustercontrol.http.factory.AddMonitorHttp;
import com.clustercontrol.http.factory.AddMonitorHttpString;
import com.clustercontrol.http.factory.DeleteMonitorHttp;
import com.clustercontrol.http.factory.DeleteMonitorHttpString;
import com.clustercontrol.http.factory.ModifyMonitorHttp;
import com.clustercontrol.http.factory.ModifyMonitorHttpString;
import com.clustercontrol.http.factory.SelectMonitorHttp;
import com.clustercontrol.http.factory.SelectMonitorHttpString;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.factory.AddMonitor;
import com.clustercontrol.monitor.run.factory.DeleteMonitor;
import com.clustercontrol.monitor.run.factory.ModifyMonitor;
import com.clustercontrol.monitor.run.factory.SelectMonitor;

/**
 * @ejb.bean name="MonitorHttpController"
 *           jndi-name="MonitorHttpController"
 *           type="Stateless"
 *           transaction-type="Container"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=NotifyController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=MonitorInfo"
 * 
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Home"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="LocalHome"
 *     
 * @ejb.permission
 *     unchecked="true"
 *     method-intf="Local"
 *     
 */
public abstract class MonitorHttpControllerBean implements SessionBean {
	
	protected static Log m_log = LogFactory.getLog( MonitorHttpControllerBean.class );
	
	@SuppressWarnings("unused")
	private SessionContext m_context;
	
	public void setSessionContext(SessionContext ctx) throws EJBException, RemoteException {
		m_context = ctx;
	}
	
	/**
	 * HTTPƻϿޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="HttpMonitorWrite"
	 *     method-intf="Remote"
	 * 
	 * @param info ƻ
	 * @return Ͽ硢true
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws SystemException
	 */
	public boolean addHttp(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();
		
		// HTTPƻϿ
		AddMonitor http = null;
		if(info.getMonitorType() == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			http = new AddMonitorHttp();
		}
		else if(info.getMonitorType() == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			http = new AddMonitorHttpString();
		}
		else{
			return false;
		}
		return  http.add(info, pri.getName());
	}
	
	/**
	 * HTTPƻ򹹿ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="HttpMonitorWrite"
	 *     method-intf="Remote"
	 * 
	 * @param info ƻ
	 * @return ѹ硢true
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws CreateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws ParseException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws SystemException
	 */
	public boolean modifyHttp(MonitorInfo info) throws InvalidTransactionException, IllegalStateException, CreateException, FinderException, RemoveException, SchedulerException, ParseException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
		
		Principal pri = m_context.getCallerPrincipal();
		
		// HTTPƻ򹹿
		ModifyMonitor http = null;
		if(info.getMonitorType() == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			http = new ModifyMonitorHttp();
		}
		else if(info.getMonitorType() == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			http = new ModifyMonitorHttpString();
		}
		else{
			return false;
		}
		return  http.modify(info, pri.getName());
	}
	
	/**
	 * HTTPƻޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="HttpMonitorWrite"
	 *     method-intf="Remote"
	 * 
	 * @param monitorId ƻID
	 * @param monitorType ƻȽ꥿
	 * @return 硢true
	 * @throws InvalidTransactionException
	 * @throws IllegalStateException
	 * @throws FinderException
	 * @throws RemoveException
	 * @throws SchedulerException
	 * @throws NamingException
	 * @throws NotSupportedException
	 * @throws HeuristicMixedException
	 * @throws HeuristicRollbackException
	 * @throws RollbackException
	 * @throws SystemException
	 */
	public boolean deleteHttp(String monitorId, int monitorType) throws InvalidTransactionException, IllegalStateException, FinderException, RemoveException, SchedulerException, NamingException, NotSupportedException, HeuristicMixedException, HeuristicRollbackException, RollbackException, SystemException {
		
		// HTTPƻ
		DeleteMonitor http = null;
		if(monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			http = new DeleteMonitorHttp();
		}
		else if(monitorType == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			http = new DeleteMonitorHttpString();
		}
		else{
			return false;
		}
		return  http.delete(MonitorConstant.STRING_HTTP, monitorId);
	}
	
	/**
	 * HTTPƻ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="HttpMonitorRead"
	 *     method-intf="Remote"
	 * 
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @param monitorId ƻID
	 * @param monitorType ƻȽ꥿
	 * @return HTTPƻ
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public MonitorInfo getHttpInfo(String monitorId, int monitorType) throws CreateException, FinderException, SchedulerException, NamingException {
		
		// HTTPƻ
		SelectMonitor http = null;
		if(monitorType == MonitorTypeConstant.TYPE_NUMERIC){
			// ʹƻξ
			http = new SelectMonitorHttp();
		}
		else if(monitorType == MonitorTypeConstant.TYPE_STRING){
			// ʸƻξ
			http = new SelectMonitorHttpString();
		}
		else{
			return null;
		}
		
		MonitorInfo info = http.getMonitor(MonitorConstant.STRING_HTTP, monitorId);
		return info;
	}
	
	/**
	 * HTTPƻꥹȤ֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     role-name="HttpMonitorRead"
	 *     method-intf="Remote"
	 *     
	 * @jboss.method-attributes
	 *     read-only="true"
	 * 
	 * @return Object2
	 * @throws NamingException 
	 * @throws SchedulerException 
	 * @throws FinderException 
	 * @throws CreateException 
	 * @throws CreateException
	 * @throws FinderException
	 * @throws SchedulerException
	 * @throws NamingException
	 */
	public ArrayList getHttpList() throws CreateException, FinderException, SchedulerException, NamingException {
		
		// HTTPƻ
		SelectMonitorHttp http = new SelectMonitorHttp();
		ArrayList list = http.getMonitorList(MonitorConstant.STRING_HTTP);
		
		return list;
	}
	
	/**
	 * HTTPƻΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     unchecked="true"
	 *     method-intf="Remote"
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHttpListTableDefine(Locale locale) {
		
		/** ơ֥ */
		SelectMonitorHttp http = new SelectMonitorHttp();
		ArrayList tableDefine = http.getMonitorListTableDefine(locale);
		
		return tableDefine;
	}
	
	/**
	 * HTTPƻ ʸƻȽΥơ֥֤ޤ
	 * 
	 * @ejb.interface-method
	 * 
	 * @ejb.permission
	 *     unchecked="true"
	 *     method-intf="Remote"
	 * 
	 * @param locale 
	 * @return TableColumnInfo
	 * 
	 * @version 2.1.0
	 */
	@SuppressWarnings("unchecked")
	public ArrayList getHttpStringValueListTableDefine(Locale locale) {
		
		/** ơ֥ */
		SelectMonitorHttpString http = new SelectMonitorHttpString();
		ArrayList tableDefine = http.getStringValueListTableDefine(locale);
		
		return tableDefine;
	}
}
