/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.http.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;
import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.naming.NamingException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * HTTPƻ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class GetHttp {

    /**
     * HTTPƻ֤ޤ
     * 
     * @param monitorId ƻID
     * @param monitorType ƻȽ꥿
     * @return HTTPƻ
     */
    public MonitorInfo getHttp(String monitorId, int monitorType) {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

    	MonitorInfo info = null;

    	try {
			info = http.getHttpInfo(monitorId, monitorType);
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (SchedulerException e) {
		} catch (NamingException e) {
		}

        return info;
    }
    
    /**
     * HTTPƻ֤ޤ
     * 
     * @return HTTPƻ
     */
    public ArrayList getHttpList() {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

        ArrayList records = null;
        
        try {
			records = http.getHttpList();
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (CreateException e) {
		} catch (FinderException e) {
		} catch (SchedulerException e) {
		} catch (NamingException e) {
		}

        return records;
    }
}