/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.http.action;

import java.rmi.AccessException;
import java.rmi.RemoteException;

import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;

import org.eclipse.jface.dialogs.MessageDialog;
import org.quartz.SchedulerException;

import com.clustercontrol.http.ejb.session.MonitorHttpController;
import com.clustercontrol.http.util.EjbConnectionManager;
import com.clustercontrol.util.Messages;

/**
 * HTTPƻ륯饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteHttp {

    /**
     * HTTPƻޤ
     * 
     * @param monitorId ƻID
     * @param monitorType ƻȽ꥿
     * @return 硢true
     */
    public boolean delete(String monitorId, int monitorType) {
    	
    	MonitorHttpController http = EjbConnectionManager.getConnectionManager().getHttpController();

        boolean result = false;
  
    	try {
			result = http.deleteHttp(monitorId, monitorType);
			return result;
		} catch (InvalidTransactionException e) {
		} catch (IllegalStateException e) {
		} catch (RemoteException e) {
			if(e instanceof AccessException){
				// ʤξ硢顼ɽ
	            MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
			}
		} catch (FinderException e) {
		} catch (RemoveException e) {
		} catch (SchedulerException e) {
		} catch (NamingException e) {
		} catch (NotSupportedException e) {
		} catch (HeuristicMixedException e) {
		} catch (HeuristicRollbackException e) {
		} catch (RollbackException e) {
		} catch (SystemException e) {
		}

        return false;
    }
}