/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.hinemosagent.action.AddAgent;
import com.clustercontrol.hinemosagent.action.DeleteAgent;
import com.clustercontrol.hinemosagent.action.GetAgent;
import com.clustercontrol.hinemosagent.action.ModifyAgent;
import com.clustercontrol.hinemosagent.bean.AgentTabelDefine;
import com.clustercontrol.hinemosagent.composite.AgentListComposite;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * Hinemos Agentƻ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class AgentListDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** Hinemos Agent */
    private AgentListComposite agentList = null;

    /** ɲåܥ */
    private Button buttonAdd = null;

    /** ѹܥ */
    private Button buttonModify = null;

    /** ܥ */
    private Button buttonDelete = null;

    /** ͭܥ */
    private Button buttonValid = null;
    
    /** ̵ܥ */
    private Button buttonInvalid = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public AgentListDialog(Shell parent) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(800, 400);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.agent.list"));

        // 쥤
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout(layout);

        /*
         * Hinemos Agentƻ
         */

        this.agentList = new AgentListComposite(parent, SWT.BORDER);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.agentList.setLayoutData(gridData);

        /*
         * ܥ
         */

        Composite composite = new Composite(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData(gridData);

        // ɲåܥ
        this.buttonAdd = this
                .createButton(composite, Messages.getString("add"));
        this.buttonAdd.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	AgentCreateDialog dialog = new AgentCreateDialog(getParentShell());
                if (dialog.open() == IDialogConstants.OK_ID) {
                	
                	MonitorInfo info = dialog.getInputData();
                	if(info != null){
                    	boolean result = new AddAgent().add(info);
                        String[] args = { info.getMonitorId() };
                        if(result){
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                            box.setText(Messages.getString("successful"));
                            box.setMessage(Messages.getString("message.monitor.33",args));
                            box.open();
                            
                        	agentList.update();
                        }
                        else{
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                            box.setText(Messages.getString("failed"));
                            box.setMessage(Messages.getString("message.monitor.34",args));
                            box.open();
                        }
                	}
                }
            }
        });

        // ѹܥ
        Label dummy = new Label(composite, SWT.NONE);
        this.buttonModify = this.createButton(composite, Messages.getString("modify"));
        this.buttonModify.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String monitorId = null;
            	
            	Table table = agentList.getTableViewer().getTable();
            	TableItem[] item = table.getSelection();
            	
            	if(item != null && item.length>0){
            		try{
            			monitorId = (String)((ArrayList)item[0].getData()).get(AgentTabelDefine.MONITOR_ID);
            		}
            		catch(Exception ex){
            		}
            	}

                if (monitorId != null) {
                	AgentCreateDialog dialog = new AgentCreateDialog(getParentShell(), monitorId);
                    if (dialog.open() == IDialogConstants.OK_ID) {
                    	boolean result = new ModifyAgent().modify(dialog.getInputData());
                        String[] args = { monitorId };
                        if(result){
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                            box.setText(Messages.getString("successful"));
                            box.setMessage(Messages.getString("message.monitor.35",args));
                            box.open();
                            
                            int selectIndex = table.getSelectionIndex();
                            agentList.update();
                            table.setSelection(selectIndex);
                        }
                        else{
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                            box.setText(Messages.getString("failed"));
                            box.setMessage(Messages.getString("message.monitor.36",args));
                            box.open();
                        }
                    }
                }
                else{
                    MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.monitor.1"));
                    box.open();
                  }
            }
        });

        // ܥ
        dummy = new Label(composite, SWT.NONE);
        this.buttonDelete = this.createButton(composite, Messages
                .getString("delete"));
        this.buttonDelete.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String monitorId = null;
            	
            	Table table = agentList.getTableViewer().getTable();
            	TableItem[] item = table.getSelection();
            	
            	if(item != null && item.length>0){
            		try{
            			monitorId = (String)((ArrayList)item[0].getData()).get(AgentTabelDefine.MONITOR_ID);
            		}
            		catch(Exception ex){
            		}
            	}

                if (monitorId != null) {
                	
                  MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
                  confirmBox.setText(Messages.getString("confirmed"));
                  String[] args = { monitorId };
                  String message = Messages.getString("message.monitor.39",args);
                  confirmBox.setMessage(message);

		          if (confirmBox.open() == SWT.OK) {
		        	  boolean result = new DeleteAgent().delete(monitorId);
                      if(result){
                          MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                          box.setText(Messages.getString("successful"));
                          box.setMessage(Messages.getString("message.monitor.37", args));
                          box.open();
                          
                          agentList.update();
                      }
                      else{
                          MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                          box.setText(Messages.getString("failed"));
                          box.setMessage(Messages.getString("message.monitor.38", args));
                          box.open();
                      }
		          }
                }
                else{
                  MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                  box.setText(Messages.getString("warning"));
                  box.setMessage(Messages.getString("message.monitor.1"));
                  box.open();
                }
            }
        });
        
        // ͭܥ
        dummy = new Label(composite, SWT.NONE);
        dummy = new Label(composite, SWT.NONE);
        this.buttonValid = this.createButton(composite, Messages
                .getString("valid"));
        this.buttonValid.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	//ͭѹ
            	setValid(YesNoConstant.TYPE_YES);
            }
        });
        
        // ̵ܥ
        this.buttonInvalid = this.createButton(composite, Messages
                .getString("invalid"));
        this.buttonInvalid.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	//̵ѹ
            	setValid(YesNoConstant.TYPE_NO);
            }
        });

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ̤Υܥޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param label
     *            ܥΥ٥
     * @return 줿ܥ
     */
    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);

        button.setText(label);

        return button;
    }
    
    /**
     * Ĥܥޤ
     * 
     * @param parent ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        // Ĥܥ
        this.createButton(parent, IDialogConstants.CANCEL_ID, Messages.getString("close"), false);
    }

    /**
     * ̵ͭѹ
     * 
     * @param valid
     */
    public void setValid(int valid) {

		//򤵤줿ƻID
		ArrayList<String> list = agentList.getSelectionData();
		if (list != null && list.size() > 0) {
			
			StringBuilder monitorIds = new StringBuilder();
			for(int i = 0; i < list.size(); i++){
				if(i > 0){
					monitorIds.append(", ");
				}
				monitorIds.append(list.get(i));
			}
			MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
			confirmBox.setText(Messages.getString("confirmed"));
            String[] confirmArgs = { monitorIds.toString() };
            if(valid == YesNoConstant.TYPE_YES)
            	confirmBox.setMessage(Messages.getString("message.monitor.47",confirmArgs));
            else
            	confirmBox.setMessage(Messages.getString("message.monitor.48",confirmArgs));
            if(confirmBox.open() == SWT.CANCEL){
            	return;
            }
			
			for(int i = 0; i < list.size(); i++){
				String monitorId = list.get(i);
				
				if(monitorId != null && !monitorId.equals("")){
			        //ƻ
			        MonitorInfo info = new GetAgent().getAgent(monitorId);        	
			        
			        //̵ͭ
			        info.setValid(valid);
			        
			        //ƻ򹹿
			        boolean result = new ModifyAgent().modify(info);
                    if(!result){
                        MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                        box.setText(Messages.getString("failed"));
                        String[] args = { monitorId };
                        box.setMessage(Messages.getString("message.monitor.36",args));
                        box.open();
                    }
				}
			}
    			
            int selectIndex = agentList.getTableViewer().getTable().getSelectionIndex();
            agentList.update();
            agentList.getTableViewer().getTable().setSelection(selectIndex);
		}
		else{
        	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
            box.setText(Messages.getString("warning"));
            box.setMessage(Messages.getString("message.monitor.1"));
            box.open();
        }
    }
}