/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.hinemosagent.factory;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.mq.Subscription;
import org.jboss.mq.selectors.Selector;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoLocal;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoPK;
import com.clustercontrol.hinemosagent.ejb.entity.MonitorAgentInfoUtil;
import com.clustercontrol.monitor.run.bean.MonitorJudgementInfo;
import com.clustercontrol.monitor.run.factory.RunMonitorTruthValueType;
import com.clustercontrol.util.Messages;
import com.clustercontrol.util.apllog.AplLogger;

/**
 * Hinemos Agentƻ륯饹
 *
 * @version 2.1.0
 * @since 2.0.0
 */
public class RunMonitorAgent extends RunMonitorTruthValueType {
	
	protected static Log m_log = LogFactory.getLog( RunMonitorAgent.class );

	public static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	public static final String JOB_AGENT_OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/JobManagement/execute,service=Topic";
	public static final String LOG_AGENT_OBJECT_NAME = "jboss.mq.destination:name=clustercontrol/Logtransfer/update,service=Topic";
	public static final String OPERATION_NAME = "listAllSubscriptions";
	
	public static final String MESSAGE_ID_INFO = "001";
	public static final String MESSAGE_ID_WARNING = "002";
	public static final String MESSAGE_ID_CRITICAL = "003";
	public static final String MESSAGE_ID_UNKNOWN = "004";
	
	/** Agentƻ */
	protected MonitorAgentInfoLocal m_agent = null;
	/** ֥ȥå */
	protected int m_checkJobAgent = YesNoConstant.TYPE_YES;
	/** žȥå */
	protected int m_checkLogAgent = YesNoConstant.TYPE_YES;
	
	/** å */
	protected String m_message = null;
	
	protected String m_messageJobAgent = "";;
	protected boolean m_valueJobAgent = false;
	
	protected String m_messageLogAgent = "";;
	protected boolean m_valueLogAgent = false;
	
	/**
	 * 󥹥ȥ饯
	 * 
	 */
	public RunMonitorAgent() throws NamingException, JMSException, CreateException{
		super();
	}
	/**
	 * Hinemos ֥ȡžȤå
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	@Override
	public boolean collect(String facilityId) {
		boolean result = false;
		boolean resultJobAgent = false;
		boolean resultLogAgent = false;
		m_value = false;
		
		// ƻ볫ϻ
		m_nodeDate = m_now.getTime();
		
		//֥ȥå
		if(m_checkJobAgent == YesNoConstant.TYPE_YES)
			resultJobAgent = checkJobAgent(facilityId);
		
		//žȥå
		if(m_checkLogAgent == YesNoConstant.TYPE_YES)
			resultLogAgent = checkLogAgent(facilityId);
		
		//ɤ餫ʤСͤϼǤȤȤ
		if(resultJobAgent || resultLogAgent){
			result = true;
		}
		
		//å
		if(m_checkJobAgent == YesNoConstant.TYPE_YES && 
				m_checkLogAgent == YesNoConstant.TYPE_YES){
			//ξȤʤСȤ
			if(m_valueJobAgent && m_valueLogAgent){
				m_value = true;
			}
			m_message = m_messageJobAgent + "\n" + m_messageLogAgent;
		}
		else if(m_checkJobAgent == YesNoConstant.TYPE_YES){
			m_value = m_valueJobAgent;
			m_message = m_messageJobAgent;
		}
		else if(m_checkLogAgent == YesNoConstant.TYPE_YES){
			m_value = m_valueLogAgent;
			m_message = m_messageLogAgent;
		}
		
		return result;
	}
	
	/**
	 * Hinemos ֥Ȥå
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	public boolean checkJobAgent(String facilityId) {
		boolean result = false;
		boolean duplication = false;
		
		//ͤ
		m_valueJobAgent = false;
		m_messageJobAgent = "";
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(JOB_AGENT_OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);

	        //̤å
	        if(returnObject instanceof List){
		        //åʸ
		        String checkString = "FacilityId='" + facilityId + "'";
	        
		        //ƱեƥIDǤAgentʣưå
	        	HashMap<String, String> map = new HashMap<String, String>();
	        	
	        	for(int i = 0; i < ((List)returnObject).size(); i++){
	        		//Subscription
	        		Subscription subscription = (Subscription)((List)returnObject).get(i);
	        		
	        		try {
	        			//SubscriptionSelector
	        			Selector selecter = subscription.getSelector();
	        			
	        			//Selectorȥåʸ
		        		if(selecter != null && 
		        				selecter.selector.indexOf(checkString) != -1){
		        			//åʸޤ
		        			
		        			//ƱեƥID¸ߤƤ뤫å
		        			if(map.get(facilityId) == null){
		        				//¸ߤƤʤ
			        			m_valueJobAgent = true;
			        			map.put(facilityId, facilityId);
		        			}
		        			else{
		        				//¸ߤƤ
		        				m_valueJobAgent = false;
		        				duplication = true;
		        				
		        				//٥Ȥ˽
		                        AplLogger apllog = new AplLogger("AGT","agt");
		                        String[] args = {facilityId};
		                        apllog.put("SYS","001", args);
		                        
		                        break;
		        			}
		        		}
					} catch (InvalidSelectorException e) {
						m_log.debug("collect() : " + e.getMessage());
					}
	        	}
	        	
        		if(!duplication){
    	        	if(m_valueJobAgent){
    	        		//OK
    	        		m_messageJobAgent = Messages.getString("message.agent.1");
    	        	}
    	        	else{
    	        		//NG
    	        		m_messageJobAgent = Messages.getString("message.agent.2");
    	        	}
        		}
        		else{
        			//ƱեƥAgentνʣ
        			String[] args = {facilityId};
    				m_messageJobAgent = Messages.getString("message.agent.3", args);
        		}
	        	
	        	result = true;
	        }
	        else{
	        	//ͼ
	        	m_messageJobAgent = Messages.getString("message.agent.4");
	        }
		} catch (NamingException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MalformedObjectNameException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (NullPointerException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (InstanceNotFoundException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MBeanException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (ReflectionException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (IOException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageJobAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		}

		return result;
	}

	/**
	 * Hinemos žȤå
	 * 
	 * @param facilityId եƥID
	 * @return ͼ硢true
	 */
	public boolean checkLogAgent(String facilityId) {
		boolean result = false;
		boolean duplication = false;
		
		//ͤ
		m_valueLogAgent = false;
		m_messageLogAgent = "";
		
		try{
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(LOG_AGENT_OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);

	        //̤å
	        if(returnObject instanceof List){
		        //åʸ
		        String checkString = "FacilityId='" + facilityId + "'";
	        
		        //ƱեƥIDǤAgentʣưå
	        	HashMap<String, String> map = new HashMap<String, String>();
	        	
	        	for(int i = 0; i < ((List)returnObject).size(); i++){
	        		//Subscription
	        		Subscription subscription = (Subscription)((List)returnObject).get(i);
	        		
	        		try {
	        			//SubscriptionSelector
	        			Selector selecter = subscription.getSelector();
	        			
	        			//Selectorȥåʸ
		        		if(selecter != null && 
		        				selecter.selector.indexOf(checkString) != -1){
		        			//åʸޤ
		        			
		        			//ƱեƥID¸ߤƤ뤫å
		        			if(map.get(facilityId) == null){
		        				//¸ߤƤʤ
			        			m_valueLogAgent = true;
			        			map.put(facilityId, facilityId);
		        			}
		        			else{
		        				//¸ߤƤ
		        				m_valueLogAgent = false;
		        				duplication = true;
		        				
		        				//٥Ȥ˽
		                        AplLogger apllog = new AplLogger("AGT","agt");
		                        String[] args = {facilityId};
		                        apllog.put("SYS","002", args);
		                        
		                        break;
		        			}
		        		}
					} catch (InvalidSelectorException e) {
						m_log.debug("collect() : " + e.getMessage());
					}
	        	}
	        	
        		if(!duplication){
    	        	if(m_valueLogAgent){
    	        		//OK
    	        		m_messageLogAgent = Messages.getString("message.agent.5");
    	        	}
    	        	else{
    	        		//NG
    	        		m_messageLogAgent = Messages.getString("message.agent.6");
    	        	}
        		}
        		else{
        			//ƱեƥAgentνʣ
        			String[] args = {facilityId};
    				m_messageLogAgent = Messages.getString("message.agent.7", args);
        		}
	        	
	        	result = true;
	        }
	        else{
	        	//ͼ
	        	m_messageLogAgent = Messages.getString("message.agent.4");
	        }
		} catch (NamingException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MalformedObjectNameException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (NullPointerException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (InstanceNotFoundException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (MBeanException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (ReflectionException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		} catch (IOException e) {
			m_log.debug("collect() : " + e.getMessage());
			m_messageLogAgent = Messages.getString("message.agent.4") + " (" + e.getMessage() + ")";
		}

		return result;
	}
	
	/* (non-Javadoc)
	 * Hinemos Agentƻ
	 * @see com.clustercontrol.monitor.run.factory.OperationNumericValueInfo#setMonitorAdditionInfo()
	 */
	@Override
	public void setCheckInfo() throws FinderException, NamingException{
		
		// Agentƻ
		MonitorAgentInfoPK pk = new MonitorAgentInfoPK(m_monitorId, m_monitorTypeId);
		m_agent = MonitorAgentInfoUtil.getLocalHome().findByPrimaryKey(pk);
		
		// Agentƻ
		if(m_agent.getCheckJobAgent() != null)
			m_checkJobAgent = m_agent.getCheckJobAgent().intValue();
		if(m_agent.getCheckLogAgent() != null)
			m_checkLogAgent = m_agent.getCheckLogAgent().intValue();
	}

	/* (non-Javadoc)
	 * ΡѥåID
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageId(int)
	 */
	@Override
	public String getMessageId(int id) {

		MonitorJudgementInfo info = (MonitorJudgementInfo)m_judgementInfoList.get(id);
		if(info != null){
			int priority = info.getPriority();
			if(priority == PriorityConstant.TYPE_INFO){
				return MESSAGE_ID_INFO;
			}
			else if(priority == PriorityConstant.TYPE_WARNING){
				return MESSAGE_ID_WARNING;
			}
			else if(priority == PriorityConstant.TYPE_CRITICAL){
				return MESSAGE_ID_CRITICAL;
			}
		}
		return MESSAGE_ID_UNKNOWN;
	}
	
	/* (non-Javadoc)
	 * Ρѥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessage(int)
	 */
	@Override
	public String getMessage(int id) {
		return m_message;
	}

	/* (non-Javadoc)
	 * Ρѥꥸʥå
	 * @see com.clustercontrol.monitor.run.factory.OperationMonitor#getMessageOrg(int)
	 */
	@Override
	public String getMessageOrg(int id) {
		return null;
	}

	/* ( Javadoc)
	 * ѥåID
	 * @see com.clustercontrol.monitor.run.factory.RunMonitor#getMessageIdForScope(int)
	 */
	@Override
	public String getMessageIdForScope(int priority) {
		
		if(priority == PriorityConstant.TYPE_INFO){
			return MESSAGE_ID_INFO;
		}
		else if(priority == PriorityConstant.TYPE_WARNING){
			return MESSAGE_ID_WARNING;
		}
		else if(priority == PriorityConstant.TYPE_CRITICAL){
			return MESSAGE_ID_CRITICAL;
		}
		else{
			return MESSAGE_ID_UNKNOWN;
		}
	}
}
