/*
                                                                                                
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
 
*/

package com.clustercontrol.failover.monitor.jmx;

import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Vector;

import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;

import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.interfaces.HAPartition.AsynchHAMembershipListener;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.system.ServiceMBeanSupport;

/**
 * @jmx.mbean
 *     name="user:service=FailoverMonitorService,name=FailoverMonitorService"
 *     description="FailoverMonitorService MBean"
 *     extends="org.jboss.system.ServiceMBean"
 * 
 * @jboss.service servicefile="FailoverMonitor"
 */
public class FailoverMonitorService extends ServiceMBeanSupport 
    implements FailoverMonitorServiceMBean, AsynchHAMembershipListener {
	
	private String jndiName = "FailoverMonitorService";  // JNDIϿݤ̾
	
	private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	private static final String OBJECT_NAME = "jboss:service=HinemosPartition";
	private static final String OPERATION_NAME = "getCurrentView";
	
	private String partitionName = "HinemosPartition";
	private HAPartition partition;
	private String hostname;
	private ArrayList<String> members = new ArrayList<String>();
	
	public FailoverMonitorService(){
		
	}
	
	/**
	 * @jmx.managed-attribute
	 * 
	 * @see com.clustercontrol.failover.monitor.jmx.FailoverMonitorServiceMBean#getPartitionName()
	 */
	public String getPartitionName() {
		return partitionName;
	}


	/**
	 * @jmx.managed-attribute
	 * 
	 * @see com.clustercontrol.failover.monitor.jmx.FailoverMonitorServiceMBean#setPartitionName(java.lang.String)
	 */
	public void setPartitionName(String name) {
		partitionName = name;
	}
	
    /**
     * @jmx.managed-attribute
     * 
     * @see com.clustercontrol.failover.monitor.jmx.FailoverMonitorServiceMBean#getJndiName()
     */
    public String getJndiName() {
        return jndiName;
    }
    
    /**
     * @jmx.managed-attribute
     * 
     * @see com.clustercontrol.failover.monitor.jmx.FailoverMonitorServiceMBean#setJndiName(java.lang.String)
     * 
     * @param jndiName
     * @throws NamingException 
     */
    public void setJndiName(String jndiName) throws NamingException {
        log.info("setJndiName() : jndiName = " + jndiName);
    	
        String oldName = this.jndiName;
        this.jndiName = jndiName;
        
        if (super.getState() == STARTED) {
        	try {
        		unbind(oldName);
        	} catch (NamingException e){
        		NamingException ne = new NamingException("Failed to unbind");
        		ne.setRootCause(e);
        		log.error(ne);
        	}

        	try{
        		rebind();
        	} catch (NamingException e){
        		NamingException ne = new NamingException("Failed to rebind");
        		ne.setRootCause(e);
        		log.error(ne);
        	}
        }
    }
	
    /**
     * @jmx.managed-attribute
     * 
     * @see org.jboss.system.ServiceMBean#getName()
     */
    public String getName() {
        return "FailoverMonitorService(" + jndiName + ")";
    }
    
    /* (non-Javadoc)
     * @see org.jboss.system.ServiceMBeanSupport#startService()
     */
    public void startService() throws NamingException {
        log.info("Start FailoverMonitorService(" + jndiName + ")");
    	
        InitialContext ctx = new InitialContext();
        String partitionJndiName = "/HAPartition/" + partitionName;
        partition = (HAPartition) ctx.lookup(partitionJndiName);
        // Register as a listener of cluster membership changes
        partition.registerMembershipListener(this);
        log.info("Registered as MembershipListener");
        try
        {
           hostname = InetAddress.getLocalHost().getHostName();
        }
        catch(IOException e)
        {
           log.warn("Failed to lookup local hostname", e);
           hostname = "<unknown>";
        }
        
        //Хꥹȼ
        getAllMembers();
        
    	rebind();
    	
        log.info("Started FailoverMonitorService(" + jndiName + ")");
    }
    
    /* (non-Javadoc)
     * @see org.jboss.system.ServiceMBeanSupport#stopService()
     */
    public void stopService() throws NamingException {
        log.info("Stop FailoverMonitorService(" + jndiName + ")");
        
        partition.unregisterMembershipListener(this);

    	unbind(jndiName);

        log.info("Stoped FailoverMonitorService(" + jndiName + ")");
    }

    private static Context createContext(Context rootCtx, Name name) throws NamingException {
    	Context subctx = rootCtx;
    	
    	for (int n = 0; n < name.size(); n++) {
    		String atom = name.get(n);
    		
    		try {
    			Object obj = subctx.lookup(atom);
    			subctx = (Context) obj;
    		} catch (NamingException e) {
    			// ¸ߤʤϡ֥ƥȤ
    			subctx = subctx.createSubcontext(atom);
    		}
    	}
    	
    	return subctx;
    }
    
    private void rebind() throws NamingException {
    	InitialContext rootCtx = new InitialContext();
    	
    	Name fullName = rootCtx.getNameParser("").parse(jndiName);
    	Name parentName = fullName;
    	if(fullName.size() > 1){
    		parentName = fullName.getPrefix(fullName.size()-1);
    	} else {
    		parentName = new CompositeName();
    	}
    	
    	Context parentCtx = createContext(rootCtx, parentName);
    	Name atomName = fullName.getSuffix(fullName.size()-1);
    	String atomStirng = atomName.get(0);
    	
    	NonSerializableFactory.rebind(parentCtx, atomStirng, this);
    }
    
    private void unbind(String jndiName) throws NamingException {
    	InitialContext rootCtx = null;
    	
    	try {
    		rootCtx = new InitialContext();
    		
    		Name fullName = rootCtx.getNameParser("").parse(jndiName);
    		Name atomName = fullName.getSuffix(fullName.size() - 1);
    		String atom = atomName.get(0);
    		
    		rootCtx.unbind(jndiName);
    		NonSerializableFactory.unbind(atom);
    	} finally {
    		if(rootCtx != null) { 
    			rootCtx.close(); 
    		}
    	}
    }

	/* (non-Javadoc)
	 * @see org.jboss.ha.framework.interfaces.HAPartition$HAMembershipListener#membershipChanged(java.util.Vector, java.util.Vector, java.util.Vector)
	 */
	public void membershipChanged(Vector deadMembers, Vector newMembers, Vector allMembers) {
    	//ե륪Сƻ
		FailoverMonitor monitor = new FailoverMonitor();
		
		if(monitor.getAllMembers().size() == 0){
			monitor.setAllMembers(members);
		}
		
		monitor.monitor(deadMembers, newMembers, allMembers);
	}
	
	/**
	 * Хꥹȼ
	 * 
	 */
	private void getAllMembers() {
		log.debug("getAllMembers() start :");
		
		try{
			//ХꥹȤ򥯥ꥢ
			members.clear();
			
	        InitialContext ic = new InitialContext();
	        
	        //RMIAdaptor
	        RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);

	        //ObjectName
	        ObjectName name = new ObjectName(OBJECT_NAME);
	        
	        //ObjectNameOperationNameΥ᥽åɤ¹
	        Object returnObject = server.invoke(name, OPERATION_NAME, null, null);
	        
	        //̤JBossΥѡƥؤλäå
	        if(returnObject instanceof Vector){
	        	Vector returnVector = (Vector)returnObject;
	        	
	        	for(int i = 0; i < returnVector.size(); i++){
	        		//host:port
	        		String work = (String)returnVector.get(i);
	        		String node[] = work.split(":");

	        		members.add(node[0]);
	        	}
	        }
		} catch (NamingException e) {
			log.error("getAllMembers() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			log.error("getAllMembers() : " + e.getMessage());
		} catch (NullPointerException e) {
			log.error("getAllMembers() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			log.error("getAllMembers() : " + e.getMessage());
		} catch (MBeanException e) {
			log.error("getAllMembers() : " + e.getMessage());
		} catch (ReflectionException e) {
			log.error("getAllMembers() : " + e.getMessage());
		} catch (IOException e) {
			log.error("getAllMembers() : " + e.getMessage());
		}
        
		log.debug("getAllMembers() end :");
	}
}
