/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.failover.monitor.jmx;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;

import javax.ejb.CreateException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.naming.InitialContext;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.jmx.adaptor.rmi.RMIAdaptor;

import com.clustercontrol.troubledetection.bean.TroubleDetectionInfo;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerLocal;
import com.clustercontrol.troubledetection.ejb.session.TroubleDetectionControllerUtil;

/**
 * ե륪Сƻ륯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class FailoverMonitor {
	private static Log log = LogFactory.getLog(FailoverMonitor.class);
	
	private static final String LOOKUP_NAME = "jmx/invoker/RMIAdaptor";
	private static final String OBJECT_NAME = "user:name=TroubleDetection,service=TroubleDetectionService";
	private static final String OPERATION_NAME = "putMessage";
	
	private static ArrayList<String> members = new ArrayList<String>();
	
	protected TroubleDetectionInfo troubleDetectionInfo = null;
	
	/**
	 * 󥹥ȥ饯
	 */
	public FailoverMonitor() {
		//㳲ξ
		troubleDetectionInfo = getTroubleDetectionInfo();
	}
	
	/**
	 * ƻ
	 * 
	 * @param deadMembers
	 * @param newMembers
	 * @param allMembers
	 */
	public void monitor(Vector deadMembers, Vector newMembers, Vector allMembers) {
		log.info("DeadMembers: size="+deadMembers.size());
		for(int m = 0; m < deadMembers.size(); m ++)
		{
			String addr = getMemberAddress(deadMembers.get(m));
			log.info(addr);
		}
		log.info("NewMembers: size="+newMembers.size());
		for(int m = 0; m < newMembers.size(); m ++)
		{
			String addr = getMemberAddress(newMembers.get(m));
			log.info(addr);
		}
		log.info("AllMembers: size="+allMembers.size());
		for(int m = 0; m < allMembers.size(); m ++)
		{
			String addr = getMemberAddress(allMembers.get(m));
			log.info(addr);
		}
		
		//줿ޥ͡
		boolean removeServer1 = false;
		boolean removeServer2 = false;
		for(int i = 0; i < deadMembers.size(); i ++){
			String addr = getMemberAddress(deadMembers.get(i));
			log.info("deadMember = " + addr);
			if(addr.equals(troubleDetectionInfo.getJbossServer1())){
				removeServer1 = true;
				log.info("removeServer1 = " + removeServer1);
			}
			else if(addr.equals(troubleDetectionInfo.getJbossServer2())){
				removeServer2 = true;
				log.info("removeServer2 = " + removeServer2);
			}
		}
		
		//1ˡ
		//ƬФ1ǡ
		//ƬФ2ξ硢
		//ե륪СΤԤ
		if(removeServer1){
			if(members.size() > 0 && allMembers.size() > 0){
				String oldTopAddr = members.get(0);
				String newTopAddr = getMemberAddress(allMembers.get(0));
				log.info("oldTopAddr = " + oldTopAddr);
				log.info("newTopAddr = " + newTopAddr);
				if(oldTopAddr.equals(troubleDetectionInfo.getJbossServer1()) 
						&& newTopAddr.equals(troubleDetectionInfo.getJbossServer2())){
					outputLog("JBOSS02", "001");
				}
			}
		}
		
		//2ˡ
		//ƬФ2ǡ
		//ƬФ1ξ硢
		//եХåΤԤ
		if(removeServer2){
			if(members.size() > 0 && allMembers.size() > 0){
				String oldTopAddr = members.get(0);
				String newTopAddr = getMemberAddress(allMembers.get(0));
				log.info("oldTopAddr = " + oldTopAddr);
				log.info("newTopAddr = " + newTopAddr);
				if(oldTopAddr.equals(troubleDetectionInfo.getJbossServer2()) 
						&& newTopAddr.equals(troubleDetectionInfo.getJbossServer1())){
					outputLog("JBOSS03", "001");
				}
			}
		}
		
		//Сꥹȹ
		members.clear();
		for(int i = 0; i < allMembers.size(); i++){
			String addr = getMemberAddress(allMembers.get(i));
			members.add(addr);
		}
	}
	
	/**
	 * 
	 * 
	 * @version 2.1.0
	 * @since 2.1.0
	 * 
	 * @param messageId
	 */
	private void outputLog(String monitorId, String messageId) {
		
		try{
			InitialContext ic = new InitialContext();
			
			//RMIAdaptor
			RMIAdaptor server = (RMIAdaptor) ic.lookup(LOOKUP_NAME);
			
			//ObjectName
			ObjectName name = new ObjectName(OBJECT_NAME);
			
			//ObjectNameOperationNameΥ᥽åɤ¹
			Object[] args = {monitorId, messageId};
			String[] signature = {String.class.getName(), String.class.getName()};
			server.invoke(name, OPERATION_NAME, args, signature);
			
		} catch (NamingException e) {
			log.debug("outputLog() : " + e.getMessage());
		} catch (MalformedObjectNameException e) {
			log.debug("outputLog() : " + e.getMessage());
		} catch (NullPointerException e) {
			log.debug("outputLog() : " + e.getMessage());
		} catch (InstanceNotFoundException e) {
			log.debug("outputLog() : " + e.getMessage());
		} catch (MBeanException e) {
			log.debug("outputLog() : " + e.getMessage());
		} catch (ReflectionException e) {
			log.debug("outputLog() : " + e.getMessage());
		} catch (IOException e) {
			log.debug("outputLog() : " + e.getMessage());
		}
	}

	/**
	 * Хꥹ
	 * 
	 */
	public void setAllMembers(ArrayList<String> members) {
		FailoverMonitor.members = members;
	}
	
	/**
	 * Хꥹȼ
	 * 
	 */
	public ArrayList<String> getAllMembers() {
		return FailoverMonitor.members;
	}
	
	/**
	 * 㳲ξ
	 * 
	 * @return
	 */
	public TroubleDetectionInfo getTroubleDetectionInfo() {
		TroubleDetectionInfo info = null;
		
		try {
			TroubleDetectionControllerLocal controller = 
				TroubleDetectionControllerUtil.getLocalHome().create();
			
			info = controller.getInfo();
		} catch (CreateException e) {
		} catch (NamingException e) {
		}
		
		return info;
	}
	
	/**
	 * IPɥ쥹
	 * 
	 * @param addr
	 * @return
	 */
	private String getMemberAddress(Object addr)
	{
		String address = null;
		try
		{
			org.jboss.ha.framework.interfaces.ClusterNode node =
				(org.jboss.ha.framework.interfaces.ClusterNode)addr;
			
			address = node.getIpAddress().getHostAddress();
		}
		catch(Exception e)
		{
			log.warn("Failed to obtain address/port from addr: "+addr, e);
		}
		return address;
	}
}
