/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.view;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;

import com.clustercontrol.collectiverun.composite.ParameterViewComposite;
import com.clustercontrol.collectiverun.view.action.CollectiveRunAction;
import com.clustercontrol.view.CommonViewPart;

/**
 * [ѥ᡼]ӥ塼饹
 * 
 * @version 1.0.0
 * @since 1.0.0
 *  
 */

public class ParameterView extends CommonViewPart {
    public static final String ID = "com.clustercontrol.collectiverun.view.ParameterView";

    // ----- instance ե ----- //

    /** ѥ᡼ݥå */
    private ParameterViewComposite propertySheet = null;

    /**
     * 󥹥ȥ饯
     * 
     * @since 1.0.0
     */
    public ParameterView() {
        super();
    }

    /**
     * ViewPartؤΥȥ
     * 
     * @since 1.0.0
     * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
     */
    public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        propertySheet = new ParameterViewComposite(parent, SWT.NONE);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        propertySheet.setLayoutData(gridData);
        
        //ݥåץåץ˥塼
        createContextMenu();
    }
    
    /**
     * ݥåץåץ˥塼
     * 
     *  
     */
    protected void createContextMenu() {
        MenuManager menuManager = new MenuManager();
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.jface.action.IMenuListener#menuAboutToShow(org.eclipse.jface.action.IMenuManager)
             */
            public void menuAboutToShow(IMenuManager manager) {
                //˥塼
                fillContextMenu(manager);
            }
        });
        
        Menu menu = menuManager.createContextMenu(propertySheet.getTableTree());
        propertySheet.getTableTree().setMenu(menu);
    }

    /**
     * ˥塼ɲ
     * 
     * @param manager
     */
    protected void fillContextMenu(IMenuManager manager) {
        //ӥ塼ΥΥ󥹥󥹤
        IToolBarManager toolbar = this.getViewSite().getActionBars()
                .getToolBarManager();
        ActionContributionItem collectiveRunAction = (ActionContributionItem) toolbar
                .find(CollectiveRunAction.ID);

        //ݥåץåץ˥塼˥ɲ
        manager.add(collectiveRunAction.getAction());
    }

    /**
     * ѥ᡼ݥåȼ
     * 
     * @return ParameterComposite
     *  
     */
    public ParameterViewComposite getComposite() {
        return this.propertySheet;
    }

    /**
     * 
     *  
     */
    public void update() {
        propertySheet.update();
    }

    /**
     * ץȤ׵ᤵ줿硢ȤΥ󥹥󥹤Ϥޤ
     * 
     * @param cls
     *            饹Υ󥹥
     * @return ȤΥ󥹥
     */
    public Object getAdapter(Class cls) {
        if (cls.isInstance(this)) {
            return this;
        } else {
            return super.getAdapter(cls);
        }
    }
}