/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite.action;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.MessageBox;

import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.TreeComposite;
import com.clustercontrol.util.Messages;

/**
 * 泬إĥ꡼SelectionListener쥯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class BaseTreeItemSelectionListener implements SelectionListener {
    protected TreeComposite composite;

    /**
     * 󥹥ȥ饯
     * 
     * @param composite
     */
    public BaseTreeItemSelectionListener(TreeComposite composite) {
        this.composite = composite;
    }

    /* (non-Javadoc)
     * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
     */
    public void widgetSelected(SelectionEvent event) {

    }
    
    /**
     * 楢ƥå
     * @return
     */
    protected boolean checkCreateItem() {
    	
    	//Υƥब¸ߤ뤫å
    	if(this.composite.getCreateItem() != null){
    		//楢ƥब¸ߤ
    		
    		TreeItem createItem = this.composite.getCreateItem();
			TreeItem parent = createItem.getParent();
    		
    		//ǧ
    		MessageBox box = new MessageBox(this.composite.getShell(),
    				SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
    		box.setText(Messages.getString("confirmed"));
            Object[] args = { createItem.getInfo().getName() };
            box.setMessage(Messages.getString("message.collective.run.8", args));
    		if (box.open() == SWT.OK) {
    			parent.removeChildren(createItem);
    			this.composite.setCreateItem(null);
    			this.composite.setUpdateItem(null);
    			
    			this.composite.getTreeViewer().refresh(parent);
    		}
    		return false;
    	}
    	return true;
    }
    
    /**
     * 楢ƥå
     * @return
     */
    protected boolean checkUpdateItem() {
    	
        //򥢥ƥ
    	TreeItem selectItem = this.composite.getSelectItem();
    	
    	//Υƥब¸ߤ뤫å
    	if(this.composite.getUpdateItem() != null){
    		//楢ƥब¸ߤ
    		
    		TreeItem updateItem = this.composite.getUpdateItem();
    		
    		//ǧ
    		MessageBox box = new MessageBox(this.composite.getShell(),
    				SWT.OK | SWT.CANCEL | SWT.ICON_QUESTION);
    		box.setText(Messages.getString("confirmed"));
    		Object[] args = { updateItem.getInfo().getName() };
            box.setMessage(Messages.getString("message.collective.run.9", args));
    		if (box.open() == SWT.OK) {
    			this.composite.setUpdateItem(null);
    			
    			this.composite.getTreeViewer().setSelection(
    					new StructuredSelection(selectItem), true);
    		}
    		return false;
    	}
    	return true;
    }

	/* (non-Javadoc)
	 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	 */
	public void widgetDefaultSelected(SelectionEvent e) {

	}
}

