/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import java.rmi.AccessException;
import java.util.ArrayList;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.Property;
import com.clustercontrol.collectiverun.action.GetHistoryInfo;
import com.clustercontrol.collectiverun.action.GetHistoryTabelDefine;
import com.clustercontrol.collectiverun.bean.HistoryTableDefine;
import com.clustercontrol.collectiverun.composite.action.HistorySelectionChangedListener;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;

/**
 * []ݥå
 * 
 * 
 * @version 1.0.0
 * @since 1.0.0
 *  
 */
public class HistoryComposite extends Composite {
    /** ơ֥ӥ塼 */
    private CommonTableViewer m_viewer = null;

    /** åID */
    protected String m_sessionId = null;
    
    private boolean openAccessInformation = false;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     */
    public HistoryComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     *  
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetHistoryTabelDefine.get(),
                HistoryTableDefine.SORT_COLUMN_INDEX,
                HistoryTableDefine.SORT_ORDER);

        this.update();

        m_viewer
                .addSelectionChangedListener(new HistorySelectionChangedListener(
                        this));
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    public void update() {
        ArrayList historyInfo = null;

        //
        GetHistoryInfo history = new GetHistoryInfo();
        try {
            historyInfo = history.getHistory();
        } catch (AccessException e) {
        	if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
        } catch (IndexOutOfBoundsException e) {
            historyInfo = new ArrayList();
            // ɽĶ硢顼ɽ
            MessageDialog.openInformation(null, Messages.getString("message"),
                    Messages.getString("message.job.33"));
		}
        
        if(historyInfo == null){
        	historyInfo = new ArrayList();
        }

        m_viewer.setInput(historyInfo);

        selectHistory(historyInfo);
    }

    /**
     * 
     * 
     * @param condition
     *            ե륿
     * @since 1.0.0
     */
    public void update(Property condition) {
        ArrayList historyInfo = null;

        //
        GetHistoryInfo history = new GetHistoryInfo();
        try {
            historyInfo = history.getHistory(condition);
        } catch (AccessException e) {
        	if(!openAccessInformation){
        		openAccessInformation = true;
        		// ʤξ硢顼ɽ
        		MessageDialog.openInformation(null, Messages.getString("message"),
	                    Messages.getString("message.accesscontrol.16"));
        	}
        } catch (IndexOutOfBoundsException e) {
            historyInfo = new ArrayList();
            // ɽĶ硢顼ɽ
            MessageDialog.openInformation(null, Messages.getString("message"),
                    Messages.getString("message.job.33"));
		}

        m_viewer.setInput(historyInfo);

        selectHistory(historyInfo);
    }

    /**
     * 
     * 
     * @param historyInfo
     *            
     * @since 1.0.0
     */
    public void selectHistory(ArrayList historyInfo) {
        if (m_sessionId != null && m_sessionId.length() > 0) {
            int index = -1;
            for (int i = 0; i < historyInfo.size(); i++) {
                ArrayList line = (ArrayList) historyInfo.get(i);
                String sessionId = (String) line
                        .get(HistoryTableDefine.SESSION_ID);
                if (m_sessionId.compareTo(sessionId) == 0) {
                    index = i;
                    break;
                }
            }
            if (index == -1) {
                m_sessionId = null;
            } else {
                m_viewer.setSelection(new StructuredSelection(historyInfo
                        .get(index)), true);
            }
        }
    }

    /**
     * ơ֥ӥ塼
     * 
     * @return m_viewer
     */
    public CommonTableViewer getTableViewer() {
        return this.m_viewer;
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return m_sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        m_sessionId = sessionId;
    }
}