/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.collectiverun.action.GetDetailInfo;
import com.clustercontrol.collectiverun.action.GetDetailTabelDefine;
import com.clustercontrol.collectiverun.bean.DetailTableDefine;
import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.util.Messages;

/**
 * [ܺ]ݥå
 * 
 * 
 * @version 1.0.0
 * @since 1.0.0
 *  
 */
public class DetailComposite extends Composite {
    /** ơ֥ӥ塼 */
    protected CommonTableViewer m_viewer = null;

    /** åID */
    protected String m_sessionId = null;

    protected Label m_sessionIdLabel = null;

    /**
     * 󥹥ȥ饯
     * 
     * @param parent
     * @param style
     */
    public DetailComposite(Composite parent, int style) {
        super(parent, style);
        initialize();
    }

    /**
     * 
     *  
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        //åID٥
        m_sessionIdLabel = new Label(this, SWT.LEFT);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        m_sessionIdLabel.setLayoutData(gridData);

        Table table = new Table(this, SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION | SWT.SINGLE);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        table.setLayoutData(gridData);

        m_viewer = new CommonTableViewer(table);
        m_viewer.createTableColumn(GetDetailTabelDefine.get(),
                DetailTableDefine.SORT_COLUMN_INDEX,
                DetailTableDefine.SORT_ORDER);

        this.update(null);
    }

    /**
     * 
     * 
     * @since 1.0.0
     */
    public void update(String sessionId) {
        ArrayList detailInfo = null;

        //־ܺپ
        GetDetailInfo detail = new GetDetailInfo();
        if (sessionId != null && sessionId.length() > 0) {
            detailInfo = detail.getDetailInfo(sessionId);
        }
        m_viewer.setInput(detailInfo);

        m_sessionId = sessionId;

        //åIDɽ
        if (m_sessionId != null) {
            m_sessionIdLabel.setText(Messages.getString("session.id") + " : "
                    + m_sessionId);
        } else {
            m_sessionIdLabel.setText(Messages.getString("session.id") + " : ");
        }
    }

    /**
     * @return Returns the sessionId.
     */
    public String getSessionId() {
        return m_sessionId;
    }

    /**
     * @param sessionId
     *            The sessionId to set.
     */
    public void setSessionId(String sessionId) {
        m_sessionId = sessionId;
    }
}