/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.composite;

import java.util.List;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.collectiverun.action.ModifyMaster;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.TreeItem;
import com.clustercontrol.collectiverun.composite.action.MasterInfoModifyListener;
import com.clustercontrol.collectiverun.util.TreeItemUtil;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.util.Messages;

/**
 * 泬إĥ꡼ݥå
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class CommandParameterComposite extends Composite {
    private Combo id = null;

    private Text option = null;
    
    private TreeItem selectItem = null;

    private TreeComposite composite = null;

    public CommandParameterComposite(Composite parent, int style, TreeComposite composite) {
        super(parent, style);
        this.composite = composite;
        this.selectItem = composite.getSelectItem();
        initialize();
    }

    private void initialize() {
        GridLayout layout = new GridLayout(10, true);
        this.setLayout(layout);
        layout.marginHeight = 5;
        layout.marginWidth = 5;

        GridData gridData = null;
        Label label = null;
        
        Group group = new Group(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 10;
        group.setLayoutData(gridData);
        group.setText(Messages.getString("parameter"));
        
        layout = new GridLayout(10, true);
        group.setLayout(layout);
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 10;
        
        // ѥ᡼ID
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("parameter.id") + " : ");
        
        this.id = new Combo(group, SWT.BORDER | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.id.setLayoutData(gridData);
        this.id.addModifyListener(new MasterInfoModifyListener(this.composite));
        List<String> list = 
        	TreeItemUtil.getParameterIdList(
        			TreeItemUtil.getTopTreeItem(selectItem));
        for(int i = 0; i < list.size(); i++){
        	this.id.add(list.get(i));
        }
        
        // ץ
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 3;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("option") + " : ");
        
        this.option = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 7;
        this.option.setLayoutData(gridData);
        this.option.addModifyListener(new MasterInfoModifyListener(this.composite));
        
        // Ŭѥܥ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        label.setLayoutData(gridData);
        
        Button buttonCreate = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonCreate.setLayoutData(gridData);
        buttonCreate.setText(Messages.getString("apply"));
        buttonCreate.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                ValidateResult result = validate();

                if (result != null) {
                    displayError(result);
                }
            }
        });
        
        setEnabled();
        
        update();
    }
    
    /**
     * ȥλѲ/ԲĤ
     * 
     */
    public void setEnabled() {
        if(this.composite.getCreateItem() == null){
        	this.id.setEnabled(false);
        }
        else{
        	this.id.setEnabled(true);
        }
    }

    /**
     * 
     * 
     */
    public void update() {
    	if(selectItem instanceof TreeItem){
    		if(selectItem.getInfo() instanceof CommandParameterInfo){
    			CommandParameterInfo info = (CommandParameterInfo)selectItem.getInfo();
    			
    			//ѥ᡼ID
    			if(info.getId() != null){
    				this.id.setText(info.getId());
    			}
    			
    			//̾
    			if(info.getPrefix() != null){
    				this.option.setText(info.getPrefix());
    			}
    		}
    	}
    	this.composite.setUpdateItem(null);
    }
    
	/**
	 * ޥɥѥ᡼
	 * 
	 * @return
	 */
	public ValidateResult createCommandParameterInfo() {
		ValidateResult result = null;
		
    	if(selectItem instanceof TreeItem){
    		if(selectItem.getInfo() instanceof CommandParameterInfo){
    			CommandParameterInfo info = (CommandParameterInfo)selectItem.getInfo();
    			CommandParameterInfo cloneInfo = (CommandParameterInfo)info.clone();
    			
    			ItemInfo parentInfo = selectItem.getParent().getInfo();
    			
		        //ѥ᡼ID
		        if (this.id.getText().length() > 0) {
		        	cloneInfo.setId(this.id.getText());
		        } else {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            result.setMessage(Messages.getString("message.collective.run.6"));		            return result;
		        }
		        
		        //ѥ᡼IDʣå
		        if (this.id.isEnabled() && 
		        		TreeItemUtil.findId(cloneInfo.getId(), selectItem.getParent())) {
		            result = new ValidateResult();
		            result.setValid(false);
		            result.setID(Messages.getString("message.hinemos.1"));
		            String args[] = { Messages.getString("parameter.id"), cloneInfo.getId() };
		            result.setMessage(Messages.getString("message.collective.run.16", args));
		            return result;
		        }
		        
		        //̾
		        cloneInfo.setName(TreeItemUtil.getParameterName(
		        		cloneInfo.getId(),
		        		TreeItemUtil.getTopTreeItem(selectItem)));
		        
		        //ץ
		        if (this.option.getText().length() > 0) {
		        	cloneInfo.setPrefix(this.option.getText());
		        }
		        else{
		        	cloneInfo.setPrefix("");
		        }
		        
		        ModifyMaster modify = new ModifyMaster();
                if(modify.update(cloneInfo, parentInfo)){
                	
                	selectItem.setInfo(cloneInfo);
                	
                	this.composite.setCreateItem(null);
                	this.composite.setUpdateItem(null);
                	this.composite.getTreeViewer().refresh(selectItem);
                }
                else{
                	//顼顼ɽ
                	Object[] args = { cloneInfo.getName() };
    				MessageDialog.openError(null, 
    						Messages.getString("message"), 
    						Messages.getString("message.collective.run.13", args));
                }
    		}
    	}
		
		return null;
	}
	
    /**
     * ͥåԤޤ
     * 
     * ɬפ˱ơͥåƲ
     * 
     * @return ValidateResult֥
     */
    protected ValidateResult validate() {
        ValidateResult result = null;

        result = createCommandParameterInfo();
        if (result != null) {
            return result;
        }
        
        return null;
    }
	
    /**
     * 顼ƤΤޤ
     * <p>
     * 
     * ٹåܥåˤơ饤ȤΤޤ
     * 
     * @param result
     *            ValidateResult֥
     */
    protected void displayError(ValidateResult result) {
        MessageBox messageBox = new MessageBox(this.getShell(), SWT.OK
                | SWT.ICON_WARNING);

        messageBox.setText(result.getID());
        messageBox.setMessage(result.getMessage());

        messageBox.open();
    }
    
	/**
	 * @return
	 */
	public TreeItem getSelectItem() {
		return selectItem;
	}

	/**
	 * @param selectItem
	 */
	public void setSelectItem(TreeItem selectItem) {
		this.selectItem = selectItem;
	}
}