/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.ArrayList;

import javax.ejb.CreateException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.EndStatusInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;

/**
 * ޥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class ModifyMaster {
    protected static Log m_log = LogFactory.getLog( ModifyMaster.class );

	/**
	 * ޥ󹹿
	 * 
	 * @param info
	 * @param parentInfo
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException 
	 */
	public void update(ItemInfo info, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException {
		
		if(info == null || parentInfo == null){
			return;
		}
		
		if(info.getType() == ItemConstant.TYPE_TYPE){
			updateType((TypeInfo)info);
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			updateCommand((CommandInfo)info, 
					((TypeInfo)parentInfo).getId());
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			updateCommandParameter((CommandParameterInfo)info, 
					((CommandInfo)parentInfo).getId());
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			updateParameter((ParameterInfo)info);
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			updateParameterSelect((ParameterSelectInfo)info);
		}
	}
	
	/**
	 * ̾󹹿
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateType(TypeInfo info) throws NamingException, CreateException {
		boolean create = false;
		CRunTypeMstLocal type = null;
		
		try {
			//IDǼ̤򸡺
			type = CRunTypeMstUtil.getLocalHome().findByPrimaryKey(info.getId());
		} catch (FinderException e) {
			//Ĥʤ硢ե饰trueˤ
			create = true;
		}
		
		if(create){
			//CRunTypeMstLocal
			CRunTypeMstUtil.getLocalHome().create(
					info.getId(), 
					info.getName(), 
					new Integer(info.getOrderNo()));
		}
		else{
			//CRunTypeMstLocal򹹿
			type.setName_id(info.getName());
			type.setOrder_no(new Integer(info.getOrderNo()));
			type = null;
		}
	}
	
	/**
	 * ޥɾ󹹿
	 * 
	 * @param info
	 * @param typeId
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateCommand(CommandInfo info, String typeId) throws NamingException, CreateException {
		boolean create = false;
		CRunCmdMstLocal command = null;
		
		try {
			//IDǥޥɤ򸡺
			command = CRunCmdMstUtil.getLocalHome().findByPrimaryKey(info.getId());
		} catch (FinderException e) {
			//Ĥʤ硢ե饰trueˤ
			create = true;
		}
		
		//ޥɺ
		if(create){
			//CRunCmdMstLocal
			CRunCmdMstUtil.getLocalHome().create(
					info.getId(), 
					typeId, 
					new Integer(info.getOrderNo()), 
					info.getName(), 
					new Integer(info.getCommandType()), 
					info.getCommand());
		}
		else{
			//CRunCmdMstLocal򹹿
			command.setName_id(info.getName());
			command.setOrder_no(new Integer(info.getOrderNo()));
			command.setCommand(info.getCommand());
			command.setCommand_type(new Integer(info.getCommandType()));
			command = null;
		}
		
		//λֺ
		if(info.getEndStatus() != null && 
				info.getEndStatus() instanceof ArrayList){
			//CRunEndMstLocal
			for(int i = 0; i < info.getEndStatus().size(); i++){
				EndStatusInfo endStatus = info.getEndStatus().get(i);
				if(endStatus instanceof EndStatusInfo){
					
					boolean endCreate = false;
					CRunEndMstLocal end = null;
					
					try {
						//IDǽλ֤򸡺
						end = CRunEndMstUtil.getLocalHome().findByPrimaryKey(
								new CRunEndMstPK(
										info.getId(), 
										new Integer(endStatus.getEndStatus())));
					} catch (FinderException e) {
						//Ĥʤ硢ե饰trueˤ
						endCreate = true;
					}
				
					//λֺ
					if(endCreate){
						//CRunEndMstLocal
						CRunEndMstUtil.getLocalHome().create(
								info.getId(), 
								new Integer(endStatus.getEndStatus()), 
								new Integer(endStatus.getStartRangeValue()),
								new Integer(endStatus.getEndRangeValue()));
					}
					else{
						//CRunEndMstLocal򹹿
						end.setEnd_value_from(new Integer(endStatus.getStartRangeValue()));
						end.setEnd_value_to(new Integer(endStatus.getEndRangeValue()));
						end = null;
					}
				}
			}
		}
	}
	
	/**
	 * ޥɥѥ᡼󹹿
	 * 
	 * @param info
	 * @param commandId
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateCommandParameter(CommandParameterInfo info, String commandId) throws NamingException, CreateException {
		boolean create = false;
		CRunCmdParamMstLocal commandParameter = null;
		
		try {
			//IDǥޥɥѥ᡼򸡺
			commandParameter = CRunCmdParamMstUtil.getLocalHome().findByPrimaryKey(
					new CRunCmdParamMstPK(commandId, info.getId()));
		} catch (FinderException e) {
			//Ĥʤ硢ե饰trueˤ
			create = true;
		}
		
		//ޥɥѥ᡼
		if(create){
			//CRunCmdParamMstLocal
			CRunCmdParamMstUtil.getLocalHome().create(
					commandId, 
					info.getId(), 
					new Integer(info.getOrderNo()), 
					info.getPrefix());
		}
		else{
			//CRunCmdParamMstLocal򹹿
			commandParameter.setParam_prefix(info.getPrefix());
			commandParameter.setOrder_no(new Integer(info.getOrderNo()));
			commandParameter = null;
		}
	}
	
	/**
	 * ѥ᡼󹹿
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws CreateException
	 */
	public void updateParameter(ParameterInfo info) throws NamingException, CreateException {
		boolean create = false;
		CRunParamMstLocal parameter = null;
		
		try {
			//IDǥѥ᡼򸡺
			parameter = CRunParamMstUtil.getLocalHome().findByPrimaryKey(info.getId());
		} catch (FinderException e) {
			//Ĥʤ硢ե饰trueˤ
			create = true;
		}
		
		//ѥ᡼
		if(create){
			//CRunParamMstLocal
			CRunParamMstUtil.getLocalHome().create(
					info.getId(), 
					info.getName(), 
					new Integer(info.getParamType()));
		}
		else{
			//CRunParamMstLocal򹹿
			parameter.setName_id(info.getName());
			parameter.setParam_type(new Integer(info.getParamType()));
			parameter = null;
		}
	}
	
	
	/**
	 * ѥ᡼󹹿
	 * 
	 * @param info
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException
	 */
	public void updateParameterSelect(ParameterSelectInfo info) throws NamingException, CreateException, RemoveException {
		boolean create = false;
		CRunParamSelectMstLocal select = null;
		
		try {
			//IDǥѥ᡼򸡺
			select = CRunParamSelectMstUtil.getLocalHome().findByPrimaryKey(
					new CRunParamSelectMstPK(info.getId(), new Integer(info.getOrderNo())));
		} catch (FinderException e) {
			//Ĥʤ硢ե饰trueˤ
			create = true;
		}
		
		//ѥ᡼
		if(create){
			//CRunParamSelectMstLocal
			CRunParamSelectMstUtil.getLocalHome().create(
					info.getId(), 
					new Integer(info.getOrderNo()), 
					info.getName(), 
					info.getValue());
		}
		else{
			//CRunParamSelectMstLocal򹹿
			select.setName_id(info.getName());
			select.setParam_value(info.getValue());
			select = null;
		}
	}
	
	/**
	 * ޥɽ
	 * 
	 * @param info1
	 * @param info2
	 * @param parentInfo
	 * @throws NamingException
	 * @throws CreateException
	 * @throws RemoveException
	 * @throws FinderException
	 */
	public void changeOrder(ItemInfo info1, ItemInfo info2, ItemInfo parentInfo) throws NamingException, CreateException, RemoveException, FinderException {
    	int orderNo1 = info1.getOrderNo();
    	int orderNo2 = info2.getOrderNo();
    	
    	if(info1.getType() == ItemConstant.TYPE_SELECT_ITEM){
    		//ѥ᡼
    		
    		DeleteMaster delete = new DeleteMaster();
    		
            //򤷤ƥ
        	delete.delete(info1, parentInfo);
            	
        	//ưåȥƥ
        	delete.delete(info2, parentInfo);
            
            //򤷤ƥưåȥƥνǺ
            info1.setOrderNo(orderNo2);
            update(info1, parentInfo);
            
        	//ưåȥƥ򥢥ƥνǺ
            info2.setOrderNo(orderNo1);
            update(info2, parentInfo);
    	}
    	else{
    		//ѥ᡼ʳ

            //򤷤ƥưåȥƥνǹ
            info1.setOrderNo(orderNo2);
            update(info1, parentInfo);
            	
        	//ưåȥƥ򥢥ƥνǹ
            info2.setOrderNo(orderNo1);
            update(info2, parentInfo);
    	}
	}
}
