/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.factory;

import java.util.Collection;

import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.RemoveException;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.bean.CommandInfo;
import com.clustercontrol.collectiverun.bean.CommandParameterInfo;
import com.clustercontrol.collectiverun.bean.ItemConstant;
import com.clustercontrol.collectiverun.bean.ItemInfo;
import com.clustercontrol.collectiverun.bean.ParameterInfo;
import com.clustercontrol.collectiverun.bean.ParameterSelectInfo;
import com.clustercontrol.collectiverun.bean.TypeInfo;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunCmdParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunEndMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstPK;
import com.clustercontrol.collectiverun.ejb.entity.CRunParamSelectMstUtil;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstLocal;
import com.clustercontrol.collectiverun.ejb.entity.CRunTypeMstUtil;

/**
 * ޥ饹
 *
 * @version 2.1.0
 * @since 2.1.0
 */
public class DeleteMaster {
    protected static Log m_log = LogFactory.getLog( DeleteMaster.class );

	/**
	 * ޥ
	 * 
	 * @param info
	 * @throws FinderException
	 * @throws NamingException
	 * @throws EJBException
	 * @throws RemoveException
	 */
	public void delete(ItemInfo info, ItemInfo parentInfo) throws FinderException, NamingException, EJBException, RemoveException  {
		
		if(info == null || parentInfo == null){
			return;
		}
		
		if(info.getType() == ItemConstant.TYPE_TYPE){
			//IDǼ̤򸡺
			CRunTypeMstLocal type = 
				CRunTypeMstUtil.getLocalHome().findByPrimaryKey(
					((TypeInfo)info).getId());
			
			//ޥɺ
			deleteCommand(type);
			
			//̺
			type.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND){
			//IDǥޥɤ򸡺
			CRunCmdMstLocal cmd = 
				CRunCmdMstUtil.getLocalHome().findByPrimaryKey(
					((CommandInfo)info).getId());
			
			//ޥɥѥ᡼
			deleteCommandParameter(cmd);
			
			//λֺ
			deleteEndStatus(cmd);
			
			//ޥɺ
			cmd.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_COMMAND_PARAMETER){
			//IDǥޥɥѥ᡼򸡺
			CRunCmdParamMstLocal param = 
				CRunCmdParamMstUtil.getLocalHome().findByPrimaryKey(
						new CRunCmdParamMstPK(
								((CommandInfo)parentInfo).getId(), 
								((CommandParameterInfo)info).getId()));
			
			//ޥɥѥ᡼
			param.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_PARAMETER){
			//IDǥѥ᡼򸡺
			CRunParamMstLocal param = 
				CRunParamMstUtil.getLocalHome().findByPrimaryKey(
						((ParameterInfo)info).getId());
			
			//ѥ᡼
			deleteParameterSelect(param);
			
			//ѥ᡼
			param.remove();
		}
		else if(info.getType() == ItemConstant.TYPE_SELECT_ITEM){
			//IDǥѥ᡼򸡺
			CRunParamSelectMstLocal select = 
				CRunParamSelectMstUtil.getLocalHome().findByPrimaryKey(
						new CRunParamSelectMstPK(
								((ParameterSelectInfo)info).getId(), 
								new Integer(((ParameterSelectInfo)info).getOrderNo())));
			
			//ѥ᡼
			select.remove();
		}
	}
	
	/**
	 * ޥɾ
	 * 
	 * @param type
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteCommand(CRunTypeMstLocal type) throws EJBException, RemoveException  {
		//̤ɳŤޥɥޥ
	    Collection collection = type.getCmdMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){    
			    //ޥɥޥ
				CRunCmdMstLocal cmd = (CRunCmdMstLocal)objectArray[i];
				
				//ޥɥѥ᡼
				deleteCommandParameter(cmd);
				
				//ޥɺ
				cmd.remove();
			}
	    }
	}
	
	/**
	 * λ־
	 * 
	 * @param cmd
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteEndStatus(CRunCmdMstLocal cmd) throws EJBException, RemoveException  {
		//ޥɤɳŤλ֥ޥ
	    Collection collection = cmd.getEndMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){
			    //λ֥ޥ
				CRunEndMstLocal end = (CRunEndMstLocal)objectArray[i];
				//λֺ
				end.remove();
			}
	    }
	}
	
	/**
	 * ޥɥѥ᡼
	 * 
	 * @param cmd
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteCommandParameter(CRunCmdMstLocal cmd) throws EJBException, RemoveException  {
		//ޥɤɳŤޥɥޥ
	    Collection collection = cmd.getCmdParamMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){
			    //ޥɥѥ᡼ޥ
				CRunCmdParamMstLocal param = (CRunCmdParamMstLocal)objectArray[i];
				//ޥɥѥ᡼
				param.remove();
			}
	    }
	}
	
	/**
	 * ѥ᡼
	 * 
	 * @param param
	 * @throws EJBException
	 * @throws RemoveException
	 */
	protected void deleteParameterSelect(CRunParamMstLocal param) throws EJBException, RemoveException  {
		//ѥ᡼ɳŤѥ᡼ޥ
	    Collection collection = param.getParamSelectMst();
	    if(collection != null && collection.size() > 0){
            Object[] objectArray = collection.toArray();
            for(int i = 0; i < objectArray.length; i++){
			    //ѥ᡼ޥ
				CRunParamSelectMstLocal select = (CRunParamSelectMstLocal)objectArray[i];
				//ѥ᡼
				select.remove();
			}
	    }
	}
}
