/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.ejb.mdb;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;

import javax.jms.JMSException;
import javax.jms.ObjectMessage;
import javax.naming.NamingException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.clustercontrol.collectiverun.bean.QueueConstant;
import com.clustercontrol.collectiverun.factory.CommandExecutor;
import com.clustercontrol.collectiverun.message.CollectiveRunInstructionInfo;
import com.clustercontrol.collectiverun.util.SendQueue;
import com.clustercontrol.jobmanagement.bean.RunStatusConstant;
import com.clustercontrol.jobmanagement.message.RunResultInfo;
import com.clustercontrol.repository.bean.FacilityAttributeConstant;
import com.clustercontrol.repository.ejb.session.RepositoryControllerLocal;
import com.clustercontrol.repository.ejb.session.RepositoryControllerUtil;


/**
 *
 * <!-- begin-user-doc --> You can insert your documentation for '<em><b>CollectiveRunExecuteBean</b></em>'. <!-- end-user-doc --> *
 *
 *
 * <!-- begin-xdoclet-definition -->
 * @ejb.bean name="CollectiveRunExecuteBean" 
 *     acknowledge-mode="Auto-acknowledge"
 *     destination-type="javax.jms.Queue"
 *     transaction-type="Container"
 *     destination-jndi-name="queue/clustercontrol/CollectiveRun/execute"
 * 
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=AccessController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=RepositoryController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=JobController"
 * @jboss.depends name="jboss.j2ee:service=EJB,jndiName=QuartzManager"
 * 
 * @jboss.container-configuration 
 *     name="CollectiveRun Message Driven Bean" 
 *
 *--
 * Server Runtime Specific Tags
 * If you are not using a specific runtime, you can safely remove the tags below.
 * @jonas.message-driven-destination jndi-name="queue/clustercontrol/CollectiveRun/execute"
 * @jboss.destination-jndi-name name="queue/clustercontrol/CollectiveRun/execute"
 *
 *--
 * <!-- end-xdoclet-definition -->
 * @generated
 **/
public class CollectiveRunExecuteBean implements javax.ejb.MessageDrivenBean, javax.jms.MessageListener {
    protected static Log m_log = LogFactory.getLog( CollectiveRunExecuteBean.class );
    private static final String RSH = "rsh";
    private static final String SSH = "ssh";
    
    /** 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * The context for the message-driven bean, set by the EJB container. 
     * @generated
     */
    private javax.ejb.MessageDrivenContext messageContext = null;

    /** 
     * Required method for container to set context.
     * @generated 
     */
    public void setMessageDrivenContext(
            javax.ejb.MessageDrivenContext messageContext)
            throws javax.ejb.EJBException {
        this.messageContext = messageContext;
    }

    /** 
     * Required creation method for message-driven beans. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     *
     * <!-- begin-xdoclet-definition -->
     * @ejb.create-method 
     * <!-- end-xdoclet-definition -->
     * @generated
     */
    public void ejbCreate() {
        //no specific action required for message-driven beans 
    }

    /** 
     * Required removal method for message-driven beans. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void ejbRemove() {
        messageContext = null;
    }

    /** 
     * This method implements the business logic for the EJB. 
     * 
     * <p>Make sure that the business logic accounts for asynchronous message processing. 
     * For example, it cannot be assumed that the EJB receives messages in the order they were 
     * sent by the client. Instance pooling within the container means that messages are not 
     * received or processed in a sequential order, although individual onMessage() calls to 
     * a given message-driven bean instance are serialized. 
     * 
     * <p>The <code>onMessage()</code> method is required, and must take a single parameter 
     * of type javax.jms.Message. The throws clause (if used) must not include an application 
     * exception. Must not be declared as final or static. 
     *
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void onMessage(javax.jms.Message message) {

        m_log.debug("onMessage start");

        if (message instanceof ObjectMessage) {
            ObjectMessage objectMessage = (ObjectMessage) message;
            Object obj;
            try {
                obj = objectMessage.getObject();
            } catch (JMSException e) {
                m_log.error("å", e);
                return;
            }

//            if (obj instanceof RunInstructionInfo) {
            if (obj instanceof CollectiveRunInstructionInfo) {
                m_log.debug("onMessage get RunInstructionInfo");

//                RunInstructionInfo info = (RunInstructionInfo) obj;
                CollectiveRunInstructionInfo info = (CollectiveRunInstructionInfo) obj;

                m_log.debug("onMessage SessionID=" + info.getSessionId()
                        + ", FacilityID=" + info.getFacilityId());

                //ޥɼ¹
                exec(info);

            } else {
                m_log.error("å" + obj.toString());
                return;
            }
        } else {
            m_log.error("å" + message.getClass());
            return;
        }
        m_log.debug("onMessage end");
    }
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Runnable#run()
     */
//    public void exec(RunInstructionInfo instructionInfo) {
    public void exec(CollectiveRunInstructionInfo instructionInfo) {
        m_log.debug("run start :" + instructionInfo.getFacilityId());

        //---------------------------
        //-- ϥå
        //---------------------------

        //å
        RunResultInfo resultInfo = new RunResultInfo();
        resultInfo.setSessionId(instructionInfo.getSessionId());
        resultInfo.setJobId(instructionInfo.getJobId());
        resultInfo.setFacilityId(instructionInfo.getFacilityId());
        resultInfo.setCommandType(instructionInfo.getCommandType());
        resultInfo.setStatus(RunStatusConstant.START);
        resultInfo.setTime(new Date());

        m_log.info("run SessionID=" + instructionInfo.getSessionId() + ", JobID="
                + instructionInfo.getJobId());

        //
        SendQueue send = null;
        try {
            send = new SendQueue(QueueConstant.QUEUE_NAME_STATUS);
            send.put(resultInfo);
        } catch (NamingException e1) {
            m_log.error(e1);
        } catch (JMSException e1) {
            m_log.error(e1);
        }

        //---------------------------
        //-- ޥɼ¹
        //---------------------------

        //⡼ȼ¹ԥۥ̾
        String host = "";
        try {
            host = getRemoteHostName(instructionInfo.getFacilityId());
        } catch (Exception e) {
            //λåμ̤򥻥å
            resultInfo.setStatus(RunStatusConstant.ERROR);
            resultInfo.setTime(new Date());
            resultInfo.setErrorMessage(e.getMessage());

            //
            try {
                send.put(resultInfo);
            } catch (NamingException e1) {
                m_log.error(e1);
            } catch (JMSException e1) {
                m_log.error(e1);
            }
            return;
        }

        //ޥɽλͼʸ֥åID:ret=
        String endValueStr = instructionInfo.getSessionId() + ":ret=";

        //¹ԥޥȤΩ
        String cmd[] = new String[5];
        cmd[0] = getRemoteExec();
        cmd[1] = host;
        cmd[2] = "-l";
        cmd[3] = "root";
//        cmd[4] = instructionInfo.getCommand() + ";echo " + endValueStr + "$?;sleep 1";
        cmd[4] = instructionInfo.getCommand() + ";echo " + endValueStr + "$?;read";
//      sleep ϥޥɽλɸϤڤƤޤΤǻ

        CommandExecutor executor = new CommandExecutor();

//        boolean ret = executor.exec(cmd, instructionInfo.getInputFile());
        boolean ret = executor.exec(cmd, instructionInfo.getInputFile(), endValueStr);
        int exitValue = executor.getExitValue();
        String resultMsg = executor.getResultMsg();

        //---------------------------
        //-- λå
        //---------------------------
        boolean errFlg = true;
        if (ret) {
            //⡼ȥ뼫Τμ¹ԥơå
            if (exitValue == 0) {
                //⡼ȥ뤬ʤСޥɤνλͤɸϤ
                int idx = resultMsg.lastIndexOf(endValueStr);
                if (idx != -1) {
                    //ޥɤνλͤǤСλͤ򥳥ޥɽλͤˤ
                    String endValue = resultMsg.substring(idx
                            + endValueStr.length(), resultMsg.length() - 1);
                    m_log.debug(endValue);
                    exitValue = Integer.parseInt(endValue);
                    m_log.debug("int:" + exitValue);
                    resultMsg = resultMsg.substring(0, idx);
                    errFlg = false;
                }
                String passwd = instructionInfo.getPassword();
                if(passwd != null){
                	resultMsg = resultMsg.replaceAll(passwd,"");
                }
            }
        }

        //λåμ̤򥻥å
        if (errFlg) {
            resultInfo.setStatus(RunStatusConstant.ERROR);
        } else {
            resultInfo.setStatus(RunStatusConstant.END);
            resultInfo.setEndValue(exitValue);
        }

        //λ
        resultInfo.setTime(new Date());
        resultInfo.setErrorMessage(executor.getErrMsg());
        resultInfo.setMessage(resultMsg);

        //
        try {
            send.put(resultInfo);
        } catch (NamingException e1) {
            m_log.error(e1);
        } catch (JMSException e1) {
            m_log.error(e1);
        }
        
        //
        try {
            send.close();
        } catch (NamingException e1) {
            m_log.error(e1);
        } catch (JMSException e1) {
            m_log.error(e1);
        }

        m_log.debug("run end :" + instructionInfo.getFacilityId());
    }

    /**
     * ⡼ȥۥȼ. եƥIDIPɥ쥹ޤϡۥ֤̾
     * 
     * @param facilityID
     *            եƥID
     * @return IPɥ쥹ޤϥۥ̾
     * @since
     */
    private String getRemoteHostName(String facilityID) throws Exception {
        String host = null;
        //RepositoryController
        RepositoryControllerLocal repository = null;
        try {
            repository = RepositoryControllerUtil.getLocalHome().create();

            //եƥIDIPȥۥ̾
            ArrayList facilityAttrList = new ArrayList();
            facilityAttrList.add(FacilityAttributeConstant.NODENAME);
            facilityAttrList.add(FacilityAttributeConstant.IPNETWORKNUMBER);

            HashMap facilityAttrMap = 
                repository.getNodeDetail(facilityID, facilityAttrList);
            //IPǤСIPǤʤСۥ̾(Ρ̾)֤
            host = (String) facilityAttrMap
                    .get(FacilityAttributeConstant.IPNETWORKNUMBER);
            if (host == null || host.length() == 0) {
                host = (String) facilityAttrMap
                        .get(FacilityAttributeConstant.NODENAME);
                if (host == null) {
                    host = "";
                }
            }

            if (m_log.isDebugEnabled()) {
                m_log.debug("⡼оݥۥȡ" + host);
            }

        } catch (Exception e) {
            m_log.error(e);
            throw e;

        } finally {
            try {
                if (repository != null) {
                    repository.remove();
                }
            } catch (Exception e) {
            }

        }

        return host;
    }
    
	/**
	 * ¹ԥץѥƥե뤫
	 * 
	 * @version 2.0.0
	 * @since 2.0.0
	 */
	public String getRemoteExec() {
	    Properties properties = new Properties();
		String homedir = System.getProperty("jboss.server.home.dir");
		String propertyFile = homedir + File.separator + "conf" + File.separator + "collectiverun.properties";
		
		String remoteExec = RSH;
		try {
			// ץѥƥե뤫饭ͤΥꥹȤɤ߹ߤޤ
			properties.load(new FileInputStream(propertyFile));
			
			remoteExec = properties.getProperty("collective.run.shell", "");
			if(remoteExec.equalsIgnoreCase(RSH)){
				remoteExec = RSH;
			}
			else if(remoteExec.equalsIgnoreCase(SSH)){
				remoteExec = SSH;
			}
		} catch (Exception e) {
		}
		return remoteExec;
	}
}
