

-- 
-- TABLE: cc_crun_cmd_mst 
--

CREATE TABLE cc_crun_cmd_mst(
    command_id      VARCHAR(64)     NOT NULL,
    type_id         VARCHAR(64),
    order_no        SMALLINT     NOT NULL,
    name_id         VARCHAR(256),
    command_type    SMALLINT     NOT NULL,
    command         VARCHAR(256),
    CONSTRAINT p_key_cc_crun_cmd_mst PRIMARY KEY (command_id)
) 
;


-- 
-- TABLE: cc_crun_cmd_param_mst 
--

CREATE TABLE cc_crun_cmd_param_mst(
    command_id      VARCHAR(64)    NOT NULL,
    param_id        VARCHAR(64)    NOT NULL,
    order_no        SMALLINT    NOT NULL,
    param_prefix    VARCHAR(64),
    CONSTRAINT p_key_cc_crun_cmd_param_mst PRIMARY KEY (command_id, param_id)
) 
;


-- 
-- TABLE: cc_crun_end_mst 
--

CREATE TABLE cc_crun_end_mst(
    command_id        VARCHAR(64)    NOT NULL,
    end_status        SMALLINT    NOT NULL,
    end_value_from    SMALLINT    NOT NULL,
    end_value_to      SMALLINT    NOT NULL,
    CONSTRAINT p_key_cc_crun_end_mst PRIMARY KEY (command_id, end_status)
) 
;


-- 
-- TABLE: cc_crun_param_mst 
--

CREATE TABLE cc_crun_param_mst(
    param_id      VARCHAR(64)     NOT NULL,
    name_id       VARCHAR(256)    NOT NULL,
    param_type    SMALLINT        NOT NULL,
    CONSTRAINT p_key_cc_crun_param_mst PRIMARY KEY (param_id)
) 
;


-- 
-- TABLE: cc_crun_param_select_mst 
--

CREATE TABLE cc_crun_param_select_mst(
    param_id       VARCHAR(64)     NOT NULL,
    order_no       SMALLINT     NOT NULL,
    name_id        VARCHAR(256)    NOT NULL,
    param_value    VARCHAR(256),
    CONSTRAINT p_key_cc_crun_param_select_mst PRIMARY KEY (param_id, order_no)
) 
;


-- 
-- TABLE: cc_crun_session 
--

CREATE TABLE cc_crun_session(
    session_id         VARCHAR(64)     NOT NULL,
    start_date         TIMESTAMP,
    end_date           TIMESTAMP,
    type_id            VARCHAR(64)     NOT NULL,
    command_id         VARCHAR(64),
    facility_id        VARCHAR(64)     NOT NULL,
    scope_text         VARCHAR(256),
    node_cnt           SMALLINT     NOT NULL,
    wait_cnt           SMALLINT     NOT NULL,
    running_cnt        SMALLINT     NOT NULL,
    end_nomal_cnt      SMALLINT     NOT NULL,
    end_warning_cnt    SMALLINT     NOT NULL,
    end_abnomal_cnt    SMALLINT     NOT NULL,
    status             SMALLINT     NOT NULL,
    CONSTRAINT p_key_cc_crun_session PRIMARY KEY (session_id)
) 
;


-- 
-- TABLE: cc_crun_session_detail 
--

CREATE TABLE cc_crun_session_detail(
    session_id       VARCHAR(64)     NOT NULL,
    facility_id      VARCHAR(64)     NOT NULL,
    start_date       TIMESTAMP,
    end_date         TIMESTAMP,
    facility_name    VARCHAR(256),
    message          TEXT,
    error_message    TEXT,
    status           SMALLINT     NOT NULL,
    end_status       SMALLINT,
    end_value        SMALLINT,
    CONSTRAINT p_key_cc_crun_session_detail PRIMARY KEY (session_id, facility_id)
) 
;


-- 
-- TABLE: cc_crun_session_param 
--

CREATE TABLE cc_crun_session_param(
    session_id     VARCHAR(64)     NOT NULL,
    param_id       VARCHAR(64)     NOT NULL,
    param_value    VARCHAR(256),
    CONSTRAINT p_key_cc_crun_session_param PRIMARY KEY (session_id, param_id)
) 
;


-- 
-- TABLE: cc_crun_type_mst 
--

CREATE TABLE cc_crun_type_mst(
    type_id     VARCHAR(64)     NOT NULL,
    name_id     VARCHAR(256)    NOT NULL,
    order_no    SMALLINT     NOT NULL,
    CONSTRAINT p_key_cc_crun_type_mst PRIMARY KEY (type_id)
) 
;


-- 
-- TABLE: cc_crun_cmd_param_mst 
--

ALTER TABLE cc_crun_cmd_param_mst ADD CONSTRAINT Refcc_crun_cmd_mst51 
    FOREIGN KEY (command_id)
    REFERENCES cc_crun_cmd_mst(command_id)
;

ALTER TABLE cc_crun_cmd_param_mst ADD CONSTRAINT Refcc_crun_param_mst61 
    FOREIGN KEY (param_id)
    REFERENCES cc_crun_param_mst(param_id)
;


-- 
-- TABLE: cc_crun_end_mst 
--

ALTER TABLE cc_crun_end_mst ADD CONSTRAINT Refcc_crun_cmd_mst41 
    FOREIGN KEY (command_id)
    REFERENCES cc_crun_cmd_mst(command_id)
;


-- 
-- TABLE: cc_crun_param_select_mst 
--

ALTER TABLE cc_crun_param_select_mst ADD CONSTRAINT Refcc_crun_param_mst71 
    FOREIGN KEY (param_id)
    REFERENCES cc_crun_param_mst(param_id)
;


-- 
-- TABLE: cc_crun_session_detail 
--

ALTER TABLE cc_crun_session_detail ADD CONSTRAINT Refcc_crun_session81 
    FOREIGN KEY (session_id)
    REFERENCES cc_crun_session(session_id)
;


-- 
-- TABLE: cc_crun_session_param 
--

ALTER TABLE cc_crun_session_param ADD CONSTRAINT Refcc_crun_session131 
    FOREIGN KEY (session_id)
    REFERENCES cc_crun_session(session_id)
;


-- 
-- TABLE: cc_crun_cmd_mst 
--

ALTER TABLE cc_crun_cmd_mst ADD CONSTRAINT Refcc_crun_type_mst14 
    FOREIGN KEY (type_id)
    REFERENCES cc_crun_type_mst(type_id)
;

