/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun.bean;

import java.io.Serializable;


/**
 * 쥯饹
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class ItemInfo implements Serializable, Cloneable {
	private static final long serialVersionUID = 8658155648192008796L;

	/**  */
	protected int type;
	
	/** ̾ */
	protected String name;
	
	/** ɽ */
	protected int orderNo;
	
	/**
	 * @return
	 */
	public int getType() {
		return type;
	}

	/**
	 * @param type
	 */
	public void setType(int type) {
		this.type = type;
	}
	
	/**
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name
	 */
	public void setName(String name) {
		this.name = name;
	}
	
    /**
     * @return
     */
    public int getOrderNo() {
		return orderNo;
	}

	/**
	 * @param orderNo
	 */
	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}
	
	/* (non-Javadoc)
     * @see java.lang.Object#clone()
     * @since 2.1.0
     */
	public Object clone() {
        try {
        	ItemInfo clone = (ItemInfo)super.clone();
            
            clone.setType(this.getType());
            clone.setName(this.getName());
            clone.setOrderNo(this.getOrderNo());
            
            return clone;
        } catch (CloneNotSupportedException e) {
            return null;
        }
    }
}