/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.collectiverun;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

/**
 * 浡ǽץ饰󥯥饹Ǥ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class CollectiveRunPlugin extends AbstractUIPlugin {

    // ----- static ե ----- //

    //	The shared instance.
    private static CollectiveRunPlugin plugin;

    // ----- instance ե----- //

    //	Resource bundle.
    private ResourceBundle resourceBundle;

    /**
     * 󥹥ȥ饯
     *  
     */
    public CollectiveRunPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.collectiverun.CollectiveRunPluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    /**
     * This method is called upon plug-in activation
     * 
     * @param context
     * @throws Exception
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     * 
     * @param context
     * @throws Exception
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * Returns the shared instance.
     * 
     * @return plugin
     */
    public static CollectiveRunPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     * 
     * @param key
     * @return key
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = CollectiveRunPlugin.getDefault()
                .getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     * 
     * @return resouceBundle
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }
}