/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.view;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.FacilityPath;
import com.clustercontrol.bean.FacilityTreeItem;
import com.clustercontrol.composite.FacilityTreeComposite;
import com.clustercontrol.ui.ClusterControlUIPlugin;
import com.clustercontrol.util.Messages;

/**
 * ץĥ꡼ȹ碌Ѥӥ塼뤿δŪʼĥ饹Ǥ
 * <p>
 * 
 * ŪˤϡcreateContents򥪡С饤ɤɲåƥĤƲ <br>
 * ޤɬפ˱doSelectTreeItem򥪡С饤ɤĥ꡼ƥ ٥ȽƲ
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public abstract class ScopeListBaseView extends AutoUpdateView {
	
	// ----- instance ե ----- //
	
	/** åե */
	private SashForm treeSash = null;
	
	/** ץĥ꡼Υݥå */
	private FacilityTreeComposite scopeTreeComposite = null;
	
	/** ɲåݥåȤΥ١ */
	private Composite baseComposite = null;
	
	/** ɲåݥå */
	private Composite listComposite = null;
	
	/** ѥʸɽ٥ */
	private Label pathLabel = null;
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * ƤΥ󥹥ȥ饯ƤӽФޤ
	 */
	public ScopeListBaseView() {
		super();
	}
	
	// ----- instance ᥽å ----- //
	
	/**
	 * ӥ塼ޤ
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		
		// 쥤
		GridLayout layout = new GridLayout(1, true);
		parent.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		
		// åեڤ
		this.treeSash = new SashForm(parent, SWT.HORIZONTAL);
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		gridData.horizontalSpan = 1;
		this.treeSash.setLayoutData(gridData);
		
		// ץĥ꡼
		this.scopeTreeComposite = new FacilityTreeComposite(treeSash, SWT.NONE);
		
		// ɲåݥåȤΥ١
		this.baseComposite = new Composite(this.treeSash, SWT.NONE);
		
		// ѥʸɽ٥
		this.pathLabel = new Label(this.baseComposite, SWT.NONE);
		this.pathLabel.setText(Messages.getString("scope") + " : ");
//		this.pathLabel.pack();
		
		// ɲåƥĺ
		this.listComposite = this.createListContents(this.baseComposite);
		
		// SashζĴ 20% 80%
		treeSash.setWeights(new int[] { 30, 70 });
		
		// ĥ꡼ƥΥꥹʡɲ
		this.scopeTreeComposite.getTreeViewer().addSelectionChangedListener(
				new ISelectionChangedListener() {
					public void selectionChanged(SelectionChangedEvent event) {
						// 򥢥ƥ(ĥ꡼ΤǤԤäƤ뤬ǰΤ)
						StructuredSelection selection = (StructuredSelection) event
						.getSelection();
						FacilityTreeItem selectItem = (FacilityTreeItem) selection
						.getFirstElement();
						if (selectItem instanceof FacilityTreeItem) {
							// ѥ٥ι
							FacilityPath path = new FacilityPath(
									ClusterControlUIPlugin.getDefault()
									.getSeparator());
							pathLabel.setText(Messages.getString("scope")
									+ " : " + path.getPath(selectItem));
//							pathLabel.pack();
							baseComposite.layout(true, true);
							// ٥ȥ᥽åɸƤӽФ
							doSelectTreeItem(selectItem);
						}
					}
				});
	}
	
	/**
	 * ɲåƥĤޤ
	 * <p>
	 * 
	 * С饤ɤơɲåݥåȤƲ
	 * 
	 * @param parent
	 *            ɲåƥĤΥ١ݥå
	 */
	protected abstract Composite createListContents(Composite parent);
	
	/**
	 * ץĥ꡼Υƥब򤵤줿˸ƤӽФ᥽åɤǤ
	 * <p>
	 * 
	 * ɬפ˱ƥС饤ɤƥΥ٥ȽƲ
	 * 
	 * @param item
	 *            ץĥ꡼ƥ
	 */
	protected void doSelectTreeItem(FacilityTreeItem item) {
		
	}
	
	/**
	 * Υӥ塼Υ쥤Ȥۤ륵åե֤ޤ
	 * 
	 * @return åե
	 */
	public SashForm getTreeSash() {
		return this.treeSash;
	}
	
	/**
	 * ץĥ꡼ΥݥåȤ֤ޤ
	 * 
	 * @return ץĥ꡼Υݥå
	 */
	public FacilityTreeComposite getScopeTreeComposite() {
		return this.scopeTreeComposite;
	}
	
	/**
	 * ɲåݥåȤΥ١֤ޤ
	 * 
	 * @return ɲåݥåȤΥ١
	 */
	public Composite getBaseComposite() {
		return this.baseComposite;
	}
	
	/**
	 * ɲåݥåȤ֤ޤ
	 * 
	 * @return ɲåݥå
	 */
	public Composite getListComposite() {
		return this.listComposite;
	}
	
	/**
	 * ѥʸɽ٥֤ޤ
	 * 
	 * @return ѥʸɽ٥
	 */
	public Label getPathLabel() {
		return this.pathLabel;
	}
	
	/**
	 * ɽޤ
	 */
	public void show() {
		this.treeSash.setMaximizedControl(null);
	}
	
	/**
	 * ޤ
	 */
	public void hide() {
		this.treeSash.setMaximizedControl(this.baseComposite);
	}
}