/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.ui;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

import com.clustercontrol.action.FacilityTree;

/**
 * The main plugin class to be used in the desktop.
 */
public class ClusterControlUIPlugin extends AbstractUIPlugin {

    // ----- static ե ----- //

    /** 󥽡륢μ */
    public static final String IMG_CONSOLE = "console";

    /** ץμ */
    public static final String IMG_SCOPE = "scope";

    /** Ρɥμ */
    public static final String IMG_NODE = "node";

    /** ֥˥åȥμ */
    public static final String IMG_JOBUNIT = "jobunit";

    /** ֥ͥåȥμ */
    public static final String IMG_JOBNET = "jobnet";

    /** ֥μ */
    public static final String IMG_JOB = "job";
    
    /** եž֥μ */
    public static final String IMG_FILEJOB = "filejob";

    /** åͭꥢμ */
    public static final String IMG_CHECKED = "checked";

    /** åʤμ */
    public static final String IMG_UNCHECKED = "unchecked";

    /** ¹Ծ()μ */
    public static final String IMG_STATUS_WHITE = "status_white";

    /** ¹Ծ()μ */
    public static final String IMG_STATUS_YELLOW = "status_yellow";

    /** ¹Ծ()μ */
    public static final String IMG_STATUS_BLUE = "status_blue";

    /** ¹Ծ()μ */
    public static final String IMG_STATUS_RED = "status_red";

    /** ¹Ծ()μ */
    public static final String IMG_STATUS_GREEN = "status_green";

    /** λ()μ */
    public static final String IMG_END_STATUS_NORMAL = "normal";

    /** λ(ٹ)μ */
    public static final String IMG_END_STATUS_WARNING = "warning";

    /** λ(۾)μ */
    public static final String IMG_END_STATUS_ABNORMAL = "abnormal";

    /** ͽ()μ */
    public static final String IMG_SCHEDULE_PAST = "schedule_past";

    /** ͽ()μ */
    public static final String IMG_SCHEDULE_NOW = "schedule_now";

    /** ͽ(̤)μ */
    public static final String IMG_SCHEDULE_FUTURE = "schedule_future";
    
    //The shared instance.
    private static ClusterControlUIPlugin plugin;

    // ----- instance ᥽å ----- //

    //Resource bundle.
    private ResourceBundle resourceBundle;

    protected String separator;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * The constructor.
     */
    public ClusterControlUIPlugin() {
        super();
        plugin = this;
        try {
            resourceBundle = ResourceBundle
                    .getBundle("com.clustercontrol.ui.ClusterControlUIPluginResources");
        } catch (MissingResourceException x) {
            resourceBundle = null;
        }
    }

    // ----- instance ᥽å ----- //

    /**
     * This method is called upon plug-in activation
     */
    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    /**
     * This method is called when the plug-in is stopped
     */
    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    /**
     * Returns the shared instance.
     */
    public static ClusterControlUIPlugin getDefault() {
        return plugin;
    }

    /**
     * Returns the string from the plugin's resource bundle, or 'key' if not
     * found.
     */
    public static String getResourceString(String key) {
        ResourceBundle bundle = ClusterControlUIPlugin.getDefault()
                .getResourceBundle();
        try {
            return (bundle != null) ? bundle.getString(key) : key;
        } catch (MissingResourceException e) {
            return key;
        }
    }

    /**
     * Returns the plugin's resource bundle,
     */
    public ResourceBundle getResourceBundle() {
        return resourceBundle;
    }

    /**
     * ץ饰󥯥饹ݻImageRegistry˥᡼Ͽޤ
     * 
     * @param registry
     *            ImageRegistry֥
     */
    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_CONSOLE, "console_view.gif");
        this.registerImage(registry, IMG_SCOPE, "scope.gif");
        this.registerImage(registry, IMG_NODE, "node.gif");
        this.registerImage(registry, IMG_JOBUNIT, "job_unit.gif");
        this.registerImage(registry, IMG_JOBNET, "job_net.gif");
        this.registerImage(registry, IMG_JOB, "job.gif");
        this.registerImage(registry, IMG_FILEJOB, "file_obj.gif");
        this.registerImage(registry, IMG_CHECKED, "checked.gif");
        this.registerImage(registry, IMG_UNCHECKED, "unchecked.gif");
        this.registerImage(registry, IMG_STATUS_BLUE, "status_blue.gif");
        this.registerImage(registry, IMG_STATUS_GREEN, "status_green.gif");
        this.registerImage(registry, IMG_STATUS_RED, "status_red.gif");
        this.registerImage(registry, IMG_STATUS_WHITE, "status_white.gif");
        this.registerImage(registry, IMG_STATUS_YELLOW, "status_yellow.gif");
        this.registerImage(registry, IMG_END_STATUS_NORMAL, "normal.gif");
        this.registerImage(registry, IMG_END_STATUS_WARNING, "warning.gif");
        this.registerImage(registry, IMG_END_STATUS_ABNORMAL, "abnormal.gif");
        this.registerImage(registry, IMG_SCHEDULE_PAST, "schedule_g.gif");
        this.registerImage(registry, IMG_SCHEDULE_NOW, "schedule_b.gif");
        this.registerImage(registry, IMG_SCHEDULE_FUTURE, "schedule_w.gif");
    }

    /**
     * ImageRegistry˥᡼Ͽޤ
     * 
     * @param registry
     *            ImageRegistry֥
     * @param key
     *            
     * @param fileName
     *            ᡼ե̾
     */
    private void registerImage(ImageRegistry registry, String key,
            String fileName) {
        try {
            URL url = new URL(getDefault().getBundle().getEntry("/"), "icons/"
                    + fileName);
            ImageDescriptor desc = ImageDescriptor.createFromURL(url);
            registry.put(key, desc);
        } catch (Exception e) {
        }
    }

    /**
     * @return Returns the separator.
     */
    public String getSeparator() {
        if (separator == null || separator.compareTo("") == 0) {
            FacilityTree facilityTree = new FacilityTree();
            separator = facilityTree.getSeparator();
        }

        return separator;
    }

    /**
     * @param separator
     *            The separator to set.
     */
    public void setSeparator(String separator) {
        this.separator = separator;
    }
}