/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.dialog;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.notify.action.AddNotify;
import com.clustercontrol.notify.action.DeleteNotify;
import com.clustercontrol.notify.action.ModifyNotify;
import com.clustercontrol.notify.bean.NotifyInfo;
import com.clustercontrol.notify.bean.NotifyTabelDefine;
import com.clustercontrol.notify.composite.NotifyListComposite;
import com.clustercontrol.util.Messages;

/**
 * ΰ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyListDialog extends CommonDialog {

    // ----- instance ե ----- //

    /** ΰ */
    private NotifyListComposite notifyList = null;

    /** ɲåܥ */
    private Button buttonAdd = null;

    /** ѹܥ */
    private Button buttonModify = null;

    /** ܥ */
    private Button buttonDelete = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * Υ󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥ륪֥
     */
    public NotifyListDialog(Shell parent) {
        super(parent);
        setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
    }

    // ----- instance ᥽å ----- //

    /**
     * ν֤ޤ
     * 
     * @return 
     */
    protected Point getInitialSize() {
        return new Point(800, 350);
    }

    /**
     * ꥢޤ
     * 
     * @param parent
     *            ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.notify.list"));

        // 쥤
        GridLayout layout = new GridLayout(8, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 8;
        parent.setLayout(layout);

        /*
         * 
         */

        this.notifyList = new NotifyListComposite(parent, SWT.BORDER);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 7;
        this.notifyList.setLayoutData(gridData);

        /*
         * ܥ
         */

        Composite composite = new Composite(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 1;
        composite.setLayoutData(gridData);

        // ɲåܥ
        this.buttonAdd = this
                .createButton(composite, Messages.getString("add"));
        this.buttonAdd.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	NotifyCreateDialog dialog = new NotifyCreateDialog(getParentShell());
                if (dialog.open() == IDialogConstants.OK_ID) {
                	
                	NotifyInfo info = dialog.getInputData();
                	if(info != null){
                    	boolean result = new AddNotify().add(info);
                        String[] args = { info.getNotifyId() };
                        if(result){
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                            box.setText(Messages.getString("successful"));
                            box.setMessage(Messages.getString("message.notify.1",args));
                            box.open();
                            
                        	notifyList.update();
                        }
                        else{
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                            box.setText(Messages.getString("failed"));
                            box.setMessage(Messages.getString("message.notify.2",args));
                            box.open();
                        }
                	}
                }
            }
        });

        // ѹܥ
        Label dummy = new Label(composite, SWT.NONE);
        this.buttonModify = this.createButton(composite, Messages.getString("modify"));
        this.buttonModify.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String notifyId = null;
            	
            	Table table = notifyList.getTableViewer().getTable();
            	TableItem[] item = table.getSelection();
            	
            	if(item != null && item.length>0){
            		try{
            			notifyId = (String)((ArrayList)item[0].getData()).get(NotifyTabelDefine.NOTIFY_ID);
            		}
            		catch(Exception ex){
            		}
            	}

                if (notifyId != null) {
                	NotifyCreateDialog dialog = new NotifyCreateDialog(getParentShell(), notifyId, false);
                    if (dialog.open() == IDialogConstants.OK_ID) {
                    	boolean result = new ModifyNotify().modify(dialog.getInputData());
                        String[] args = { notifyId };
                        if(result){
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                            box.setText(Messages.getString("successful"));
                            box.setMessage(Messages.getString("message.notify.3",args));
                            box.open();
                            
                            int selectIndex = table.getSelectionIndex();
                            notifyList.update();
                            table.setSelection(selectIndex);
                        }
                        else{
                            MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                            box.setText(Messages.getString("failed"));
                            box.setMessage(Messages.getString("message.notify.4",args));
                            box.open();
                        }
                    }
                }
                else{
                    MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                    box.setText(Messages.getString("warning"));
                    box.setMessage(Messages.getString("message.notify.8"));
                    box.open();
                  }
            }
        });

        // ܥ
        dummy = new Label(composite, SWT.NONE);
        this.buttonDelete = this.createButton(composite, Messages
                .getString("delete"));
        this.buttonDelete.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String notifyId = null;
            	
            	Table table = notifyList.getTableViewer().getTable();
            	TableItem[] item = table.getSelection();
            	
            	if(item != null && item.length>0){
            		try{
            			notifyId = (String)((ArrayList)item[0].getData()).get(NotifyTabelDefine.NOTIFY_ID);
            		}
            		catch(Exception ex){
            		}
            	}

                if (notifyId != null) {
                	
                  MessageBox confirmBox = new MessageBox(getShell(), SWT.OK | SWT.CANCEL | SWT.ICON_WARNING);
                  confirmBox.setText(Messages.getString("confirmed"));
                  String[] args = { notifyId };
                  String message = Messages.getString("message.notify.7",args);
                  confirmBox.setMessage(message);

		          if (confirmBox.open() == SWT.OK) {
		        	  boolean result = new DeleteNotify().delete(notifyId);
                      if(result){
                          MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_INFORMATION);
                          box.setText(Messages.getString("successful"));
                          box.setMessage(Messages.getString("message.notify.5", args));
                          box.open();
                          
                          notifyList.update();
                      }
                      else{
                          MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_ERROR);
                          box.setText(Messages.getString("failed"));
                          box.setMessage(Messages.getString("message.notify.6", args));
                          box.open();
                      }
		          }
                }
                else{
                  MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                  box.setText(Messages.getString("warning"));
                  box.setMessage(Messages.getString("message.notify.9"));
                  box.open();
                }
            }
        });

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 8;
        line.setLayoutData(gridData);

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        return super.validate();
    }

    /**
     * ̤Υܥޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param label
     *            ܥΥ٥
     * @return 줿ܥ
     */
    private Button createButton(Composite parent, String label) {
        Button button = new Button(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);

        button.setText(label);

        return button;
    }
    
    /**
     * Ĥܥޤ
     * 
     * @param parent ܥСݥå
     */
    protected void createButtonsForButtonBar(Composite parent) {
    	
        // Ĥܥ
        this.createButton(parent, IDialogConstants.CANCEL_ID, IDialogConstants.CLOSE_LABEL, false);
    }

}