/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.composite.CommonTableViewer;
import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.action.GetNotifyListTableDefine;
import com.clustercontrol.notify.bean.NotifyTabelDefine;
;

/**
 * ΰݥåȥ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class NotifyListComposite extends Composite {

    // ----- instance ե ----- //

    /** ơ֥ӥ塼 */
    private CommonTableViewer tableViewer = null;

    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent
     *            ƤΥݥå
     * @param style
     *            
     */
    public NotifyListComposite(Composite parent, int style) {
        super(parent, style);

        this.initialize();
    }

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
        GridLayout layout = new GridLayout(1, true);
        this.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

        Table table = new Table(this, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL
                | SWT.FULL_SELECTION);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);

        // ơ֥ӥ塼κ
        this.tableViewer = new CommonTableViewer(table);
        this.tableViewer.createTableColumn(GetNotifyListTableDefine.get(),
        		NotifyTabelDefine.SORT_COLUMN_INDEX,
        		NotifyTabelDefine.SORT_ORDER);

        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;

        this.update();
    }

    /**
     * tableViewer֤ޤ
     * 
     * @return tableViewer
     */
    public CommonTableViewer getTableViewer() {
        return this.tableViewer;
    }

    /**
     * ݥåȤ򹹿ޤ
     * <p>
     * 
     */
    public void update() {
        // ǡ
    	ArrayList list = new GetNotify().getNotifyList();
    	
    	if(list == null)
    		list = new ArrayList();
    	 
        // ơ֥빹
        this.tableViewer.setInput(list);
    }
}