/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.notify.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.notify.action.GetNotify;
import com.clustercontrol.notify.dialog.NotifyCreateDialog;
import com.clustercontrol.util.Messages;


/**
 * IDݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class NotifyIdListComposite extends Composite {

    // ----- instance ե ----- //
	
	/** ٥ʸ */
	private String m_text = null;

    /** ID٥ */
	private Label m_labelNotifyId = null;
	
    /** IDܥܥå */
    private Combo m_comboNotifyId = null;
    
    /** ȥܥ */
    private Button m_buttonRefer = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param labelFlg ID٥ɽե饰
     */
    public NotifyIdListComposite(Composite parent, int style, boolean labelFlg) {
        super(parent, style);
        m_text = Messages.getString("notify.id");
        
        this.initialize(parent, labelFlg);
    }
    
    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param text ID٥ʸ
     */
    public NotifyIdListComposite(Composite parent, int style, String text) {
        super(parent, style);
        m_text = text;
        
        this.initialize(parent, true);
    }
    

    // ----- instance ᥽å ----- //

    /**
     * ݥåȤۤޤ
     */
    private void initialize(Composite parent, boolean labelFlg) {
    	
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        if(labelFlg){
        	layout.numColumns = 15;	
        }
        else{
        	layout.numColumns = 10;
        }
        this.setLayout(layout);
        
        /*
         * ID
         */
        
        if(labelFlg){
            // ٥
            this.m_labelNotifyId = new Label(this, SWT.NONE);
            gridData = new GridData();
            gridData.horizontalSpan = 5;
            gridData.horizontalAlignment = GridData.FILL;
            gridData.grabExcessHorizontalSpace = true;
            this.m_labelNotifyId.setLayoutData(gridData);
            this.m_labelNotifyId.setText(m_text + " : ");
        }
        
        // ܥܥå
        this.m_comboNotifyId = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboNotifyId.setLayoutData(gridData);
        
        // ȥܥ
        this.m_buttonRefer = new Button(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonRefer.setLayoutData(gridData);
        this.m_buttonRefer.setText(Messages.getString("refer"));
        this.m_buttonRefer.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	String notifyId = m_comboNotifyId.getText();
            	if(notifyId != null && !"".equals(notifyId.trim())){
                    // 
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    
                    // Ͽ/ѹ̤򳫤
            		NotifyCreateDialog dialog = new NotifyCreateDialog(shell, notifyId, true);
                    dialog.open();
            	}
            }
        });
        
        this.update();
    }

    /**
     * ݥåȤ򹹿ޤ
     * <p>
     * 
     */
    public void update() {
    	
    	// 
    	this.m_comboNotifyId.add("");
        
    	// ǡ
        ArrayList list = new GetNotify().getNotifyIdList();
        if(list != null){
        	// IDꥹ
        	for(int index=0; index<list.size(); index++){
        		this.m_comboNotifyId.add((String)list.get(index));
        	}
        }
    }

	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_comboNotifyId.setEnabled(enabled);
		this.m_buttonRefer.setEnabled(enabled);
	}

	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#getText()
	 */
	public String getText() {
		return this.m_comboNotifyId.getText();
	}

	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Combo#setText(java.lang.String)
	 */
	public void setText(String string) {
		this.m_comboNotifyId.setText(string);
	}
}