/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.dialog;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.bean.ValidConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.composite.StringRunJobComposite;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.notify.composite.NotifyIdListComposite;
import com.clustercontrol.util.Messages;

/**
 * ʸƻȽ ѹ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringValueInfoCreateDialog extends CommonDialog {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //

    /** ͤݻ륪֥ */
    private MonitorStringValueInfo m_inputData = null;

    /** ͤݻ륪֥ */
    private ValidateResult m_validateResult = null;

    /** ѹоݤμ̻ */
    private String m_identifier = null;

    /** ѹоݤν */
    private int m_order = Integer.MAX_VALUE;

    /**  */
    private Text m_textDescription = null;

    /** ѥޥå */
    private Text m_textPattern = null;

    /** ˰פʤ */
    private Button m_radioNotProcess = null;

    /** ˰פ */
    private Button m_radioProcess = null;
    
    /** ID */
    private NotifyIdListComposite m_notifyId = null;

    /**  */
    private Combo m_comboPriority = null;

    /** åID */
    private Text m_textMessageId = null;

    /** å */
    private Text m_textMessage = null;
    
    /** ּ¹ */
    private Button m_checkJobRun = null;
    
    /** ּ¹Ծ */
    private StringRunJobComposite m_jobRun = null;

    /** ͭˤ */
    private Button m_buttonValid = null;
    
    /**
     * ѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥ륪֥
     */
    public StringValueInfoCreateDialog(Shell parent) {
        super(parent);
    }

    /**
     * ѹѥΥ󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥ륪֥
     * @param identifier ѹʸƻȽμ̻
     */
    public StringValueInfoCreateDialog(Shell parent, String identifier) {
        super(parent);

        this.m_identifier = identifier;
    }

    // ----- instance ᥽å ----- //

    /**
     * ꥢޤ
     * 
     * @param parent ƤΥ󥹥
     */
    protected void customizeDialog(Composite parent) {
        Shell shell = this.getShell();

        // ȥ
        shell.setText(Messages.getString("dialog.monitor.run.create.modify.string"));

        // ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;

        // 쥤
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        parent.setLayout(layout);
        
        /*
         * 
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("description") + " : ");
        // ƥ
        this.m_textDescription = new Text(parent, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textDescription.setLayoutData(gridData);
                
        /*
         * ƻ殺롼
         */
        // ٥
        label = new Label(parent, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("monitor.rule") + " : ");

        // 롼
        Group monitorRuleGroup = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 15;
        monitorRuleGroup.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        monitorRuleGroup.setLayoutData(gridData);
        
        /*
         * ѥޥåɽ
         */
        // ٥
        label = new Label(monitorRuleGroup, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("pattern.matching.expression") + " : ");
        // ƥ
        this.m_textPattern = new Text(monitorRuleGroup, SWT.BORDER | SWT.LEFT);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textPattern.setLayoutData(gridData);

        /*
         * Ϥξ
         */
        // ˰פʤ
        this.m_radioNotProcess = new Button(parent, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioNotProcess.setLayoutData(gridData);
        this.m_radioNotProcess.setText(Messages.getString("don't.process.if.matched"));

        // ˰פ
        this.m_radioProcess = new Button(parent, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioProcess.setLayoutData(gridData);
        this.m_radioProcess.setText(Messages.getString("process.if.matched"));
        this.m_radioProcess.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                setEnabled(m_radioProcess.getSelection());
            }
        });

        /*
         * 殺롼
         */
        // 祰롼
        Group group = new Group(parent, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 15;
        group.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        group.setLayoutData(gridData);
        
        /*
         * 
         */
		// ξ
		this.m_notifyId = new NotifyIdListComposite(group, SWT.NONE, true);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_notifyId.setLayoutData(gridData);

        /*
         * 
         */
        // ٥
		label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("priority") + " : ");
        // ܥܥå
        this.m_comboPriority = new Combo(group, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboPriority.setLayoutData(gridData);
        this.m_comboPriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboPriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboPriority.add(PriorityConstant.STRING_INFO);
        this.m_comboPriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboPriority.setText(PriorityConstant.STRING_CRITICAL);
        // 
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);

        /*
         * åID
         */
        // ٥
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("message.id") + " : ");
        // ƥ
        this.m_textMessageId = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMessageId.setLayoutData(gridData);

        /*
         * å
         */
        // ٥
        label = new Label(group, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("message") + " : ");
        // ƥ
        this.m_textMessage = new Text(group, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = 10;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_textMessage.setLayoutData(gridData);
        
        // ּ¹
        this.m_checkJobRun = new Button(group, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        m_checkJobRun.setLayoutData(gridData);
        m_checkJobRun.setText(Messages.getString("run") + " : ");
        m_checkJobRun.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	m_jobRun.setEnabled(m_checkJobRun.getSelection());
            }
        });
		
		// ּ¹ԥ롼
        Group groupRunJob = new Group(group, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        groupRunJob.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        groupRunJob.setLayoutData(gridData);
        
        // ¹ԡʼ¹ԡIDϢưƽмԻ
		this.m_jobRun = new StringRunJobComposite(
				groupRunJob, 
				SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_jobRun.setLayoutData(gridData);

        /*
         * ̵ͭ
         */
        this.m_buttonValid = new Button(parent, SWT.CHECK);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_buttonValid.setLayoutData(gridData);
        this.m_buttonValid.setText(Messages.getString("setting.valid.confirmed"));

        // 饤
        Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 15;
        line.setLayoutData(gridData);

        // Ŭ
        // åɥ쥤ȤѤ硢ʤȲ̤äѤˤʤޤ
        shell.pack();
        shell.setSize(new Point(550, shell.getSize().y));

        // 
        Display display = shell.getDisplay();
        shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
                (display.getBounds().height - shell.getSize().y) / 2);

        // ̻ҤꤵƤ硢ξɽ롣
        MonitorStringValueInfo info = StringValueInfoManager.getInstance().get(this.m_identifier);
        if (info == null) {
        	info = new MonitorStringValueInfo();
        }
        this.setInputData(info);
    }

    /**
     * Ƥ֤ޤ
     * 
     * @return Ƥݻ
     */
    public MonitorStringValueInfo getInputData() {
        return this.m_inputData;
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤʸƻȽ
     */
    protected void setInputData(MonitorStringValueInfo info) {

        this.m_inputData = info;

        // ƹܤȿ
        this.m_identifier = info.getIdentifier();
        this.m_order = info.getOrderNo();

        // 
        if (info.getDescription() != null) {
            this.m_textDescription.setText(info.getDescription());
        }
        
        // ѥޥåɽ
        if (info.getPattern() != null) {
            this.m_textPattern.setText(info.getPattern());
        }
        
        // 롿ʤ
        if (info.getProcessType() == ProcessConstant.TYPE_YES) {
            this.m_radioProcess.setSelection(true);
        } else {
            this.m_radioNotProcess.setSelection(true);
        }
        
        // 
        if (info.getNotifyId() != null) {
            this.m_notifyId.setText(info.getNotifyId());
        }
        
        // 
        this.m_comboPriority.setText(PriorityConstant.typeToString(info.getPriority()));
        
        // åID
        if (info.getMessageId() != null) {
            this.m_textMessageId.setText(info.getMessageId());
        }
        
        // å
        if (info.getMessage() != null) {
            this.m_textMessage.setText(info.getMessage());
        }
        
        // ּ¹
        m_checkJobRun.setSelection(YesNoConstant.typeToBoolean(info.getJobRun()));
        
        // ƽ٤Υּ¹
        m_jobRun.setInputData(info);
        
        // ̵ͭ
        if (info.isValidFlg() == ValidConstant.BOOLEAN_VALID) {
            this.m_buttonValid.setSelection(true);
        }
        
        // 
        this.setEnabled(this.m_radioProcess.getSelection());
    }

    /**
     * ͤѤʸƻȽޤ
     * 
     * @return ͤݻʸƻȽ
     */
    protected MonitorStringValueInfo createInputData() {
    	MonitorStringValueInfo info = new MonitorStringValueInfo();

        info.setIdentifier(this.m_identifier);
        info.setOrderNo(this.m_order);

        // 
        if (this.m_textDescription.getText() != null
                && !"".equals((this.m_textDescription.getText()).trim())) {
            info.setDescription(this.m_textDescription.getText());
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),
                    Messages.getString("message.monitor.26"));
            return null;
        }
        
        // ѥޥåɽ
        if (this.m_textPattern.getText() != null
                && !"".equals((this.m_textPattern.getText()).trim())) {
        	
        	try{
    			Pattern.compile(this.m_textPattern.getText());
    			info.setPattern(this.m_textPattern.getText());
    		}
    		catch(PatternSyntaxException e){
    			this.setValidateResult(Messages.getString("message.hinemos.1"),
                        Messages.getString("message.monitor.27"));
                return null;
    		}
            
        } else {
            this.setValidateResult(Messages.getString("message.hinemos.1"),
                    Messages.getString("message.monitor.27"));
            return null;
        }

        // 롿ʤ
        if (this.m_radioProcess.getSelection()) {
        	info.setProcessType(ProcessConstant.TYPE_YES);
        } else {
            info.setProcessType(ProcessConstant.TYPE_NO);
        }
        String priorityText = this.m_comboPriority.getText();
        info.setPriority(PriorityConstant.stringToType(priorityText));
        
        // ID
        String notifyId = this.m_notifyId.getText();
        if (notifyId != null && !"".equals(notifyId.trim())) {
        	info.setNotifyId(notifyId);
        }

        // åID
        if (this.m_textMessageId.getText() != null
                && !"".equals((this.m_textMessageId.getText()).trim())) {
            info.setMessageId(this.m_textMessageId.getText());
        } else {
            if (this.m_radioProcess.getSelection()) {
        		this.setValidateResult(Messages.getString("message.hinemos.1"),
                        Messages.getString("message.monitor.28"));
                return null;	
            }
        }
        
        // å
        if (this.m_textMessage.getText() != null
                && !"".equals((this.m_textMessage.getText()).trim())) {
            info.setMessage(this.m_textMessage.getText());
        } else {
            if (this.m_radioProcess.getSelection()) {
        		this.setValidateResult(Messages.getString("message.hinemos.1"),
                        Messages.getString("message.monitor.29"));
                return null;	
            }
        }
        
        // ּ¹
        info.setJobRun(YesNoConstant.booleanToType(m_checkJobRun.getSelection()));
        
        // ƽ٤Υּ¹
        m_validateResult = m_jobRun.createInputData(info);
        if(m_validateResult != null){
        	return null;
        }
        
        // ͭ
        if (this.m_buttonValid.getSelection()) {
            info.setValidFlg(ValidConstant.BOOLEAN_VALID);
        } else {
            info.setValidFlg(ValidConstant.BOOLEAN_INVALID);
        }
        
        return info;
    }

    /**
     * ͥå򤷤ޤ
     * 
     * @return ڷ
     */
    protected ValidateResult validate() {
        // 
        this.m_inputData = this.createInputData();

        if (this.m_inputData != null) {
            return super.validate();
        } else {
            return m_validateResult;
        }
    }

    /**
     * ϣ˥ܥΥƥȤ֤ޤ
     * 
     * @return ϣ˥ܥΥƥ
     */
    protected String getOkButtonText() {
        return Messages.getString("ok");
    }

    /**
     * 󥻥ܥΥƥȤ֤ޤ
     * 
     * @return 󥻥ܥΥƥ
     */
    protected String getCancelButtonText() {
        return Messages.getString("cancel");
    }

    /**
     * ϾEnabledꤷޤ
     *  
     */
    private void setEnabled(boolean enable) {

    	if(enable){
        	this.m_jobRun.setEnabled(this.m_checkJobRun.getSelection());
        }
        else{
        	this.m_jobRun.setEnabled(enable);
        }
    	this.m_notifyId.setEnabled(enable);
    	this.m_comboPriority.setEnabled(enable);
        this.m_textMessageId.setEnabled(enable);
        this.m_textMessage.setEnabled(enable);
        this.m_checkJobRun.setEnabled(enable);
    }
    
    /**
     * ̵ͤξꤷޤ
     *  
     */
    private void setValidateResult(String id, String message) {

        this.m_validateResult = new ValidateResult();
        this.m_validateResult.setValid(false);
        this.m_validateResult.setID(id);
        this.m_validateResult.setMessage(message);
    }
}