/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorTruthValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;
import com.clustercontrol.util.Messages;

/**
 * ʹƻ Ρñ̤νپ󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class TruthValueInfoComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //
	
	/** Ƚܣ */
    private String m_itemTrue = null;
    
    /** Ƚܣ */
    private String m_itemFalse = null;

    /** ͼ True */
    private Combo m_comboTrue = null;
    
    /** ͼ False */
    private Combo m_comboFalse = null;

    /** ͼμԻ */
    private Combo m_comboFailurePriority = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     */
    /**
     * @param parent ƤΥݥå
     * @param style 
     * @param range ϰȽե饰
     * @param item1 Ƚ̾
     * @param item2 Ƚ̾
     */
    public TruthValueInfoComposite(Composite parent, int style, boolean rangeFlg, String itemTrue, String itemFalse) {
        super(parent, style);
        
        m_itemTrue = itemTrue;
        m_itemFalse = itemFalse;
        
        this.initialize();
    }
    
    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
    	
    	// ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;
        this.setLayout(layout);
        
        // ٥
        // ͼ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("successful.select.value") + " : ");
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("value"));
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("priority"));
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        /*
         * ͤTrueξ
         */
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_itemTrue + " : ");
        
        // 
        this.m_comboTrue = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboTrue.setLayoutData(gridData);
        this.m_comboTrue.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboTrue.add(PriorityConstant.STRING_WARNING);
        this.m_comboTrue.add(PriorityConstant.STRING_INFO);
        this.m_comboTrue.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboTrue.setText(PriorityConstant.STRING_WARNING);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
                
        /*
         * ͤFalseξ
         */
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(m_itemFalse + " : ");
        
        // 
        this.m_comboFalse = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFalse.setLayoutData(gridData);
        this.m_comboFalse.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFalse.add(PriorityConstant.STRING_WARNING);
        this.m_comboFalse.add(PriorityConstant.STRING_INFO);
        this.m_comboFalse.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFalse.setText(PriorityConstant.STRING_WARNING);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 5;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
        
        // ͼμԻ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("failure.select.value") + " : ");
        
        // 
        this.m_comboFailurePriority = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData(gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_WARNING);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
			
	        ArrayList list = info.getJudgementInfo();
	        if(list != null){
	            for(int index=0; index<list.size(); index++){
	            	MonitorTruthValueInfo truthValueInfo = (MonitorTruthValueInfo)list.get(index);
	            	if(truthValueInfo != null){
	                	if(truthValueInfo.getTruthValue() == TruthConstant.TYPE_TRUE){
	                		this.m_comboTrue.setText(PriorityConstant.typeToString(truthValueInfo.getPriority()));
	                	}
	                	else if(truthValueInfo.getTruthValue() == TruthConstant.TYPE_FALSE){
	                		this.m_comboFalse.setText(PriorityConstant.typeToString(truthValueInfo.getPriority()));
	                	}
	            	}
	            }
	        }
	        this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getFailurePriority()));
		}
	}

	/**
     * ͤѤƥΡñ̤ηȽޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
        ArrayList<MonitorTruthValueInfo> valueList = new ArrayList<MonitorTruthValueInfo>();
        
        // ͤTrueξ
        MonitorTruthValueInfo valueInfo = new MonitorTruthValueInfo();
        valueInfo.setMonitorId(info.getMonitorId());
        valueInfo.setMonitorTypeId(info.getMonitorTypeId());
        valueInfo.setTruthValue(TruthConstant.TYPE_TRUE);
        valueInfo.setPriority(PriorityConstant.stringToType(this.m_comboTrue.getText()));
        valueList.add(valueInfo);
        
        valueInfo = new MonitorTruthValueInfo();
        valueInfo.setMonitorId(info.getMonitorId());
        valueInfo.setMonitorTypeId(info.getMonitorTypeId());
        valueInfo.setTruthValue(TruthConstant.TYPE_FALSE);
        valueInfo.setPriority(PriorityConstant.stringToType(this.m_comboFalse.getText()));
        valueList.add(valueInfo);
        
        info.setJudgementInfo(valueList);
        
        // ͼμԻ
        info.setFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriority.getText()));

		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_comboTrue.setEnabled(enabled);
		this.m_comboFalse.setEnabled(enabled);
		this.m_comboFailurePriority.setEnabled(enabled);
	}
	
	/**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
}