/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

import com.clustercontrol.bean.ProcessConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.util.Messages;

/**
 * ʸƻȽ ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringValueListComposite extends Composite {
	
	// ----- instance ե ----- //
	
	/** ơ֥ӥ塼 */
	private StringValueListTableViewer m_tableViewer = null;
	
	/** ơ֥ */
	private ArrayList m_tableDefine = null;
	
	/** IDե饰 */
	private boolean m_notify = false;
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * 󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param style 
	 */
	public StringValueListComposite(Composite parent, int style) {
		super(parent, style);
		
		this.initialize();
	}
	
	/**
	 * 󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param style 
	 * @param tableDefine ơ֥
	 */
	public StringValueListComposite(Composite parent, int style, ArrayList tableDefine) {
		super(parent, style);
		
		this.m_tableDefine = tableDefine;
		
		this.initialize();
	}
	
	// ----- instance ᥽å ----- //
	
	/**
	 * ݥåȤۤޤ
	 */
	private void initialize() {
		GridLayout layout = new GridLayout(1, true);
		this.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		
		Table table = new Table(this, SWT.SINGLE | SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		GridData gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		table.setLayoutData(gridData);
		
		// ơ֥ӥ塼κ
		this.m_tableViewer = new StringValueListTableViewer(table);
		this.m_tableViewer.createTableColumn(this.m_tableDefine);
		
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
	}
	
	/**
	 * tableViewer֤ޤ
	 * 
	 * @return tableViewer
	 */
	public StringValueListTableViewer getTableViewer() {
		return this.m_tableViewer;
	}
	
	/**
	 * 򤵤Ƥ륢ƥ֤ޤ
	 * <p>
	 * 
	 * 򤵤Ƥʤϡnull֤ޤ
	 * 
	 * @return 򥢥ƥ
	 */
	public MonitorStringValueInfo getFilterItem() {
		StructuredSelection selection = (StructuredSelection) this.m_tableViewer.getSelection();
		
		if (selection == null) {
			return null;
		} else {
			return (MonitorStringValueInfo) selection.getFirstElement();
		}
	}
	
	/**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo monitorInfo) {
		
		if(monitorInfo != null){
			// ʸƻȽ
			StringValueInfoManager.getInstance().initialize(monitorInfo);
			// ǡ
			Object[] list = StringValueInfoManager.getInstance().get();
			
			// ơ֥빹
			this.m_tableViewer.setInput(list);
		}
	}
	
	/**
     * ݥåȤ򹹿ޤ
     * 
     */
    public void update() {
        // ǡ
        Object[] list = StringValueInfoManager.getInstance().get();

        // ơ֥빹
        this.m_tableViewer.setInput(list);
    }
	
	/**
     * ͤѤƴƻޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo monitorInfo) {
		
		m_notify = false;
		ArrayList list = StringValueInfoManager.getInstance().getMonitorStringValueInfo();

		if(list != null && list.size() > 0){
			String MonitorTypeId = monitorInfo.getMonitorTypeId();
			String MonitorId = monitorInfo.getMonitorId();
			
			for(int index=0; index<list.size(); index++){
				MonitorStringValueInfo info = (MonitorStringValueInfo)list.get(index);
				info.setMonitorTypeId(MonitorTypeId);
				info.setMonitorId(MonitorId);
				
				if(info.getNotifyId() != null && !"".equals(info.getNotifyId())){
					if(info.getProcessType() == ProcessConstant.TYPE_YES){
						m_notify = true;
					}
				}
			}
			monitorInfo.setJudgementInfo(list);
		}
		else{
			return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.32"));
		}
		return null;
	}
	
	/**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }

	/**
	 * IDꤵƤ뤫֤ޤ
	 * 
	 * @return 1ǤIDꤵƤϡtrue
	 */
	public boolean isNotify() {
		return m_notify;
	}
}