/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.dialog.StringValueInfoCreateDialog;
import com.clustercontrol.monitor.run.util.StringValueInfoManager;
import com.clustercontrol.util.Messages;

/**
 * ʸƻȽ Ρñ̤νپ󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringValueInfoComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //

    /** ե륿 */
    private StringValueListComposite m_infoList = null;

    /** ɲåܥ */
    private Button m_buttonAdd = null;

    /** ѹܥ */
    private Button m_buttonModify = null;

    /** ܥ */
    private Button m_buttonDelete = null;

    /** ܥ */
    private Button m_buttonUp = null;

    /** ܥ */
    private Button m_buttonDown = null;
    
    /** ͼμԻ */
    private Combo m_comboFailurePriority = null;
    
    
    // ----- 󥹥ȥ饯 ----- //
    
    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     * @param tableDefine ơ֥
     */
    public StringValueInfoComposite(Composite parent, int style, ArrayList tableDefine) {
    	super(parent, style);
    	
        this.initialize(tableDefine);
    }

    /**
     * ݥåȤۤޤ
     */
    private void initialize(ArrayList tableDefine) {

    	// ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;
        this.setLayout(layout);
        
        // ٥
        // ͼ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 15;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("successful.select.value") + " : ");

        /*
         * ʸƻȽ
         */
        this.m_infoList = new StringValueListComposite(this, SWT.BORDER, tableDefine);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 13;
        this.m_infoList.setLayoutData(gridData);

        /*
         * ܥ
         */
        Composite composite = new Composite(this, SWT.NONE);
        layout = new GridLayout(1, true);
        layout.numColumns = 1;
        composite.setLayout(layout);
        gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        composite.setLayoutData(gridData);

        // ɲåܥ
        this.m_buttonAdd = this.createButton(composite, Messages.getString("add"));
        this.m_buttonAdd.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
            	
            	// 
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            	
            	StringValueInfoCreateDialog dialog = new StringValueInfoCreateDialog(shell);
                if (dialog.open() == IDialogConstants.OK_ID) {
                	StringValueInfoManager.getInstance().add(dialog.getInputData());
                	m_infoList.update();
                }
            }
        });

        // ѹܥ
        this.m_buttonModify = this.createButton(composite, Messages.getString("modify"));
        this.m_buttonModify.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                String identifier = getSelectIdentifier();
                if (identifier != null) {
                	
                	// 
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                	
                    StringValueInfoCreateDialog dialog = new StringValueInfoCreateDialog(shell, identifier);
                    if (dialog.open() == IDialogConstants.OK_ID) {
                        Table table = m_infoList.getTableViewer().getTable();
                        int selectIndex = table.getSelectionIndex();
                        StringValueInfoManager.getInstance().modify(dialog.getInputData());
                        m_infoList.update();
                        table.setSelection(selectIndex);
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                	box.setText(Messages.getString("warning"));
                	box.setMessage(Messages.getString("message.monitor.30"));
                	box.open();
                }
            }
        });

        // ܥ
        this.m_buttonDelete = this.createButton(composite, Messages.getString("delete"));
        this.m_buttonDelete.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                MonitorStringValueInfo info = m_infoList.getFilterItem();

                if (info != null) {
                    String detail = info.getDescription();

                    MessageBox box = new MessageBox(getShell(), SWT.OK
                            | SWT.CANCEL | SWT.ICON_WARNING);
                    box.setText(Messages.getString("confirmed"));
                    String[] args = { detail };
                    String message = Messages.getString("message.monitor.31", args);
                    box.setMessage(message);

                    if (box.open() == SWT.OK) {
                    	StringValueInfoManager.getInstance().delete(getSelectIdentifier());
                        m_infoList.update();
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                	box.setText(Messages.getString("warning"));
                	box.setMessage(Messages.getString("message.monitor.30"));
                	box.open();
                }
            }
        });

        // إܥ
        label = new Label(composite, SWT.NONE);	// ߡ
        this.m_buttonUp = this.createButton(composite, Messages.getString("up"));
        this.m_buttonUp.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                String identifier = getSelectIdentifier();
                if (identifier != null) {
                    if (StringValueInfoManager.getInstance().upOrder(identifier)) {
                        m_infoList.update();
                        selectItem(identifier);
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                	box.setText(Messages.getString("warning"));
                	box.setMessage(Messages.getString("message.monitor.30"));
                	box.open();
                }
            }
        });

        // إܥ
        this.m_buttonDown = this.createButton(composite, Messages.getString("down"));
        this.m_buttonDown.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                String identifier = getSelectIdentifier();
                if (identifier != null) {
                    if (StringValueInfoManager.getInstance().downOrder(getSelectIdentifier())) {
                        m_infoList.update();
                        selectItem(identifier);
                    }
                }
                else{
                	MessageBox box = new MessageBox(getShell(), SWT.OK | SWT.ICON_WARNING);
                	box.setText(Messages.getString("warning"));
                	box.setMessage(Messages.getString("message.monitor.30"));
                	box.open();
                }
            }
        });
        
        // ͼμԻ
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("failure.select.value") + " : ");
        
        // 
        this.m_comboFailurePriority = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboFailurePriority.setLayoutData(gridData);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_CRITICAL);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_WARNING);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_INFO);
        this.m_comboFailurePriority.add(PriorityConstant.STRING_UNKNOWN);
        this.m_comboFailurePriority.setText(PriorityConstant.STRING_UNKNOWN);
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }
    
    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
			this.m_infoList.setInputData(info);
	        this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getFailurePriority()));
		}
	}

	/**
     * ͤѤƴƻޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
		// ʸƻȽ
		ValidateResult validateResult = m_infoList.createInputData(info);
        if(validateResult != null){
        	return validateResult;
        }
		
		// ͼμԻ
        info.setFailurePriority(PriorityConstant.stringToType(this.m_comboFailurePriority.getText()));
		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_buttonAdd.setEnabled(enabled);
		this.m_buttonModify.setEnabled(enabled);
		this.m_buttonDelete.setEnabled(enabled);
		this.m_buttonUp.setEnabled(enabled);
		this.m_buttonDown.setEnabled(enabled);
		this.m_comboFailurePriority.setEnabled(enabled);
	}
	
	/**
     * ̤Υܥޤ
     * 
     * @param parent ƤΥݥå
     * @param label ܥΥ٥
     * @return 줿ܥ
     */
	protected Button createButton(Composite parent, String label) {
        Button button = new Button(parent, SWT.NONE);

        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        button.setLayoutData(gridData);

        button.setText(label);

        return button;
    }

    /**
     * 򤵤ƤʸƻȽμ̻Ҥ֤ޤ
     * 
     * @return ̻ҡ򤵤Ƥʤϡnull
     */
	protected String getSelectIdentifier() {
        StructuredSelection selection = (StructuredSelection) this.m_infoList.getTableViewer().getSelection();

        if (selection.getFirstElement() instanceof MonitorStringValueInfo) {
        	MonitorStringValueInfo filterInfo = (MonitorStringValueInfo) selection.getFirstElement();
        	
            return filterInfo.getIdentifier();
        } else {
            return null;
        }
    }

    /**
     * ꤷʸƻȽιԤ֤ˤޤ
     * 
     * @param identifier ̻
     */
	protected void selectItem(String identifier) {
        Table table = this.m_infoList.getTableViewer().getTable();
        TableItem[] items = table.getItems();

        if (items == null || identifier == null) {
            return;
        }

        for (int i = 0; i < items.length; i++) {

            if (items[i].getData() instanceof MonitorStringValueInfo) {
            	MonitorStringValueInfo filterInfo = (MonitorStringValueInfo) items[i].getData();
                if (identifier.equals(filterInfo.getIdentifier())) {
                    table.select(i);
                    return;
                }
            }
        }
    }
    
    /**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
    
    /**
	 * IDꤵƤ뤫֤ޤ
	 * 
	 * @return 1ǤIDꤵƤϡtrue
	 */
	public boolean isNotify() {
		return m_infoList.isNotify();
	}
}