/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PriorityConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.jobmanagement.common.composite.JobIdSelectionListener;
import com.clustercontrol.monitor.run.bean.MonitorStringValueInfo;
import com.clustercontrol.monitor.run.bean.TruthConstant;
import com.clustercontrol.util.Messages;

/**
 * ʸƻȽ ¹ԥ־󥳥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class StringRunJobComposite extends Composite {
	
	public static final int WIDTH_JOB_ID	 = 4;
	public static final int WIDTH_REF_BTN = 2;
	public static final int WIDTH_INHIBITION_FLG = 3;
	public static final int WIDTH_FAILURE_PRIORITY = 2;
	
	/** ID */
	private Text m_textJobId = null;
	/** ȥܥ */
	private Button m_buttonRefer = null;
	/** Ϣư */ 
	private Button m_checkInhibitionFlg = null;
	/** ƤӽФԻ */ 
	private Combo m_comboFailurePriority = null;
	
	
	/**
	 * 󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param style 
	 */
	public StringRunJobComposite(Composite parent, int style) {
		super(parent, style);
		
		this.initialize();
	}
	
	/**
	 * ݥåȤۤޤ
	 */
	private void initialize() {
		
		// ѿȤѤ٥
		Label label = null;
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 15;	
		this.setLayout(layout);
		
		// ID
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_JOB_ID + WIDTH_REF_BTN;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("job.id"));
		
		// 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
		
		// Ϣư
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_INHIBITION_FLG;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("couple.with.notify.inhibition"));
		
		// 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
		
		// ƽмԻ
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_FAILURE_PRIORITY + 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("failure.call.value"));
		
		// 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
		
		/*
         * ¹ԥ
         */
		this.m_textJobId = this.getTextJobId(this, WIDTH_JOB_ID);
		this.m_buttonRefer = this.getButtonRefer(this, WIDTH_REF_BTN);
		this.m_buttonRefer.addSelectionListener(new JobIdSelectionListener(m_textJobId));
		
		// 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
		
		this.m_checkInhibitionFlg = this.getCheckBox(this, WIDTH_INHIBITION_FLG);
		
		// 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        
		this.m_comboFailurePriority = this.getComboPriority(this, WIDTH_FAILURE_PRIORITY);
		
		// 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
	}
	
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param info ͤȤѤʸƻȽ
	 */
	public void setInputData(MonitorStringValueInfo info) {
		
		if(info != null){
			if(info.getJobId() != null){
				this.m_textJobId.setText(info.getJobId());
			}
			this.m_checkInhibitionFlg.setSelection(YesNoConstant.typeToBoolean(info.getJobInhibitionFlg()));
			this.m_comboFailurePriority.setText(PriorityConstant.typeToString(info.getJobFailurePriority()));
		}
	}
	
	/**
	 * ͤѤƴƻޤ
	 * 
	 * @return ڷ
	 */
	public ValidateResult createInputData(MonitorStringValueInfo info) {
		
		ValidateResult validateResult = setMonitorStringValueInfo(info, this.m_textJobId, this.m_checkInhibitionFlg, this.m_comboFailurePriority, TruthConstant.TYPE_TRUE);
		
		return validateResult;
	}
	
	/**
	 * ͤѤƥּ¹ԡIDϢư ڤ ƽмԻꤷޤ
	 * 
	 * @param info ʸƻȽ
	 * @param textJobId IDƥȥܥå
	 * @param buttonRefer ȥܥ
	 * @param checkInhibitionFlg ȤϢư
	 * @param comboFailurePriority	ƽмԻ
	 * @param truthValue 
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ValidateResult setMonitorStringValueInfo(MonitorStringValueInfo info, Text textJobId, Button checkInhibitionFlg, Combo comboFailurePriority, int truthValue) {
		
		String jobId = textJobId.getText();
		Integer jobInhibitionFlg = Integer.valueOf(YesNoConstant.booleanToType(checkInhibitionFlg.getSelection()));
		Integer jobFailurePriority = PriorityConstant.stringToType(comboFailurePriority.getText());
		
		if(info == null){
			info = new MonitorStringValueInfo();
		}
		
		// ID
		if (jobId != null && !"".equals(jobId.trim())) {
			info.setJobId(jobId);	
		}
		else{
			if(info.getJobRun() == YesNoConstant.TYPE_YES){
				String[] args = {""};
				return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.25", args));
			}
		}
		// Ϣư
		info.setJobInhibitionFlg(jobInhibitionFlg);
		// ƽмԻ
		info.setJobFailurePriority(jobFailurePriority);
		
		return null;
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		setEnabled(enabled, m_textJobId, m_buttonRefer, m_checkInhibitionFlg, m_comboFailurePriority);
	}
	
	/**
	 * ݥåȤEnabledꤷޤ
	 * 
	 * @param enabled
	 * @param textJobId IDƥȥܥå
	 * @param buttonRefer ȥܥ
	 * @param checkInhibitionFlg ȤϢư
	 * @param comboFailurePriority	ƽмԻ
	 */
	public void setEnabled(boolean enabled,
			Text textJobId,
			Button buttonRefer,
			Button checkInhibitionFlg,
			Combo comboFailurePriority) {
		
		textJobId.setEnabled(enabled);
		buttonRefer.setEnabled(enabled);
		checkInhibitionFlg.setEnabled(enabled);
		comboFailurePriority.setEnabled(enabled);
	}
	
	/**
	 * ٥ܥܥå֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Combo getComboPriority(Composite parent, int horizontalSpan) {
		
		Combo combo = new Combo(this, SWT.DROP_DOWN | SWT.READ_ONLY);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		combo.setLayoutData(gridData);
		combo.add(PriorityConstant.STRING_CRITICAL);
		combo.add(PriorityConstant.STRING_WARNING);
		combo.add(PriorityConstant.STRING_INFO);
		combo.add(PriorityConstant.STRING_UNKNOWN);
		combo.setText(PriorityConstant.STRING_UNKNOWN);
		
		return combo;
	}
	
	/**
	 * åܥå֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Button getCheckBox(Composite parent, int horizontalSpan) {
		
		// åܥå
		Button button = new Button(parent, SWT.CHECK);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.CENTER;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		
		return button;
	}
	
	/**
	 * IDƥȥܥå֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Text getTextJobId(Composite parent, int horizontalSpan) {
		
		Text text = new Text(this, SWT.BORDER | SWT.LEFT | SWT.READ_ONLY);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		text.setLayoutData(gridData);
		
		return text;
	}
	
	/**
	 * ȥܥ֤ޤ
	 * 
	 * @param parent ƤΥ󥹥
	 * @param horizontalSpan 
	 * @return
	 */
	protected Button getButtonRefer(Composite parent, int horizontalSpan) {
		
		Button button = new Button(this, SWT.NONE);
		GridData gridData = new GridData();
		gridData.horizontalSpan = horizontalSpan;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		button.setLayoutData(gridData);
		button.setText(Messages.getString("refer"));
		
		return button;
	}
	
	
	/**
	 * ̵ͤξꤷޤ
	 *  
	 */
	protected ValidateResult setValidateResult(String id, String message) {
		
		ValidateResult validateResult = new ValidateResult();
		validateResult.setValid(false);
		validateResult.setID(id);
		validateResult.setMessage(message);
		
		return validateResult;
	}
}