/*
 
 Copyright (C) 2006 NTT DATA Corporation
 
 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License 
 as published by the Free Software Foundation, version 2.
 
 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied 
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 PURPOSE.  See the GNU General Public License for more details.
 
 */

package com.clustercontrol.monitor.run.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.composite.PositiveNumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * ƻʥॢȴޤ˥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.1.0
 */
public class MonitorRuleTimeoutComposite extends MonitorRuleComposite {
	
	// ----- instance ե ----- //
	
	/** ॢ */
	protected Text m_textTimeout = null;
	
	/** ॢȥ٥ */
	private String m_timeoutText = Messages.getString("time.out.sec");
	
	
	// ----- 󥹥ȥ饯 ----- //
	
	/**
	 * 󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param style 
	 */
	public MonitorRuleTimeoutComposite(Composite parent, int style) {
		super(parent, style);
		
		this.initialize();
	}
	
	/**
	 * 󥹥󥹤֤ޤ
	 * 
	 * @param parent ƤΥݥå
	 * @param style 
	 */
	public MonitorRuleTimeoutComposite(Composite parent, int style, String label) {
		super(parent, style);
		
		m_timeoutText = label;
		
		this.initialize();
	}
	
	/**
	 * ݥåȤۤޤ
	 */
	private void initialize() {
		
		// ѿȤѤ٥
		Label label = null;
		// ѿȤѤ륰åɥǡ
		GridData gridData = null;
		
		GridLayout layout = new GridLayout(1, true);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = 15;	
		this.setLayout(layout);
		
		/*
		 * ॢ
		 */
		/*
		 * ॢ(ߥ)
		 */
		// ٥
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(m_timeoutText + " : ");
		// ܥܥå
		this.m_textTimeout = new Text(this, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_VALUE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.m_textTimeout.addVerifyListener(new PositiveNumberVerifyListener());
		this.m_textTimeout.setLayoutData(gridData);
		
		// 
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_WHITE_SPACE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		
	}
	
	/**
	 * ƹܤͤꤷޤ
	 * 
	 * @param info ͤȤѤƻ
	 */
	public void setInputData(MonitorInfo info) {
		
		super.setInputData(info);
		
		if(info != null){
			this.m_textTimeout.setText(Integer.toString(info.getTimeout()));
		}
	}
	
	/**
	 * ͤѤƴƻޤ
	 * 
	 * @return ڷ
	 */
	public ValidateResult createInputData(MonitorInfo info) {
		
		ValidateResult validateResult = super.createInputData(info);
		
		if(validateResult != null){
			return validateResult;
		}
		else{
			if (this.m_textTimeout.getText() != null
					&& !"".equals((this.m_textTimeout.getText()).trim())) {
				
				int timeout = -1;
				try {
					timeout = Integer.valueOf(this.m_textTimeout.getText());
					if(timeout > info.getRunInterval()){
						return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.43"));
					}
					info.setTimeout(timeout);
				} catch (NumberFormatException e) {
					return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.42"));
				}
			}
			else{
				return setValidateResult(Messages.getString("message.hinemos.1"), Messages.getString("message.monitor.42"));
			}
		}
		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		
		super.setEnabled(enabled);
		this.m_textTimeout.setEnabled(enabled);
	}
	
	/**
	 * ̵ͤξꤷޤ
	 *  
	 */
	protected ValidateResult setValidateResult(String id, String message) {
		
		ValidateResult validateResult = new ValidateResult();
		validateResult.setValid(false);
		validateResult.setID(id);
		validateResult.setMessage(message);
		
		return validateResult;
	}
}