/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.composite.NumberVerifyListener;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * ƻ¹Դֳ֥ݥåȥ饹Ǥ
 * 
 * @version 2.0.0
 * @since 2.0.0
 */
public class MonitorRuleTextComposite extends Composite {
	
	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

    // ----- instance ե ----- //

    /** ¹Դֳ */
    private Text m_comboRunInterval = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     */
    public MonitorRuleTextComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }
    
    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
    	
    	// ѿȤѤ٥
        Label label = null;
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 15;	
        this.setLayout(layout);
        
        /*
         * ¹Դֳ֡ʬ
         */
        // ٥
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_TITLE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
        label.setText(Messages.getString("run.interval.minute") + " : ");
        // ƥ
        this.m_comboRunInterval = new Text(this, SWT.BORDER);
        gridData = new GridData();
        gridData.horizontalSpan = WIDTH_VALUE;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_comboRunInterval.setLayoutData(gridData);
        this.m_comboRunInterval.addVerifyListener(new NumberVerifyListener());
        
        // 
        label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 8;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
	}

    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
	        	int interval = new Integer(info.getRunInterval() / 60);
	            this.m_comboRunInterval.setText(Integer.toString(interval));
		}
	}

	/**
     * ͤѤƴƻޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
		if(info != null){
	        if (this.m_comboRunInterval.getText() != null
	                && !"".equals((this.m_comboRunInterval.getText()).trim())) {
	        	Integer interval = Integer.parseInt(this.m_comboRunInterval.getText());
	        	interval = new Integer(interval.intValue() * 60);
	        	info.setRunInterval(interval);
	        } else {
	        	return setValidateResult(Messages.getString("message.hinemos.1"),Messages.getString("message.monitor.11"));
	        }
		}
		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_comboRunInterval.setEnabled(enabled);
	}
	
	/**
     * ̵ͤξꤷޤ
     *  
     */
    protected ValidateResult setValidateResult(String id, String message) {

    	ValidateResult validateResult = new ValidateResult();
        validateResult.setValid(false);
        validateResult.setID(id);
        validateResult.setMessage(message);
        
        return validateResult;
    }
}