/*
 
Copyright (C) 2006 NTT DATA Corporation
 
This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License 
as published by the Free Software Foundation, version 2.
 
This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied 
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
PURPOSE.  See the GNU General Public License for more details.
 
*/

package com.clustercontrol.monitor.run.composite;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.bean.MonitorBlockConstant;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.monitor.run.bean.MonitorInfo;
import com.clustercontrol.util.Messages;

/**
 * ƻñ̥ݥåȥ饹Ǥ
 * 
 * @version 2.1.0
 * @since 2.0.0
 */
public class MonitorBlockComposite extends Composite {

    // ----- instance ե ----- //

    /** ƻñ̡Ρ */
    private Button m_radioNode = null;

    /** ƻñ̡ */
    private Button m_radioScope = null;
    
//    /** ƻñ̡פȥΡ */
//    private Button m_radioScopeNode = null;


    // ----- 󥹥ȥ饯 ----- //

    /**
     * 󥹥󥹤֤ޤ
     * 
     * @param parent ƤΥݥå
     * @param style 
     */
    public MonitorBlockComposite(Composite parent, int style) {
        super(parent, style);
        
        this.initialize();
    }
    
    /**
     * ݥåȤۤޤ
     */
    private void initialize() {
    	
        // ѿȤѤ륰åɥǡ
        GridData gridData = null;
        
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
    	layout.numColumns = 5;	
        this.setLayout(layout);
        
        /*
         * ƻñ
         */
        // Ρ
        this.m_radioNode = new Button(this, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioNode.setLayoutData(gridData);
        this.m_radioNode.setText(Messages.getString("node"));

        // 
        this.m_radioScope = new Button(this, SWT.RADIO);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        this.m_radioScope.setLayoutData(gridData);
        this.m_radioScope.setText(Messages.getString("scope"));
        
        // פȥΡ
//        this.m_radioScopeNode = new Button(this, SWT.RADIO);
//        gridData = new GridData();
//        gridData.horizontalSpan = 1;
//        gridData.horizontalAlignment = GridData.FILL;
//        gridData.grabExcessHorizontalSpace = true;
//        this.m_radioScopeNode.setLayoutData(gridData);
//        this.m_radioScopeNode.setText(Messages.getString("scope.node"));
        
        // 
        Label label = new Label(this, SWT.NONE);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        label.setLayoutData(gridData);
    }

    /**
     * ƹܤͤꤷޤ
     * 
     * @param info ͤȤѤƻ
     */
	public void setInputData(MonitorInfo info) {
		
		if(info != null){
//			if(info.getMonitorBlock() == MonitorBlockConstant.TYPE_ALL) {
//				this.m_radioScopeNode.setSelection(true);
            if(info.getMonitorBlock() == MonitorBlockConstant.TYPE_SCOPE) {
                this.m_radioScope.setSelection(true);
            }
            else{
                this.m_radioNode.setSelection(true);
            }
		}
	}

	/**
     * ͤѤƴƻޤ
     * 
     * @return ڷ
     */
	public ValidateResult createInputData(MonitorInfo info) {
		
		if(info != null){
//			if (this.m_radioScopeNode.getSelection()) {
//				info.setMonitorBlock(MonitorBlockConstant.TYPE_ALL);
	        if (this.m_radioScope.getSelection()) {
	            info.setMonitorBlock(MonitorBlockConstant.TYPE_SCOPE);
	        }else {
	            info.setMonitorBlock(MonitorBlockConstant.TYPE_NODE);
	        }
		}
		return null;
	}
	
	/* ( Javadoc)
	 * @see org.eclipse.swt.widgets.Control#setEnabled(boolean)
	 */
	@Override
	public void setEnabled(boolean enabled) {
		this.m_radioNode.setEnabled(enabled);
		this.m_radioScope.setEnabled(enabled);
//		this.m_radioScopeNode.setEnabled(enabled);
	}
}